/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier;

import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.ApplicationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.deploy.verifier.entity.EntityBMPCheck;
import com.sap.engine.services.ejb.deploy.verifier.entity.EntityCMP11Check;
import com.sap.engine.services.ejb.deploy.verifier.entity.EntityCMP20Check;
import com.sap.engine.services.ejb.deploy.verifier.message.MessageBeanCheck;
import com.sap.engine.services.ejb.deploy.verifier.session.SessionBeanCheck;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDeploymentException;
import java.util.Enumeration;
import java.util.Vector;

public class Verifier {
    public static void check(ApplicationDescriptor appDescr, ClassLoader appLoader, Vector warnings) throws EJBDeploymentException {
        Vector results = new Vector();
        EJBJarDescriptor[] ejbJars = appDescr.getEJBJarDescriptors();
        int j = 0;
        while (j < ejbJars.length) {
            DeploymentDescriptor[] descriptors = ejbJars[j].getDDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                boolean isReadOnlyCMP = Verifier.checkBean(descriptors[i], results, appLoader);
                if (isReadOnlyCMP) {
                    Verifier.checkReadOnlyBean(descriptors[i], ejbJars[j]);
                }
                ++i;
            }
            ++j;
        }
        String errorMsg = "";
        Enumeration e = results.elements();
        while (e.hasMoreElements()) {
            String msg = (String)e.nextElement();
            if (msg.startsWith("Warning")) {
                warnings.add(msg);
                continue;
            }
            errorMsg = errorMsg + "\n" + msg;
        }
        if (errorMsg.length() > 0) {
            throw new EJBDeploymentException("ejb_2016", new Object[]{appDescr.getName(), errorMsg});
        }
    }

    private static void checkReadOnlyBean(DeploymentDescriptor d, EJBJarDescriptor ejbJar) throws EJBDeploymentException {
        CMPEntityDescriptor cmpDescr = (CMPEntityDescriptor)d;
        AbstractSchema abstrSchema = ejbJar.getAbstractSchema();
        RelationDescriptor[] relationships = abstrSchema.getRelationDescriptors(cmpDescr.getId());
        if (relationships.length > 0) {
            throw new EJBDeploymentException("ejb_2017", new Object[]{ejbJar.getJarName(), d.getEjbName()});
        }
    }

    private static boolean checkBean(DeploymentDescriptor descriptor, Vector results, ClassLoader appLoader) {
        if (descriptor instanceof SessionDescriptor) {
            SessionBeanCheck.check((SessionDescriptor)descriptor, results, appLoader);
        } else if (descriptor instanceof MessageDrivenDescriptor) {
            MessageBeanCheck.check((MessageDrivenDescriptor)descriptor, results, appLoader);
        } else {
            if (descriptor instanceof CMPEntityDescriptor) {
                CMPEntityDescriptor cmpDescr = (CMPEntityDescriptor)descriptor;
                if (cmpDescr.getCmpVersion() == 2) {
                    EntityCMP20Check.check(cmpDescr, results, appLoader);
                } else {
                    EntityCMP11Check.check(cmpDescr, results, appLoader);
                }
                return cmpDescr.isReadOnly();
            }
            EntityBMPCheck.check((EntityDescriptor)descriptor, results, appLoader);
        }
        return false;
    }
}

