/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier;

import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.verifier.BusinessMethodCheck;
import com.sap.engine.services.ejb.deploy.verifier.CheckUtils;
import com.sap.engine.services.ejb.deploy.verifier.RmiIiopUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Vector;

public class RemoteInterfaceCheck {
    static /* synthetic */ Class class$javax$ejb$EJBObject;

    public static void check(DeploymentDescriptor descr, Class intf, Class beanClass, Vector results) {
        if (intf == null) {
            return;
        }
        String beanName = descr.getEjbName();
        if (!(class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = RemoteInterfaceCheck.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject).isAssignableFrom(intf)) {
            results.add("Error in the remote interface " + intf.getName() + " of bean " + beanName + ": the remote interface does not extend javax.ejb.EJBObject. The remote interfaces must extend javax.ejb.EJBObject.");
        }
        if (!Modifier.isPublic(intf.getModifiers())) {
            results.add("Error in the remote interface " + intf.getName() + " of bean " + beanName + ": the remote interface is not defined as public. All remote interfaces must be defined as public.");
        }
        if (!RmiIiopUtils.isValidRmiIIOPInterface(intf)) {
            results.add("Error in the remote interface " + intf.getName() + " of bean " + beanName + ": the remote interface must be valid RMI-IIOP remote interface.");
        }
        Method[] businessMethods = intf.getMethods();
        Method[] beanMethods = beanClass.getMethods();
        boolean beanClassExposedInRemoteIntf = false;
        int i = 0;
        while (i < businessMethods.length) {
            if (businessMethods[i].getReturnType().getName().equals(beanClass.getName())) {
                beanClassExposedInRemoteIntf = true;
            }
            if (!businessMethods[i].getDeclaringClass().getName().equals("javax.ejb.EJBObject")) {
                BusinessMethodCheck.check(beanName, businessMethods[i], true, false, results);
                boolean businessMethodFound = false;
                int j = 0;
                while (j < beanMethods.length) {
                    if (businessMethods[i].getName().equals(beanMethods[j].getName())) {
                        Object[] businessMethodParams = businessMethods[i].getParameterTypes();
                        Object[] beanMethodParams = beanMethods[j].getParameterTypes();
                        if (Arrays.equals(beanMethodParams, businessMethodParams)) {
                            Class<?> beanMethodReturn;
                            Class<?> businessMethodReturn;
                            Class[] businessMethodExc = businessMethods[i].getExceptionTypes();
                            Class[] beanMethodExc = beanMethods[j].getExceptionTypes();
                            if (CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(beanMethodExc, businessMethodExc) && (businessMethodReturn = businessMethods[i].getReturnType()).equals(beanMethodReturn = beanMethods[j].getReturnType())) {
                                businessMethodFound = true;
                                BusinessMethodCheck.check(beanName, beanMethods[j], true, true, results);
                                break;
                            }
                        }
                    }
                    ++j;
                }
                if (beanClassExposedInRemoteIntf) {
                    results.add("Error in the remote interface " + intf.getName() + " of bean " + beanName + ": Bean class " + beanClass.getName() + " is exposed in its remote interface.");
                }
                if (!businessMethodFound) {
                    results.add("Error in the remote interface " + intf.getName() + " of bean " + beanName + ": No corresponding business method in the bean class " + beanClass.getName() + " was found for method " + businessMethods[i].getName() + ".");
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

