/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier;

import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.verifier.BusinessMethodCheck;
import com.sap.engine.services.ejb.deploy.verifier.CheckUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Vector;

public class LocalInterfaceCheck {
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;

    public static void check(DeploymentDescriptor descr, Class localIntf, Class beanClass, Vector results) {
        if (localIntf == null) {
            return;
        }
        String errorInLocalInterface = "Error in the local interface " + localIntf.getName() + " of bean " + descr.getEjbName() + ": ";
        if (!(class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = LocalInterfaceCheck.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject).isAssignableFrom(localIntf)) {
            results.add(errorInLocalInterface + "It does not extend javax.ejb.EJBLocalObject. The local interfaces must extend javax.ejb.EJBLocalObject. EJB Specification 7.10.7 and 10.6.11.");
        }
        if (!Modifier.isPublic(localIntf.getModifiers())) {
            results.add(errorInLocalInterface + "It is not defined as public. All local interfaces must be defined as public.");
        }
        Method[] businessMethods = localIntf.getMethods();
        Method[] beanMethods = beanClass.getMethods();
        boolean beanClassExposedInLocalIntf = false;
        int i = 0;
        while (i < businessMethods.length) {
            if (businessMethods[i].getReturnType().getName().equals(beanClass.getName())) {
                beanClassExposedInLocalIntf = true;
            }
            if (!businessMethods[i].getDeclaringClass().getName().equals("javax.ejb.EJBLocalObject")) {
                BusinessMethodCheck.check(descr.getEjbName(), businessMethods[i], false, false, results);
                boolean businessMethodFound = false;
                int j = 0;
                while (j < beanMethods.length) {
                    if (businessMethods[i].getName().equals(beanMethods[j].getName())) {
                        Object[] businessMethodParams = businessMethods[i].getParameterTypes();
                        Object[] beanMethodParams = beanMethods[j].getParameterTypes();
                        if (Arrays.equals(beanMethodParams, businessMethodParams)) {
                            Class<?> beanMethodReturn;
                            Class<?> businessMethodReturn;
                            Class[] businessMethodExc = businessMethods[i].getExceptionTypes();
                            Class[] beanMethodExc = beanMethods[j].getExceptionTypes();
                            if (CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(beanMethodExc, businessMethodExc) && (businessMethodReturn = businessMethods[i].getReturnType()).equals(beanMethodReturn = beanMethods[j].getReturnType())) {
                                businessMethodFound = true;
                                BusinessMethodCheck.check(descr.getEjbName(), beanMethods[j], false, true, results);
                                break;
                            }
                        }
                    }
                    ++j;
                }
                if (!businessMethodFound) {
                    results.add(errorInLocalInterface + "No corresponding business method in the bean class was found for method " + businessMethods[i].getName() + ".");
                }
            }
            ++i;
        }
        if (beanClassExposedInLocalIntf) {
            results.add(errorInLocalInterface + "Bean class " + beanClass.getName() + " is exposed in its local interface.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

