/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier;

import com.sap.engine.services.ejb.util.ClassUtils;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class BeanClassCheck {
    public static void check(Class beanclass, boolean version20, Vector errors) {
        boolean isAbstract;
        if (beanclass == null) {
            return;
        }
        int classModifiers = beanclass.getModifiers();
        boolean foundOne = false;
        Constructor<?>[] constructors = beanclass.getConstructors();
        int i = 0;
        while (i < constructors.length) {
            Class<?>[] constructorParameterTypes;
            int modifiers = constructors[i].getModifiers();
            if (Modifier.isPublic(modifiers) && (constructorParameterTypes = constructors[i].getParameterTypes()).length <= 0) {
                foundOne = true;
                break;
            }
            ++i;
        }
        if (!foundOne) {
            errors.add("Error in the bean class: There is no public constructor with no parameters defined within bean " + beanclass.getName() + ". Bean classes must have a public constructor with no parameters.");
        }
        if (ClassUtils.hasMethod(beanclass, "finalize", null)) {
            errors.add("Error in the bean class: The bean class " + beanclass.getName() + " must not define the finalize() method.");
        }
        if ((isAbstract = Modifier.isAbstract(classModifiers)) && !version20) {
            errors.add("Error in the bean class: The bean class " + beanclass.getName() + " was found, but was declared as abstract. It must not be abstract.");
        }
        if (!isAbstract && version20) {
            errors.add("Error in the bean class: CMP 2.0 Entity Bean Class " + beanclass.getName() + " was found, but was declared as non abstract. It must be abstract.");
        }
        if (Modifier.isFinal(classModifiers)) {
            errors.add("Error in the bean class: Ejb Class " + beanclass.getName() + " was declared as final. It must not be defined as final.");
        }
        if (!Modifier.isPublic(classModifiers)) {
            errors.add("Error in the bean class: Ejb Class " + beanclass.getName() + " was not declared as public. It must be defined as public.");
        }
        boolean badField = false;
        Field[] fields = beanclass.getDeclaredFields();
        int i2 = 0;
        while (i2 < fields.length) {
            int modif;
            badField = false;
            if (fields[i2].getName().indexOf("$") == -1 && Modifier.isStatic(modif = fields[i2].getModifiers()) && !Modifier.isFinal(modif)) {
                errors.add("Warning in the bean class: Field " + fields[i2].getName() + " defined within bean class " + beanclass.getName() + " is defined as static, but not defined as final. An enterprise Bean must not use read/write static fields. Using read-only static fields is allowed.");
            }
            ++i2;
        }
    }
}

