/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.tools.sql;

import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.lib.util.concurrent.CountDown;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.command.DBInitializer;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DataBaseProperties;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.tools.sql.M2MStatementGenerator;
import com.sap.engine.services.ejb.deploy.tools.sql.StatementGenerator;
import com.sap.engine.services.ejb.deploy.tools.sql.dbtypes.DBMapper;
import com.sap.engine.services.ejb.deploy.tools.sql.dbtypes.DBVendorMappings;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDeploymentException;
import java.util.Properties;
import java.util.Vector;

public class StatementGeneratorsHolder {
    boolean[][] tablesGraph = null;
    private StatementGenerator[] generators = null;
    private M2MStatementGenerator[] generatorsM2M = null;
    private AbstractSchema schema = null;
    private DBVendorMappings dbVendor = null;
    private String[] createSt = null;
    private String[] dropSt = null;
    private boolean[] usedTables = null;
    private int countOfOrdered = 0;

    public StatementGeneratorsHolder(AbstractSchema schema) {
        this.schema = schema;
        Vector<M2MStatementGenerator> vM2MStatementGenerator = new Vector<M2MStatementGenerator>();
        CMPEntityDescriptor[] descriptors = schema.getDescriptors();
        this.generators = new StatementGenerator[descriptors.length];
        this.tablesGraph = new boolean[descriptors.length][descriptors.length];
        this.usedTables = new boolean[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            int j = 0;
            while (j < this.tablesGraph[i].length) {
                this.tablesGraph[i][j] = false;
                ++j;
            }
            this.usedTables[i] = false;
            this.generators[i] = new StatementGenerator(descriptors[i], this);
            ++i;
        }
        RelationDescriptor[] relations = schema.getRelDescriptors();
        if (relations != null) {
            int i2 = 0;
            while (i2 < relations.length) {
                OneSideRelationDescriptor side1 = relations[i2].getSide1();
                OneSideRelationDescriptor side2 = relations[i2].getSide2();
                CMPEntityDescriptor refDscr = null;
                if (side1.getCmrId() == -1) {
                    refDscr = schema.getDescriptor(side2.getEjbId());
                    side1.setVirtualFieldName("ejb_virtual" + refDscr.getEjbName() + "_" + i2);
                    if (side1.getMultiplicityType() == 1 || side1.getMultiplicityType() == 3) {
                        side1.setVirtualFieldType(refDscr.getLocalInterface());
                    } else {
                        side1.setVirtualFieldType("java.util.Collection");
                    }
                } else if (side2.getCmrId() == -1) {
                    refDscr = schema.getDescriptor(side1.getEjbId());
                    side2.setVirtualFieldName("ejb_virtual" + refDscr.getEjbName() + "_" + i2);
                    if (side2.getMultiplicityType() == 1 || side2.getMultiplicityType() == 3) {
                        side2.setVirtualFieldType(refDscr.getLocalInterface());
                    } else {
                        side2.setVirtualFieldType("java.util.Collection");
                    }
                }
                if (relations[i2].getM2MMap() != null) {
                    M2MStatementGenerator m2mGenerator = new M2MStatementGenerator(relations[i2], schema, this);
                    vM2MStatementGenerator.addElement(m2mGenerator);
                }
                ++i2;
            }
        }
        this.generatorsM2M = vM2MStatementGenerator.toArray(new M2MStatementGenerator[vM2MStatementGenerator.size()]);
    }

    public AbstractSchema getAbstractSchema() {
        return this.schema;
    }

    public StatementGenerator getStatementGenerator(int ejbId) {
        return this.generators[ejbId];
    }

    public M2MStatementGenerator[] getM2MStatementGenerators() {
        return this.generatorsM2M;
    }

    public String getImplBeanName(String abstractSchemaName) {
        CMPEntityDescriptor dscr = this.schema.getDescriptorByAbstractSchemaName(abstractSchemaName);
        return dscr.getClassName() + dscr.getUseIndex()[4];
    }

    public String[] getCreateTableSt(Properties props) throws DeploymentException {
        String[] newCreateSt = null;
        String[] newDropSt = null;
        if (this.createSt == null) {
            DataBaseProperties dbProps = this.schema.getDBProperties();
            this.dbVendor = DBMapper.getDBVendorMappings(dbProps.getDBVendorId(), props);
            int i = 0;
            while (i < this.generators.length) {
                this.generators[i].createTableSt();
                ++i;
            }
            this.createSt = new String[this.generators.length];
            this.dropSt = new String[this.generators.length];
            this.orderCreateStatements();
            if (this.countOfOrdered < this.generators.length) {
                EJBDeploymentException toThrow = new EJBDeploymentException("ejb_2442");
                throw toThrow;
            }
            if (this.generatorsM2M.length > 0) {
                newCreateSt = new String[this.createSt.length + this.generatorsM2M.length];
                System.arraycopy(this.createSt, 0, newCreateSt, 0, this.createSt.length);
                newDropSt = new String[this.dropSt.length + this.generatorsM2M.length];
                System.arraycopy(this.dropSt, 0, newDropSt, this.generatorsM2M.length, this.dropSt.length);
                int i2 = 0;
                while (i2 < this.generatorsM2M.length) {
                    newCreateSt[i2 + this.createSt.length] = this.generatorsM2M[i2].createTable();
                    newDropSt[i2] = this.generatorsM2M[i2].dropTable();
                    ++i2;
                }
                this.createSt = newCreateSt;
                this.dropSt = newDropSt;
            }
        }
        return this.createSt;
    }

    public String[] getDropTableSt() throws DeploymentException {
        if (this.dropSt == null) {
            this.getCreateTableSt(null);
        }
        return this.dropSt;
    }

    public DBVendorMappings getDBVendorMappings() {
        return this.dbVendor;
    }

    public M2MStatementGenerator getM2MStatementGenarator(String abstractSchemaName, String cmrName) {
        String ejbName = this.schema.getDescriptorByAbstractSchemaName(abstractSchemaName).getEjbName();
        M2MStatementGenerator[] temp = this.getM2MStatementGenerators();
        int i = 0;
        while (i < temp.length) {
            if (temp[i].properM2MGenerator(ejbName, cmrName)) {
                return temp[i];
            }
            ++i;
        }
        return null;
    }

    public void createTablesAtDeploy(Environment env, Vector warnings) {
        DataBaseProperties dbProps = this.schema.getDBProperties();
        String dsName = dbProps.getDataSourceName();
        String[] createStatements = null;
        try {
            createStatements = this.getCreateTableSt(null);
        }
        catch (DeploymentException de) {
            warnings.add("DeploymentException has occured:" + ((Throwable)((Object)de)).toString());
            return;
        }
        String[] newArr = new String[createStatements.length + 1];
        newArr[0] = dsName;
        System.arraycopy(createStatements, 0, newArr, 1, createStatements.length);
        CountDown cd = new CountDown(1);
        boolean executeStsInTx = true;
        DBInitializer dbInitializer = new DBInitializer(newArr, cd, executeStsInTx);
        ThreadSystem ts = env.getThreadSystem();
        ts.startThread((Runnable)dbInitializer, false);
        Exception ex = null;
        try {
            cd.acquire();
            ex = dbInitializer.getException();
        }
        catch (InterruptedException iex) {
            ex = iex;
        }
        if (ex != null) {
            warnings.add("Tables are not created. Exception has occured:" + ex.toString() + " For more details see log files.");
            return;
        }
    }

    private void orderCreateStatements() {
        boolean noFKPointsToMe = true;
        int i = 0;
        while (i < this.tablesGraph.length) {
            if (!this.usedTables[i]) {
                noFKPointsToMe = true;
                int j = 0;
                while (j < this.tablesGraph[i].length) {
                    if (this.tablesGraph[i][j]) {
                        noFKPointsToMe = false;
                        break;
                    }
                    ++j;
                }
                if (noFKPointsToMe) {
                    this.usedTables[i] = true;
                    this.createSt[this.countOfOrdered++] = this.generators[i].getCreateTableSt();
                    this.dropSt[this.dropSt.length - this.countOfOrdered] = this.generators[i].getDropTableSt();
                    int k = 0;
                    while (k < this.tablesGraph.length) {
                        this.tablesGraph[k][i] = false;
                        ++k;
                    }
                    this.orderCreateStatements();
                }
            }
            ++i;
        }
    }
}

