/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.tools.sql;

import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDeploymentException;
import com.sap.engine.services.ejb.util.ClassUtils;
import com.sap.sql.types.CommonTypes;
import java.util.Hashtable;

public class Mappings {
    public static final int JDBC_SERIALIZED_OBJ = 2004;
    public static final int JDBC_UTIL_DATE = 93;
    public static Hashtable objectMap = null;
    private static Hashtable primitiveTypeToClass = null;
    private static Hashtable objValue = null;
    private static Hashtable valueToObj = null;
    private static HashMapIntObject jdbcTypeToSetMethod = null;
    private static HashMapIntObject jdbcTypeToGetMethod = null;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$io$Serializable;
    static /* synthetic */ Class class$java$io$InputStream;
    static /* synthetic */ Class class$java$io$Reader;
    static /* synthetic */ Class class$java$lang$Byte;

    private Mappings() {
    }

    public static int getDefaultSqlTypeForJavaType(Class javaClass) throws DeploymentException {
        int jdbcType = CommonTypes.defaultMapping((Class)javaClass);
        if (jdbcType == 0) {
            if ((class$java$util$Date == null ? (class$java$util$Date = Mappings.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(javaClass)) {
                return 93;
            }
            int[] jdbcTypes = CommonTypes.setableFrom((Class)javaClass);
            if (jdbcTypes.length > 1) {
                return jdbcTypes[1];
            }
            if ((class$java$io$Serializable == null ? (class$java$io$Serializable = Mappings.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(javaClass)) {
                return 2004;
            }
            EJBDeploymentException toThrow = new EJBDeploymentException("ejb_2440", new String[]{javaClass.getName()});
            throw toThrow;
        }
        return jdbcType;
    }

    public static String getSetMethod(int jdbcType, Class fieldClass, int columnIndex, String fieldName) throws DeploymentException {
        boolean findMethod = false;
        return Mappings.innerGetSetMethod(jdbcType, fieldClass, columnIndex, fieldName, findMethod);
    }

    public static String getSetMethodForSelectStInFindMethod(int jdbcType, Class fieldClass, int columnIndex, String fieldName) throws DeploymentException {
        boolean findMethod = true;
        return Mappings.innerGetSetMethod(jdbcType, fieldClass, columnIndex, fieldName, findMethod);
    }

    private static String innerGetSetMethod(int jdbcType, Class fieldClass, int columnIndex, String fieldName, boolean findMethod) throws DeploymentException {
        if (jdbcType == -7) {
            return "setShort(" + columnIndex + ", " + Mappings.transformToSimpleType(fieldName, fieldClass) + "?Persistent.TRUE:Persistent.FALSE)";
        }
        if (Mappings.isUtilDate(jdbcType, fieldClass)) {
            return "setTimestamp(" + columnIndex + ", new Timestamp(" + fieldName + ".getTime()))";
        }
        if (Mappings.isSerializedDV(jdbcType, fieldClass)) {
            if (findMethod) {
                return "setBinaryStream(" + columnIndex + ", ejb_persistent.writeObjectToInputStream(" + fieldName + "), ejb_persistent.getBytesInInputStream())";
            }
            return "setBinaryStream(" + columnIndex + ", writeObjectToInputStream(" + fieldName + "), getBytesInInputStream())";
        }
        if ((class$java$io$InputStream == null ? (class$java$io$InputStream = Mappings.class$("java.io.InputStream")) : class$java$io$InputStream).isAssignableFrom(fieldClass)) {
            return "setBinaryStream(" + columnIndex + ", " + fieldName + "," + fieldName + ".available())";
        }
        if ((class$java$io$Reader == null ? (class$java$io$Reader = Mappings.class$("java.io.Reader")) : class$java$io$Reader).isAssignableFrom(fieldClass)) {
            return "setString(" + columnIndex + ", readerToString(" + fieldName + "))";
        }
        String setMethod = (String)jdbcTypeToSetMethod.get(jdbcType);
        if (setMethod == null) {
            throw new EJBDeploymentException("ejb_2441", new String[]{fieldClass.getName()});
        }
        return setMethod + columnIndex + ", " + Mappings.transformToSimpleType(fieldName, fieldClass) + ")";
    }

    public static String getGetMethod(int jdbcType, Class fieldClass, String columnName) throws DeploymentException {
        if ((class$java$lang$Byte == null ? (class$java$lang$Byte = Mappings.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(fieldClass)) {
            return "new Byte((byte)rs.getShort(\"" + columnName + "\"" + "))";
        }
        if (jdbcType == -7) {
            String getMethod = "rs.getShort(\"" + columnName + "\") == Persistent.TRUE";
            String fObj = (String)valueToObj.get(fieldClass.getName());
            if (fObj != null) {
                return fObj + getMethod + ")";
            }
            return getMethod;
        }
        if (Mappings.isSerializedDV(jdbcType, fieldClass)) {
            return "(" + ClassUtils.unfixClassName(fieldClass.getName()) + ")readObjectFromInputStream(rs.getBinaryStream(\"" + columnName + "\"))";
        }
        if ((class$java$io$InputStream == null ? (class$java$io$InputStream = Mappings.class$("java.io.InputStream")) : class$java$io$InputStream).isAssignableFrom(fieldClass)) {
            return "rs.getBinaryStream(\"" + columnName + "\")";
        }
        if ((class$java$io$Reader == null ? (class$java$io$Reader = Mappings.class$("java.io.Reader")) : class$java$io$Reader).isAssignableFrom(fieldClass)) {
            return "rs.getCharacterStream(\"" + columnName + "\")";
        }
        String getMethod = (String)jdbcTypeToGetMethod.get(jdbcType);
        if (getMethod == null) {
            throw new EJBDeploymentException("ejb_2441", new String[]{fieldClass.getName()});
        }
        String fObj = (String)valueToObj.get(fieldClass.getName());
        String result = null;
        result = fObj != null ? fObj + getMethod + "\"" + columnName + "\"))" : getMethod + "\"" + columnName + "\")";
        if (fieldClass.equals(Byte.TYPE)) {
            return "(byte)" + result;
        }
        return result;
    }

    public static String getGetMethod(int jdbcType, Class fieldClass, int columnIndex) throws DeploymentException {
        if ((class$java$lang$Byte == null ? (class$java$lang$Byte = Mappings.class$("java.lang.Byte")) : class$java$lang$Byte).isAssignableFrom(fieldClass)) {
            return "new Byte((byte)rs.getShort(" + columnIndex + "))";
        }
        if (jdbcType == -7) {
            String getMethod = "rs.getShort(" + columnIndex + ") == Persistent.TRUE";
            String fObj = (String)valueToObj.get(fieldClass.getName());
            if (fObj != null) {
                return fObj + getMethod + ")";
            }
            return getMethod;
        }
        if (Mappings.isSerializedDV(jdbcType, fieldClass)) {
            return "(" + ClassUtils.unfixClassName(fieldClass.getName()) + ")readObjectFromInputStream(rs.getBinaryStream(" + columnIndex + "))";
        }
        if ((class$java$io$InputStream == null ? (class$java$io$InputStream = Mappings.class$("java.io.InputStream")) : class$java$io$InputStream).isAssignableFrom(fieldClass)) {
            return "rs.getBinaryStream(" + columnIndex + ")";
        }
        if ((class$java$io$Reader == null ? (class$java$io$Reader = Mappings.class$("java.io.Reader")) : class$java$io$Reader).isAssignableFrom(fieldClass)) {
            return "rs.getCharacterStream(" + columnIndex + ")";
        }
        String getMethod = (String)jdbcTypeToGetMethod.get(jdbcType);
        if (getMethod == null) {
            throw new EJBDeploymentException("ejb_2441", new String[]{fieldClass.getName()});
        }
        String fObj = (String)valueToObj.get(fieldClass.getName());
        String result = null;
        result = fObj != null ? fObj + getMethod + columnIndex + "))" : getMethod + columnIndex + ")";
        if (fieldClass.equals(Byte.TYPE)) {
            return "(byte)" + result;
        }
        return result;
    }

    public static String createObjectFromPrimitiveType(Class primClass, String primFieldName) {
        Object objClassName = objectMap.get(primClass.getName());
        String newInstance = (String)valueToObj.get(objClassName);
        return newInstance + primFieldName + ")";
    }

    public static String createObjectFromType(String fieldType, String fieldName) {
        Object objClassName = objectMap.get(fieldType);
        if (objClassName == null) {
            return fieldName;
        }
        String newInstance = (String)valueToObj.get(objClassName);
        return newInstance + fieldName + ")";
    }

    public static String getSetNull(int jdbcType, int columnIndex) {
        if (jdbcType == -7) {
            return Mappings.getSetNull(5, columnIndex);
        }
        return "setNull(" + columnIndex + ", " + jdbcType + ")";
    }

    public static boolean isSerializedDV(int jdbcType, Class fieldClass) {
        return jdbcType == 2004 && (class$java$io$Serializable == null ? (class$java$io$Serializable = Mappings.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(fieldClass);
    }

    public static boolean isUtilDate(int jdbcType, Class fieldClass) {
        return jdbcType == 93 && (class$java$util$Date == null ? (class$java$util$Date = Mappings.class$("java.util.Date")) : class$java$util$Date).isAssignableFrom(fieldClass);
    }

    public static Class getPrimitiveClass(String primitiveType) {
        return (Class)primitiveTypeToClass.get(primitiveType);
    }

    private static String transformToSimpleType(String fieldName, Class fieldClass) {
        String fValue = (String)objValue.get(fieldClass.getName());
        if (fValue != null) {
            return "(" + fieldName + ")" + fValue;
        }
        return fieldName;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        objectMap = new Hashtable();
        objectMap.put("int", "java.lang.Integer");
        objectMap.put("byte", "java.lang.Byte");
        objectMap.put("double", "java.lang.Double");
        objectMap.put("short", "java.lang.Short");
        objectMap.put("long", "java.lang.Long");
        objectMap.put("boolean", "java.lang.Boolean");
        objectMap.put("float", "java.lang.Float");
        objectMap.put("char", "java.lang.Character");
        primitiveTypeToClass = new Hashtable();
        primitiveTypeToClass.put("int", Integer.TYPE);
        primitiveTypeToClass.put("long", Long.TYPE);
        primitiveTypeToClass.put("byte", Byte.TYPE);
        primitiveTypeToClass.put("short", Short.TYPE);
        primitiveTypeToClass.put("boolean", Boolean.TYPE);
        primitiveTypeToClass.put("float", Float.TYPE);
        primitiveTypeToClass.put("double", Double.TYPE);
        objValue = new Hashtable();
        objValue.put("java.lang.Integer", ".intValue()");
        objValue.put("java.lang.Byte", ".byteValue()");
        objValue.put("java.lang.Double", ".doubleValue()");
        objValue.put("java.lang.Short", ".shortValue()");
        objValue.put("java.lang.Long", ".longValue()");
        objValue.put("java.lang.Boolean", ".booleanValue()");
        objValue.put("java.lang.Float", ".floatValue()");
        valueToObj = new Hashtable();
        valueToObj.put("java.lang.Integer", "new Integer(");
        valueToObj.put("java.lang.Byte", "new Byte(");
        valueToObj.put("java.lang.Double", "new Double(");
        valueToObj.put("java.lang.Short", "new Short(");
        valueToObj.put("java.lang.Long", "new Long(");
        valueToObj.put("java.lang.Boolean", "new Boolean(");
        valueToObj.put("java.lang.Float", "new Float(");
        jdbcTypeToSetMethod = new HashMapIntObject();
        jdbcTypeToSetMethod.put(12, "setString(");
        jdbcTypeToSetMethod.put(-3, "setBytes(");
        jdbcTypeToSetMethod.put(5, "setShort(");
        jdbcTypeToSetMethod.put(4, "setInt(");
        jdbcTypeToSetMethod.put(-5, "setLong(");
        jdbcTypeToSetMethod.put(3, "setBigDecimal(");
        jdbcTypeToSetMethod.put(8, "setDouble(");
        jdbcTypeToSetMethod.put(91, "setDate(");
        jdbcTypeToSetMethod.put(92, "setTime(");
        jdbcTypeToSetMethod.put(93, "setTimestamp(");
        jdbcTypeToSetMethod.put(2005, "setClob(");
        jdbcTypeToSetMethod.put(2004, "setBlob(");
        jdbcTypeToSetMethod.put(7, "setFloat(");
        jdbcTypeToGetMethod = new HashMapIntObject();
        jdbcTypeToGetMethod.put(12, "rs.getString(");
        jdbcTypeToGetMethod.put(-3, "rs.getBytes(");
        jdbcTypeToGetMethod.put(5, "rs.getShort(");
        jdbcTypeToGetMethod.put(4, "rs.getInt(");
        jdbcTypeToGetMethod.put(-5, "rs.getLong(");
        jdbcTypeToGetMethod.put(3, "rs.getBigDecimal(");
        jdbcTypeToGetMethod.put(8, "rs.getDouble(");
        jdbcTypeToGetMethod.put(91, "rs.getDate(");
        jdbcTypeToGetMethod.put(92, "rs.getTime(");
        jdbcTypeToGetMethod.put(93, "rs.getTimestamp(");
        jdbcTypeToGetMethod.put(2004, "rs.getBlob(");
        jdbcTypeToGetMethod.put(2005, "rs.getClob(");
        jdbcTypeToGetMethod.put(7, "rs.getFloat(");
    }
}

