/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.tools.sql;

import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.M2MRelationFieldMap;
import com.sap.engine.services.ejb.deploy.tools.sql.StatementGeneratorsHolder;

public class M2MStatementGenerator {
    private static String lSeparator = System.getProperty("line.separator");
    private StatementGeneratorsHolder holder = null;
    private M2MRelationFieldMap m2mMap = null;
    private OneSideRelationDescriptor side1 = null;
    private OneSideRelationDescriptor side2 = null;
    private AbstractSchema schema = null;
    private CMPEntityDescriptor dscr1 = null;
    private CMPEntityDescriptor dscr2 = null;
    private PersistentField[] refPKFields1 = null;
    private PersistentField[] refPKFields2 = null;
    private int[] pkColumnType1 = null;
    private int[] pkColumnType2 = null;
    private String[] pkColumn1 = null;
    private String[] pkColumn2 = null;
    private String[] pkFieldType1 = null;
    private String[] pkFieldType2 = null;
    private Class[] pkFieldClass1 = null;
    private Class[] pkFieldClass2 = null;
    private String[] pkFieldName1 = null;
    private String[] pkFieldName2 = null;
    private boolean usedByFirstEjb = true;
    private int id = -1;

    public M2MStatementGenerator(RelationDescriptor relDescr, AbstractSchema schema, StatementGeneratorsHolder holder) {
        this.side1 = relDescr.getSide1();
        this.side2 = relDescr.getSide2();
        this.m2mMap = relDescr.getM2MMap();
        this.id = this.m2mMap.getM2MRelId();
        this.schema = schema;
        this.holder = holder;
        this.dscr1 = schema.getDescriptor(this.side1.getEjbId());
        this.dscr2 = schema.getDescriptor(this.side2.getEjbId());
        this.refPKFields1 = this.dscr1.getPKCmpFields();
        this.pkFieldType1 = new String[this.refPKFields1.length];
        this.pkFieldClass1 = new Class[this.refPKFields1.length];
        this.pkFieldName1 = new String[this.refPKFields1.length];
        this.pkColumnType1 = new int[this.refPKFields1.length];
        this.pkColumn1 = new String[this.refPKFields1.length];
        int i = 0;
        while (i < this.refPKFields1.length) {
            this.pkFieldType1[i] = this.refPKFields1[i].getFieldType();
            this.pkFieldClass1[i] = this.refPKFields1[i].getFieldClass();
            this.pkFieldName1[i] = this.refPKFields1[i].getFieldName();
            this.pkColumnType1[i] = this.refPKFields1[i].getFieldDBMap().getColumnType();
            this.pkColumn1[i] = this.refPKFields1[i].getFieldDBMap().getColumnName();
            ++i;
        }
        this.refPKFields2 = this.dscr2.getPKCmpFields();
        this.pkFieldType2 = new String[this.refPKFields2.length];
        this.pkFieldClass2 = new Class[this.refPKFields2.length];
        this.pkFieldName2 = new String[this.refPKFields2.length];
        this.pkColumnType2 = new int[this.refPKFields2.length];
        this.pkColumn2 = new String[this.refPKFields2.length];
        int i2 = 0;
        while (i2 < this.refPKFields2.length) {
            this.pkFieldType2[i2] = this.refPKFields2[i2].getFieldType();
            this.pkFieldClass2[i2] = this.refPKFields2[i2].getFieldClass();
            this.pkFieldName2[i2] = this.refPKFields2[i2].getFieldName();
            this.pkColumnType2[i2] = this.refPKFields2[i2].getFieldDBMap().getColumnType();
            this.pkColumn2[i2] = this.refPKFields2[i2].getFieldDBMap().getColumnName();
            ++i2;
        }
    }

    public CMPEntityDescriptor getCMPDscr1() {
        return this.dscr1;
    }

    public CMPEntityDescriptor getCMPDscr2() {
        return this.dscr2;
    }

    public String getEjbName1() {
        return this.schema.getDescriptor(this.side1.getEjbId()).getEjbName();
    }

    public String getEjbName2() {
        return this.schema.getDescriptor(this.side2.getEjbId()).getEjbName();
    }

    public String getHelpTableName() {
        return this.m2mMap.getHelpTable();
    }

    public String createTable() throws DeploymentException {
        String[] helpColumns1 = this.getHelpColumns1();
        String[] helpColumns2 = this.getHelpColumns2();
        StringBuffer st = new StringBuffer("create table \"");
        st.append(this.m2mMap.getHelpTable().toUpperCase());
        st.append("\" (");
        st.append(lSeparator);
        st.append("  \"");
        st.append(helpColumns1[0].toUpperCase());
        st.append("\" ");
        st.append(this.holder.getDBVendorMappings().getDatabaseType(this.refPKFields1[0].getFieldDBMap().getColumnType()));
        st.append(" not null");
        StringBuffer pkColumnsStr1 = new StringBuffer("\"");
        pkColumnsStr1.append(helpColumns1[0].toUpperCase());
        pkColumnsStr1.append("\"");
        int i = 1;
        while (i < helpColumns1.length) {
            st.append(", ");
            st.append(lSeparator);
            st.append("  \"");
            st.append(helpColumns1[i].toUpperCase());
            st.append("\" ");
            st.append(this.holder.getDBVendorMappings().getDatabaseType(this.refPKFields1[i].getFieldDBMap().getColumnType()));
            st.append(" not null");
            pkColumnsStr1.append(", \"");
            pkColumnsStr1.append(helpColumns1[i].toUpperCase());
            pkColumnsStr1.append("\"");
            ++i;
        }
        StringBuffer pkColumnsStr2 = new StringBuffer("\"");
        pkColumnsStr2.append(helpColumns2[0].toUpperCase());
        pkColumnsStr2.append("\"");
        st.append(", ");
        st.append(lSeparator);
        st.append("  \"");
        st.append(helpColumns2[0].toUpperCase());
        st.append("\" ");
        st.append(this.holder.getDBVendorMappings().getDatabaseType(this.refPKFields2[0].getFieldDBMap().getColumnType()));
        st.append(" not null");
        int i2 = 1;
        while (i2 < helpColumns2.length) {
            st.append(", ");
            st.append(lSeparator);
            st.append("  \"");
            st.append(helpColumns2[i2].toUpperCase());
            st.append("\" ");
            st.append(this.holder.getDBVendorMappings().getDatabaseType(this.refPKFields2[i2].getFieldDBMap().getColumnType()));
            st.append(" not null");
            pkColumnsStr2.append(", \"");
            pkColumnsStr2.append(helpColumns2[i2].toUpperCase());
            pkColumnsStr2.append("\"");
            ++i2;
        }
        st.append(",");
        st.append(lSeparator);
        st.append("  primary key (");
        st.append(pkColumnsStr1.toString());
        st.append(", ");
        st.append(pkColumnsStr2.toString());
        st.append(")");
        st.append(lSeparator);
        st.append(")");
        return st.toString();
    }

    public String dropTable() {
        return "drop table \"" + this.m2mMap.getHelpTable().toUpperCase() + "\"";
    }

    public String insertSt() {
        String[] helpColumns1 = this.getHelpColumns1();
        String[] helpColumns2 = this.getHelpColumns2();
        StringBuffer st = new StringBuffer();
        StringBuffer columnsToIns = new StringBuffer(" (");
        int i = 0;
        while (i < helpColumns1.length) {
            st.append("?, ");
            columnsToIns.append("\\\"");
            columnsToIns.append(helpColumns1[i].toUpperCase());
            columnsToIns.append("\\\", ");
            ++i;
        }
        int i2 = 0;
        while (i2 < helpColumns2.length) {
            if (i2 > 0) {
                st.append(", ?");
                columnsToIns.append(", ");
            } else {
                st.append("?");
            }
            columnsToIns.append("\\\"");
            columnsToIns.append(helpColumns2[i2].toUpperCase());
            columnsToIns.append("\\\"");
            ++i2;
        }
        st.append(")");
        st.insert(0, ") values (");
        st.insert(0, columnsToIns.toString());
        st.insert(0, "\\\"");
        st.insert(0, this.m2mMap.getHelpTable().toUpperCase());
        st.insert(0, "\\\"");
        st.insert(0, "insert into ");
        return st.toString();
    }

    public String deleteSt() {
        String[] helpColumns1 = this.getHelpColumns1();
        String[] helpColumns2 = this.getHelpColumns2();
        StringBuffer st = new StringBuffer("delete from \\\"");
        st.append(this.m2mMap.getHelpTable().toUpperCase());
        st.append("\\\" where ");
        int i = 0;
        while (i < helpColumns1.length) {
            st.append("\\\"");
            st.append(helpColumns1[i].toUpperCase());
            st.append("\\\" = ? and ");
            ++i;
        }
        int i2 = 0;
        while (i2 < helpColumns2.length) {
            if (i2 > 0) {
                st.append(" and ");
            }
            st.append("\\\"");
            st.append(helpColumns2[i2].toUpperCase());
            st.append("\\\" = ?");
            ++i2;
        }
        return st.toString();
    }

    public String selectStByPK1() {
        String tableName = this.m2mMap.getHelpTable().toUpperCase();
        return this.selectAllColumns(true, tableName);
    }

    public String selectStByPK2() {
        String tableName = this.m2mMap.getHelpTable().toUpperCase();
        return this.selectAllColumns(false, tableName);
    }

    public int getId() {
        return this.id;
    }

    public PersistentField[] getPKFields1() {
        return this.refPKFields1;
    }

    public PersistentField[] getPKFields2() {
        return this.refPKFields2;
    }

    public String[] getPKFieldTypes1() {
        return this.pkFieldType1;
    }

    public String[] getPKFieldTypes2() {
        return this.pkFieldType2;
    }

    public Class[] getPKFieldClasses1() {
        return this.pkFieldClass1;
    }

    public Class[] getPKFieldClasses2() {
        return this.pkFieldClass2;
    }

    public int[] getPKColumnTypes1() {
        return this.pkColumnType1;
    }

    public int[] getPKColumnTypes2() {
        return this.pkColumnType2;
    }

    public boolean properM2MGenerator(String ejbName, String cmrName) {
        RelationField cmr = null;
        int cmrId = -1;
        if (ejbName.equals(this.dscr1.getEjbName())) {
            cmrId = this.side1.getCmrId();
            if (cmrId == -1) {
                return false;
            }
            cmr = this.dscr1.getRelationField(cmrId);
            this.usedByFirstEjb = true;
            return cmr.getFieldName().equals(cmrName);
        }
        if (ejbName.equals(this.dscr2.getEjbName())) {
            cmrId = this.side2.getCmrId();
            if (cmrId == -1) {
                return false;
            }
            cmr = this.dscr2.getRelationField(cmrId);
            this.usedByFirstEjb = false;
            return cmr.getFieldName().equals(cmrName);
        }
        return false;
    }

    public String[] getFkColumns(boolean fkToMe) {
        if (this.usedByFirstEjb) {
            if (fkToMe) {
                return this.m2mMap.getColumns1();
            }
            return this.m2mMap.getColumns2();
        }
        if (fkToMe) {
            return this.m2mMap.getColumns2();
        }
        return this.m2mMap.getColumns1();
    }

    public String[] getPkColumns(boolean myPk) {
        if (this.usedByFirstEjb) {
            if (myPk) {
                return this.pkColumn1;
            }
            return this.pkColumn2;
        }
        if (myPk) {
            return this.pkColumn2;
        }
        return this.pkColumn1;
    }

    public String[] getPKFieldNames1() {
        return this.pkFieldName1;
    }

    public void setPKFieldNames1(String[] pkFieldName1) {
        this.pkFieldName1 = pkFieldName1;
    }

    public String[] getPKFieldNames2() {
        return this.pkFieldName2;
    }

    public void setPKFieldNames2(String[] pkFieldName2) {
        this.pkFieldName2 = pkFieldName2;
    }

    public String[] getHelpColumns1() {
        return this.m2mMap.getColumns1();
    }

    public String[] getHelpColumns2() {
        return this.m2mMap.getColumns2();
    }

    private String selectAllColumns(boolean selectByPK1, String tableName) {
        String[] helpColumns1 = this.getHelpColumns1();
        String[] helpColumns2 = this.getHelpColumns2();
        StringBuffer st = new StringBuffer("select ");
        this.addColumnsInSelectSt(helpColumns1, st, tableName, true);
        this.addColumnsInSelectSt(helpColumns2, st, tableName, false);
        st.append(" from \\\"");
        st.append(tableName);
        String[] helpColumns = selectByPK1 ? helpColumns1 : helpColumns2;
        st.append("\\\" where ");
        boolean firstColumn = true;
        int i = 0;
        while (i < helpColumns.length) {
            if (firstColumn) {
                st.append("\\\"");
                firstColumn = false;
            } else {
                st.append(" and \\\"");
            }
            st.append(helpColumns[i].toUpperCase());
            st.append("\\\" = ?");
            ++i;
        }
        return st.toString();
    }

    private void addColumnsInSelectSt(String[] columns, StringBuffer sBuff, String tableName, boolean firstColumn) {
        int i = 0;
        while (i < columns.length) {
            if (firstColumn) {
                sBuff.append("\\\"");
                firstColumn = false;
            } else {
                sBuff.append(", \\\"");
            }
            sBuff.append(tableName);
            sBuff.append("\\\".\\\"");
            sBuff.append(columns[i].toUpperCase());
            sBuff.append("\\\"");
            ++i;
        }
    }
}

