/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.orMappingVerifier;

import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RDependentValueMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RPersistentFieldMap;
import com.sap.engine.services.ejb.exceptions.deployment.ORMappingExceptionConstants;
import com.sap.engine.services.ejb.exceptions.deployment.ORMappingVerificationException;
import com.sap.sql.catalog.CatalogReader;
import com.sap.sql.catalog.Column;
import com.sap.sql.catalog.Table;
import com.sap.sql.types.CommonTypes;
import java.sql.SQLException;
import java.util.Vector;

public class CMPEntityVerifier
implements ORMappingExceptionConstants {
    private static final int DEFAULT_STRING_JDBC_TYPE = CommonTypes.defaultMapping((Class)(class$java$lang$String == null ? (class$java$lang$String = CMPEntityVerifier.class$("java.lang.String")) : class$java$lang$String));
    private static final int DEFAULT_BYTES_JDBC_TYPE = CommonTypes.defaultMapping((Class)(array$B == null ? (array$B = CMPEntityVerifier.class$("[B")) : array$B));
    private static final int DEFAULT_BOOLEAN_JDBC_TYPE = CommonTypes.defaultMapping(Boolean.TYPE);
    private static final int DEFAULT_DOUBLE_JDBC_TYPE = CommonTypes.defaultMapping(Double.TYPE);
    private static final int DEFAULT_BIGDEC_JDBC_TYPE = CommonTypes.defaultMapping((Class)(class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = CMPEntityVerifier.class$("java.math.BigDecimal")) : class$java$math$BigDecimal));
    private static final int[] STRING_JDBC_TYPES = new int[]{-1, 1, 2005, 12};
    private static final int[] BYTES_JDBC_TYPES = new int[]{-4, -2, 2004, -3};
    private static final int[] BIGDEC_JDBC_TYPES = new int[]{2, 3};
    private static final int[] DOUBLE_JDBC_TYPES = new int[]{6, 8};
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$math$BigDecimal;

    public static void check(CMPEntityDescriptor cmpDescriptor, CatalogReader catalogReader, Vector warnings) throws DeploymentException {
        String tableName = cmpDescriptor.getTableName();
        Table table = CMPEntityVerifier.getCatalogTable(catalogReader, tableName);
        CMPEntityVerifier.checkPKFields(cmpDescriptor, table, warnings);
        PersistentField[] notPkFields = cmpDescriptor.getCmpFields();
        int i = 0;
        while (i < notPkFields.length) {
            CMPEntityVerifier.checkField(notPkFields[i], false, table);
            ++i;
        }
    }

    public static Table getCatalogTable(CatalogReader catalogReader, String tableName) throws ORMappingVerificationException {
        Table table = null;
        try {
            table = catalogReader.getTable(tableName.toUpperCase());
        }
        catch (SQLException se) {
            throw new ORMappingVerificationException("ejb_2001", new String[]{tableName}, se);
        }
        if (table == null || table.getTableType() == 2) {
            throw new ORMappingVerificationException("ejb_2000", new String[]{tableName});
        }
        return table;
    }

    public static Column getCatalogColumn(Table t, String columnName) throws ORMappingVerificationException {
        Column column = t.getColumn(columnName.toUpperCase());
        if (column == null) {
            throw new ORMappingVerificationException("ejb_2005", new String[]{columnName, t.getName()});
        }
        return column;
    }

    private static void checkPKFields(CMPEntityDescriptor cmpDescriptor, Table table, Vector warnings) throws DeploymentException {
        String tableName = table.getName();
        String ejbName = cmpDescriptor.getEjbName();
        if (table.getPrimaryKeyCnt() == 0) {
            String MESSAGE = "The application contains CMP Entity Bean " + cmpDescriptor.getEjbName() + ". Its container managed fields are stored in the database table " + tableName + ". The table should have at least one primary key column but none of its columns is primary key." + " Check if there is UNIQUE constraint for all of the columns that are defined as primary keys in the" + " corresponding persistent.xml";
            warnings.add(MESSAGE);
            return;
        }
        PersistentField[] pkFields = cmpDescriptor.getPKCmpFields();
        if (table.getPrimaryKeyCnt() != pkFields.length) {
            Object[] excArgs = new String[]{ejbName, tableName, String.valueOf(pkFields.length), String.valueOf(table.getPrimaryKeyCnt())};
            throw new ORMappingVerificationException("ejb_2002", excArgs);
        }
        if (cmpDescriptor.isUnknownPK() && pkFields.length != 1) {
            throw new ORMappingVerificationException("ejb_2003", new String[]{ejbName, String.valueOf(pkFields.length)});
        }
        int i = 0;
        while (i < pkFields.length) {
            CMPEntityVerifier.checkField(pkFields[i], true, table);
            ++i;
        }
    }

    private static void checkField(PersistentField field, boolean isPk, Table table) throws DeploymentException {
        RPersistentFieldMap fieldMap = field.getFieldDBMap();
        if (fieldMap instanceof RDependentValueMap) {
            RDependentValueMap dvMap = (RDependentValueMap)fieldMap;
            int[] dvColumnTypes = dvMap.getDvColumnType();
            String[] dvColumnNames = dvMap.getDvColumnName();
            int i = 0;
            while (i < dvColumnTypes.length) {
                CMPEntityVerifier.checkSingleColumn(table, dvColumnNames[i], dvColumnTypes[i], isPk);
                ++i;
            }
        } else {
            String columnName = fieldMap.getColumnName();
            CMPEntityVerifier.checkSingleColumn(table, columnName, fieldMap.getColumnType(), isPk);
        }
    }

    private static void checkSingleColumn(Table table, String columnName, int columnType, boolean isPk) throws DeploymentException {
        Column column = CMPEntityVerifier.getCatalogColumn(table, columnName);
        if (!column.isPrimaryKey() && isPk) {
            throw new ORMappingVerificationException("ejb_2007", new String[]{columnName, table.getName()});
        }
        if (column.isPrimaryKey() && !isPk) {
            throw new ORMappingVerificationException("ejb_2004", new String[]{columnName, table.getName()});
        }
        if (columnType == DEFAULT_BOOLEAN_JDBC_TYPE) {
            columnType = 5;
        }
        if (column.getJdbcType() != columnType) {
            if (columnType == DEFAULT_STRING_JDBC_TYPE) {
                if (!CMPEntityVerifier.isProperJDBCType(column.getJdbcType(), STRING_JDBC_TYPES)) {
                    throw new ORMappingVerificationException("ejb_2006", new String[]{columnName, table.getName(), CommonTypes.getJdbcTypeName((int)column.getJdbcType()), CommonTypes.getJdbcTypeName((int)columnType)});
                }
                return;
            }
            if (columnType == DEFAULT_BYTES_JDBC_TYPE) {
                if (!CMPEntityVerifier.isProperJDBCType(column.getJdbcType(), BYTES_JDBC_TYPES)) {
                    throw new ORMappingVerificationException("ejb_2006", new String[]{columnName, table.getName(), CommonTypes.getJdbcTypeName((int)column.getJdbcType()), CommonTypes.getJdbcTypeName((int)columnType)});
                }
                return;
            }
            if (columnType == DEFAULT_DOUBLE_JDBC_TYPE) {
                if (!CMPEntityVerifier.isProperJDBCType(column.getJdbcType(), DOUBLE_JDBC_TYPES)) {
                    throw new ORMappingVerificationException("ejb_2006", new String[]{columnName, table.getName(), CommonTypes.getJdbcTypeName((int)column.getJdbcType()), CommonTypes.getJdbcTypeName((int)columnType)});
                }
                return;
            }
            if (columnType == DEFAULT_BIGDEC_JDBC_TYPE) {
                if (!CMPEntityVerifier.isProperJDBCType(column.getJdbcType(), BIGDEC_JDBC_TYPES)) {
                    throw new ORMappingVerificationException("ejb_2006", new String[]{columnName, table.getName(), CommonTypes.getJdbcTypeName((int)column.getJdbcType()), CommonTypes.getJdbcTypeName((int)columnType)});
                }
                return;
            }
            throw new ORMappingVerificationException("ejb_2006", new String[]{columnName, table.getName(), CommonTypes.getJdbcTypeName((int)column.getJdbcType()), CommonTypes.getJdbcTypeName((int)columnType)});
        }
    }

    private static boolean isProperJDBCType(int jdbcType, int[] properJdbcTypes) {
        int i = 0;
        while (i < properJdbcTypes.length) {
            if (properJdbcTypes[i] == jdbcType) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

