/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.enhancer.classgenerator;

import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ClassFile;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.Constant;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantClass;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantDouble;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantFieldref;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantFloat;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantInteger;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantInterfaceMethodref;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantLong;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantMethodref;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantNameAndType;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantString;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantUnicode;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantUtf8;
import com.sap.engine.services.ejb.exceptions.BaseIOException;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;

public class ConstantPool {
    public static final int CONSTANT_Class = 7;
    public static final int CONSTANT_Fieldref = 9;
    public static final int CONSTANT_Methodref = 10;
    public static final int CONSTANT_InterfaceMethodref = 11;
    public static final int CONSTANT_String = 8;
    public static final int CONSTANT_Integer = 3;
    public static final int CONSTANT_Float = 4;
    public static final int CONSTANT_Long = 5;
    public static final int CONSTANT_Double = 6;
    public static final int CONSTANT_NameAndType = 12;
    public static final int CONSTANT_Utf8 = 1;
    public static final int CONSTANT_Unicode = 2;
    public Vector pool = new Vector();
    public ClassFile classFile;

    public ConstantPool(ClassFile classFile) {
        this.pool.addElement(null);
        this.classFile = classFile;
    }

    public String getString(int index) {
        return ((ConstantUtf8)this.pool.elementAt((int)index)).value;
    }

    public String getClass(int index) {
        return this.getString(((ConstantClass)this.pool.elementAt((int)index)).name_index);
    }

    public void write(DataOutputStream out) throws IOException {
        out.writeShort(this.pool.size());
        int i = 1;
        while (i < this.pool.size()) {
            Constant constant = (Constant)this.pool.elementAt(i);
            constant.write(out);
            i += constant.size();
        }
    }

    public void read(DataInputStream in) throws IOException {
        int len = in.readUnsignedShort();
        int i = 1;
        while (i < len) {
            Constant constant;
            int code = in.readUnsignedByte();
            switch (code) {
                case 1: {
                    constant = new ConstantUtf8();
                    break;
                }
                case 2: {
                    constant = new ConstantUnicode();
                    break;
                }
                case 3: {
                    constant = new ConstantInteger();
                    break;
                }
                case 4: {
                    constant = new ConstantFloat();
                    break;
                }
                case 5: {
                    constant = new ConstantLong();
                    break;
                }
                case 6: {
                    constant = new ConstantDouble();
                    break;
                }
                case 7: {
                    constant = new ConstantClass();
                    break;
                }
                case 8: {
                    constant = new ConstantString();
                    break;
                }
                case 9: {
                    constant = new ConstantFieldref();
                    break;
                }
                case 10: {
                    constant = new ConstantMethodref();
                    break;
                }
                case 11: {
                    constant = new ConstantInterfaceMethodref();
                    break;
                }
                case 12: {
                    constant = new ConstantNameAndType();
                    break;
                }
                default: {
                    throw new BaseIOException("ejb_2190");
                }
            }
            constant.read(in);
            this.pool.addElement(constant);
            if (constant.size() == 2) {
                this.pool.addElement(null);
            }
            i += constant.size();
        }
    }

    public int getClassIndex(String className) {
        int size = this.pool.size();
        int nameIndex = this.getUtf8Index(className.replace('.', '/'));
        int i = 0;
        while (i < size) {
            Object constant = this.pool.elementAt(i);
            if (constant instanceof ConstantClass && ((ConstantClass)constant).name_index == nameIndex) {
                return i;
            }
            ++i;
        }
        this.pool.addElement(new ConstantClass(nameIndex));
        return this.pool.size() - 1;
    }

    public int getUtf8Index(String str) {
        int size = this.pool.size();
        int i = 0;
        while (i < size) {
            Object constant = this.pool.elementAt(i);
            if (constant instanceof ConstantUtf8 && ((ConstantUtf8)constant).value.equals(str)) {
                return i;
            }
            ++i;
        }
        this.pool.addElement(new ConstantUtf8(str));
        return this.pool.size() - 1;
    }

    public int getNameAndTypeIndex(String methodName, String methodDescr) {
        int nameIndex = this.getUtf8Index(methodName);
        int descrIndex = this.getUtf8Index(methodDescr);
        int size = this.pool.size();
        int i = 0;
        while (i < size) {
            Object constant = this.pool.elementAt(i);
            if (constant instanceof ConstantNameAndType && ((ConstantNameAndType)constant).name_index == nameIndex && ((ConstantNameAndType)constant).signature_index == descrIndex) {
                return i;
            }
            ++i;
        }
        this.pool.addElement(new ConstantNameAndType(nameIndex, descrIndex));
        return this.pool.size() - 1;
    }

    public int getMethodRefIndex(String methodName, String className, String methodDescr) {
        int classIndex = this.getClassIndex(className);
        int nameAndTypeIndex = this.getNameAndTypeIndex(methodName, methodDescr);
        int size = this.pool.size();
        int i = 0;
        while (i < size) {
            Object constant = this.pool.elementAt(i);
            if (constant instanceof ConstantMethodref && ((ConstantMethodref)constant).class_index == classIndex && ((ConstantMethodref)constant).name_and_type_index == nameAndTypeIndex) {
                return i;
            }
            ++i;
        }
        this.pool.addElement(new ConstantMethodref(classIndex, nameAndTypeIndex));
        return this.pool.size() - 1;
    }

    public int getFieldRefIndex(String fieldName, String className, String fieldDescr) {
        int classIndex = this.getClassIndex(className);
        int nameAndTypeIndex = this.getNameAndTypeIndex(fieldName, fieldDescr);
        int size = this.pool.size();
        int i = 0;
        while (i < size) {
            Object constant = this.pool.elementAt(i);
            if (constant instanceof ConstantFieldref && ((ConstantFieldref)constant).class_index == classIndex && ((ConstantFieldref)constant).name_and_type_index == nameAndTypeIndex) {
                return i;
            }
            ++i;
        }
        this.pool.addElement(new ConstantFieldref(classIndex, nameAndTypeIndex));
        return this.pool.size() - 1;
    }

    public int getStringIndex(String str) {
        int index = this.getUtf8Index(str);
        int size = this.pool.size();
        int i = 0;
        while (i < size) {
            Object constant = this.pool.elementAt(i);
            if (constant instanceof ConstantString && ((ConstantString)constant).string_index == index) {
                return i;
            }
            ++i;
        }
        this.pool.addElement(new ConstantString(index));
        return this.pool.size() - 1;
    }
}

