/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.enhancer;

import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ClassFile;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.ConstantUtf8;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.FieldInfo;
import com.sap.engine.services.ejb.deploy.enhancer.classgenerator.MethodInfo;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;

public class EJBClassEnhancer {
    private Field[] cmf;
    private ClassFile classFile;
    private Class ejbClass;
    private Class baseClass;

    public EJBClassEnhancer(InputStream classData, Class ejbClass, Field[] cmFields, Class baseClass) throws IOException {
        this.cmf = cmFields;
        this.ejbClass = ejbClass;
        this.classFile = new ClassFile();
        this.baseClass = baseClass;
        this.classFile.read(new DataInputStream(classData));
    }

    public byte[] enhance() throws IOException {
        FieldInfo[] fields = this.classFile.getFields();
        int i = 0;
        while (i < this.cmf.length) {
            String upperCaseFieldName = this.cmf[i].getName().substring(0, 1).toUpperCase() + this.cmf[i].getName().substring(1);
            if (this.cmf[i].getDeclaringClass().getName().equals(this.ejbClass.getName()) && !this.isDefined("ejb_set" + upperCaseFieldName)) {
                MethodInfo method = this.classFile.addAbstractMethod(1025, Void.TYPE, "ejb_set" + upperCaseFieldName, new Class[]{this.cmf[i].getType()}, new Class[0]);
                method = this.classFile.addAbstractMethod(1025, this.cmf[i].getType(), "ejb_get" + upperCaseFieldName, new Class[0], new Class[0]);
            }
            ++i;
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        String[] fieldNames = new String[this.cmf.length];
        int x = 0;
        while (x < this.cmf.length) {
            fieldNames[x] = this.cmf[x].getName();
            ++x;
        }
        this.classFile.writeAbstractClass(new DataOutputStream(bos), fieldNames);
        return bos.toByteArray();
    }

    private boolean isDefined(String methodName) {
        MethodInfo[] methods = this.classFile.getMethods();
        int i = 0;
        while (i < methods.length) {
            String mName = ((ConstantUtf8)this.classFile.constantPool.pool.elementAt((int)methods[i].name_index)).value;
            if (mName.equals(methodName)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

