/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.ejbql;

import com.sap.ejbql.SchemaManager;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import java.util.HashSet;
import java.util.Hashtable;

public class SchemaManagerImpl
implements SchemaManager {
    private AbstractSchema schema = null;
    private HashSet ejbNames = null;
    private Hashtable entityDescs = null;
    private Hashtable localInterfaces = null;
    private Hashtable remoteInterfaces = null;

    public SchemaManagerImpl(EJBJarDescriptor jarDescr) {
        this.schema = jarDescr.getAbstractSchema();
        this.ejbNames = new HashSet();
        this.entityDescs = new Hashtable();
        this.localInterfaces = new Hashtable();
        this.remoteInterfaces = new Hashtable();
        DeploymentDescriptor[] descr = jarDescr.getDDescriptors();
        int i = 0;
        while (i < descr.length) {
            if (descr[i] instanceof CMPEntityDescriptor) {
                String remote;
                CMPEntityDescriptor cmpEntityDescr = (CMPEntityDescriptor)descr[i];
                String abstractSchemaName = cmpEntityDescr.getAbstractSchemaName();
                this.entityDescs.put(abstractSchemaName, cmpEntityDescr);
                String local = cmpEntityDescr.getLocalInterface();
                if (local != null) {
                    this.localInterfaces.put(local, abstractSchemaName);
                }
                if ((remote = cmpEntityDescr.getRemoteInterface()) != null) {
                    this.remoteInterfaces.put(remote, abstractSchemaName);
                }
            }
            this.ejbNames.add(descr[i].getEjbName());
            ++i;
        }
    }

    public boolean classExists(String className) {
        return true;
    }

    public boolean beanExists(String beanName) {
        return this.entityDescs.containsKey(beanName);
    }

    public boolean beanHasCmpField(String beanName, String cmpfName) {
        CMPEntityDescriptor cmpEntityDescr = (CMPEntityDescriptor)this.entityDescs.get(beanName);
        if (cmpEntityDescr == null) {
            return false;
        }
        PersistentField cmp = this.getCmpField(cmpEntityDescr, cmpfName);
        return cmp != null;
    }

    public boolean beanHasCmrField(String beanName, String cmrfName) {
        CMPEntityDescriptor cmpEntityDescr = (CMPEntityDescriptor)this.entityDescs.get(beanName);
        if (cmpEntityDescr == null) {
            return false;
        }
        RelationField cmr = this.getCmrFiled(cmpEntityDescr, cmrfName);
        return cmr != null;
    }

    public boolean isSingleValued(String beanName, String cmrfName) {
        CMPEntityDescriptor cmpEntityDescr = (CMPEntityDescriptor)this.entityDescs.get(beanName);
        RelationField cmr = this.getCmrFiled(cmpEntityDescr, cmrfName);
        if (cmr != null) {
            int multiplicity = this.getMultiplicity(cmr, cmpEntityDescr.getId());
            return multiplicity == 3 || multiplicity == 1;
        }
        return false;
    }

    public boolean isCollectionValued(String beanName, String cmrfName) {
        CMPEntityDescriptor cmpEntityDescr = (CMPEntityDescriptor)this.entityDescs.get(beanName);
        RelationField cmr = this.getCmrFiled(cmpEntityDescr, cmrfName);
        if (cmr != null) {
            int multiplicity = this.getMultiplicity(cmr, cmpEntityDescr.getId());
            return multiplicity == 4 || multiplicity == 2;
        }
        return false;
    }

    public String getCmpFieldType(String beanName, String cmpfName) {
        CMPEntityDescriptor cmpEntityDescr = (CMPEntityDescriptor)this.entityDescs.get(beanName);
        PersistentField cmp = this.getCmpField(cmpEntityDescr, cmpfName);
        if (cmp != null) {
            return cmp.getFieldType();
        }
        return null;
    }

    public String getCmrFieldType(String beanName, String cmrfName) {
        CMPEntityDescriptor cmpEntityDescr = (CMPEntityDescriptor)this.entityDescs.get(beanName);
        RelationField cmr = this.getCmrFiled(cmpEntityDescr, cmrfName);
        if (cmr != null) {
            return cmr.getFieldType();
        }
        return null;
    }

    public String getCmrFieldBaseType(String beanName, String cmrfName) {
        CMPEntityDescriptor cmpEntityDescr = (CMPEntityDescriptor)this.entityDescs.get(beanName);
        RelationField cmr = this.getCmrFiled(cmpEntityDescr, cmrfName);
        if (cmr != null) {
            return this.getRefBeanDescriptor(cmr, cmpEntityDescr.getId()).getAbstractSchemaName();
        }
        return null;
    }

    public boolean isEjbName(String name) {
        return this.ejbNames.contains(name);
    }

    public String getBeanFromLocal(String localInterfaceName) {
        return (String)this.localInterfaces.get(localInterfaceName);
    }

    public String getBeanFromRemote(String remoteInterfaceName) {
        return (String)this.remoteInterfaces.get(remoteInterfaceName);
    }

    private int getMultiplicity(RelationField cmr, int ejbId) {
        int cmrId = cmr.getRelationId();
        RelationDescriptor relDescr = this.schema.getRelDescriptor(cmrId);
        if (relDescr.recursiveRelation()) {
            OneSideRelationDescriptor side1 = relDescr.getSide1();
            if (side1.getCmrId() == cmrId) {
                return side1.getMultiplicityType();
            }
            OneSideRelationDescriptor side2 = relDescr.getSide1();
            return side2.getMultiplicityType();
        }
        OneSideRelationDescriptor mySide = relDescr.getMySideRelationDescriptor(ejbId);
        return mySide.getMultiplicityType();
    }

    private CMPEntityDescriptor getRefBeanDescriptor(RelationField cmr, int ejbId) {
        RelationDescriptor relDescr = this.schema.getRelDescriptor(cmr.getRelationId());
        OneSideRelationDescriptor refSide = relDescr.getRefSideRelationDescriptor(ejbId);
        return this.schema.getDescriptors()[refSide.getEjbId()];
    }

    private RelationField getCmrFiled(CMPEntityDescriptor cmpEntityDescr, String cmrfName) {
        if (cmpEntityDescr == null) {
            return null;
        }
        RelationField[] cmr = cmpEntityDescr.getCmrFields();
        if (cmr != null) {
            int i = 0;
            while (i < cmr.length) {
                if (cmr[i].getFieldName().equals(cmrfName)) {
                    return cmr[i];
                }
                ++i;
            }
        }
        return null;
    }

    private PersistentField getCmpField(CMPEntityDescriptor cmpEntityDescr, String cmpfName) {
        PersistentField[] cmp;
        if (cmpEntityDescr == null) {
            return null;
        }
        PersistentField[] pkCmp = cmpEntityDescr.getPKCmpFields();
        if (pkCmp != null) {
            int i = 0;
            while (i < pkCmp.length) {
                if (pkCmp[i].getFieldName().equals(cmpfName)) {
                    return pkCmp[i];
                }
                ++i;
            }
        }
        if ((cmp = cmpEntityDescr.getCmpFields()) != null) {
            int i = 0;
            while (i < cmp.length) {
                if (cmp[i].getFieldName().equals(cmpfName)) {
                    return cmp[i];
                }
                ++i;
            }
        }
        return null;
    }
}

