/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors.orMapping;

import com.sap.engine.interfaces.ejb.orMapping.OneSideCMRInfo;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.deploy.descriptors.orMapping.DumpUtils;

public class OneSideCMRInfoImpl
implements OneSideCMRInfo {
    private OneSideRelationDescriptor relSide = null;
    private String abstractBeanName = null;
    private String cmrFieldName = null;

    public OneSideCMRInfoImpl(OneSideRelationDescriptor relSide, AbstractSchema schema) {
        CMPEntityDescriptor descr = schema.getDescriptors()[relSide.getEjbId()];
        RelationField cmrField = null;
        int cmrId = relSide.getCmrId();
        if (cmrId != -1) {
            cmrField = descr.getCmrFields()[cmrId];
            this.cmrFieldName = cmrField.getFieldName();
        }
        this.abstractBeanName = descr.getAbstractSchemaName();
        this.relSide = relSide;
    }

    public String getAbstractBeanName() {
        return this.abstractBeanName;
    }

    public String getCmrFieldName() {
        return this.cmrFieldName;
    }

    public String[] getColumnNames() {
        return this.relSide.getFieldDBMap().getColumn();
    }

    public int getMultiplicity() {
        return this.relSide.getMultiplicityType();
    }

    public String display() {
        StringBuffer strBuff = new StringBuffer("  OneSideCMRInfo");
        strBuff.append(DumpUtils.lSeparator);
        strBuff.append("      abstract bean name: ");
        strBuff.append(this.getAbstractBeanName());
        strBuff.append(DumpUtils.lSeparator);
        strBuff.append("      cmr field: ");
        strBuff.append(this.getCmrFieldName());
        strBuff.append(DumpUtils.lSeparator);
        strBuff.append("      columns: ");
        strBuff.append(DumpUtils.arrayOfObjectsToString(this.getColumnNames()));
        switch (this.getMultiplicity()) {
            case 1: {
                strBuff.append("      multiplicity: ONE_TO_ONE");
                break;
            }
            case 2: {
                strBuff.append("      multiplicity: ONE_TO_MANY");
                break;
            }
            case 3: {
                strBuff.append("      multiplicity: MANY_TO_ONE");
                break;
            }
            case 4: {
                strBuff.append("      multiplicity: MANY_TO_MANY");
                break;
            }
            default: {
                strBuff.append("      multiplicity: NOT INITTED");
            }
        }
        return strBuff.toString();
    }

    public String toString() {
        return "  OneSideCMRInfo, abstract bean name: " + this.getAbstractBeanName() + ", cmr field: " + this.getCmrFieldName();
    }
}

