/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors.orMapping;

import com.sap.engine.interfaces.ejb.orMapping.CMRInfo;
import com.sap.engine.interfaces.ejb.orMapping.M2MInfo;
import com.sap.engine.interfaces.ejb.orMapping.OneSideCMRInfo;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.orMapping.DumpUtils;
import com.sap.engine.services.ejb.deploy.descriptors.orMapping.M2MInfoImpl;
import com.sap.engine.services.ejb.deploy.descriptors.orMapping.OneSideCMRInfoImpl;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.M2MRelationFieldMap;

public class CMRInfoImpl
implements CMRInfo {
    private RelationDescriptor relation = null;
    private OneSideCMRInfo side1 = null;
    private OneSideCMRInfo side2 = null;
    private M2MInfo m2mInfo = null;

    public CMRInfoImpl(RelationDescriptor relation, AbstractSchema schema) {
        this.relation = relation;
        this.side1 = new OneSideCMRInfoImpl(relation.getSide1(), schema);
        this.side2 = new OneSideCMRInfoImpl(relation.getSide2(), schema);
    }

    public OneSideCMRInfo onMySideOfRelation(String abstractBeanName) {
        if (this.side1.getAbstractBeanName().equals(abstractBeanName)) {
            return this.side1;
        }
        return this.side2;
    }

    public OneSideCMRInfo onOtherSideOfRelation(String abstractBeanName) {
        if (this.side1.getAbstractBeanName().equals(abstractBeanName)) {
            return this.side2;
        }
        return this.side1;
    }

    public M2MInfo getM2MInfo() {
        M2MRelationFieldMap m2m = this.relation.getM2MMap();
        if (this.m2mInfo == null && m2m != null) {
            this.m2mInfo = new M2MInfoImpl(m2m, this.side1.getAbstractBeanName());
        }
        return this.m2mInfo;
    }

    public String display() {
        StringBuffer strBuff = new StringBuffer("  CMRInfoImpl");
        strBuff.append(DumpUtils.lSeparator);
        if (this.side1 == null) {
            strBuff.append("      oneSide: null");
            strBuff.append(DumpUtils.lSeparator);
        } else {
            strBuff.append("      oneSide: ");
            strBuff.append(this.side1.display());
            strBuff.append(DumpUtils.lSeparator);
        }
        if (this.side2 == null) {
            strBuff.append("      otherSide: null");
            strBuff.append(DumpUtils.lSeparator);
        } else {
            strBuff.append("      otherSide: ");
            strBuff.append(this.side2.display());
            strBuff.append(DumpUtils.lSeparator);
        }
        if (this.getM2MInfo() == null) {
            strBuff.append("      M2M: null");
            strBuff.append(DumpUtils.lSeparator);
        } else {
            strBuff.append("      M2M: ");
            strBuff.append(this.getM2MInfo().display());
            strBuff.append(DumpUtils.lSeparator);
        }
        return strBuff.toString();
    }

    public String toString() {
        return "  CMRInfoImpl, side1: " + this.side1.toString() + ", side2: " + this.side2.toString();
    }
}

