/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors.orMapping;

import com.sap.engine.interfaces.ejb.orMapping.BeanORMapping;
import com.sap.engine.interfaces.ejb.orMapping.CMPInfo;
import com.sap.engine.interfaces.ejb.orMapping.CMRInfo;
import com.sap.engine.interfaces.ejb.orMapping.DVInfo;
import com.sap.engine.interfaces.ejb.orMapping.DisplayObject;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DependentValueDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.orMapping.CMPInfoImpl;
import com.sap.engine.services.ejb.deploy.descriptors.orMapping.CMRInfoImpl;
import com.sap.engine.services.ejb.deploy.descriptors.orMapping.DVInfoImpl;
import com.sap.engine.services.ejb.deploy.descriptors.orMapping.DumpUtils;
import java.util.Vector;

public class BeanORMappingImpl
implements BeanORMapping {
    private AbstractSchema schema = null;
    private CMPEntityDescriptor descr = null;
    private CMPInfo[] pkCmpFields = null;
    private CMPInfo[] notPkCmpFields = null;
    private DVInfo[] dvCmpFields = null;
    private CMRInfo[] cmrFields = null;

    public BeanORMappingImpl(CMPEntityDescriptor descr, AbstractSchema schema) {
        this.schema = schema;
        this.descr = descr;
    }

    public String getAbstractBeanName() {
        return this.descr.getAbstractSchemaName();
    }

    public String getEjbName() {
        return this.descr.getEjbName();
    }

    public String getTableName() {
        return this.descr.getTableName();
    }

    public String getPrimaryKeyClassName() {
        return this.descr.getPrimaryKeyClass();
    }

    public CMPInfo[] getPKCMPFields() {
        PersistentField[] fields = null;
        if (this.pkCmpFields == null) {
            fields = this.descr.getPKCmpFields();
            this.pkCmpFields = new CMPInfoImpl[fields.length];
            int i = 0;
            while (i < fields.length) {
                this.pkCmpFields[i] = new CMPInfoImpl(fields[i]);
                ++i;
            }
        }
        return this.pkCmpFields;
    }

    public CMPInfo[] getNotPKCMPFields() {
        this.initCMPFields();
        return this.notPkCmpFields;
    }

    public DVInfo[] getDependentValueFields() {
        this.initCMPFields();
        return this.dvCmpFields;
    }

    public CMRInfo[] getRelations() {
        RelationDescriptor[] relDescr = null;
        if (this.cmrFields == null) {
            relDescr = this.schema.getRelationDescriptors(this.descr.getId());
            this.cmrFields = new CMRInfo[relDescr.length];
            int i = 0;
            while (i < relDescr.length) {
                this.cmrFields[i] = new CMRInfoImpl(relDescr[i], this.schema);
                ++i;
            }
        }
        return this.cmrFields;
    }

    public String display() {
        StringBuffer strBuff = new StringBuffer("BeanORMappingImpl");
        strBuff.append(DumpUtils.lSeparator);
        strBuff.append("    ejb name: ");
        strBuff.append(this.getEjbName());
        strBuff.append(DumpUtils.lSeparator);
        strBuff.append("    abstract bean name: ");
        strBuff.append(this.getAbstractBeanName());
        strBuff.append(DumpUtils.lSeparator);
        strBuff.append("    table name: ");
        strBuff.append(this.getTableName());
        strBuff.append(DumpUtils.lSeparator);
        strBuff.append("    pk class: ");
        strBuff.append(this.getPrimaryKeyClassName());
        strBuff.append(DumpUtils.lSeparator);
        strBuff.append("    **********PK FIELDS***********");
        strBuff.append(DumpUtils.lSeparator);
        CMPInfo[] pkCmpInfo = this.getPKCMPFields();
        strBuff.append(DumpUtils.arrayOfObjectsToString((DisplayObject[])pkCmpInfo));
        strBuff.append("    **********NOT PK FIELDS***********");
        strBuff.append(DumpUtils.lSeparator);
        CMPInfo[] cmpInfo = this.getNotPKCMPFields();
        strBuff.append(DumpUtils.arrayOfObjectsToString((DisplayObject[])cmpInfo));
        strBuff.append("    **********DV FIELDS***********");
        strBuff.append(DumpUtils.lSeparator);
        DVInfo[] dv = this.getDependentValueFields();
        strBuff.append(DumpUtils.arrayOfObjectsToString((DisplayObject[])dv));
        strBuff.append("    **********CMR FIELDS***********");
        strBuff.append(DumpUtils.lSeparator);
        CMRInfo[] cmr = this.getAllRelations();
        strBuff.append(DumpUtils.arrayOfObjectsToString((DisplayObject[])cmr));
        return strBuff.toString();
    }

    public String toString() {
        return "BeanORMappingImpl, ejb name: " + this.getEjbName();
    }

    private CMRInfo[] getAllRelations() {
        RelationDescriptor[] relDescr = this.schema.getRelationDescriptors(this.descr.getId());
        CMRInfo[] tempCmrFields = new CMRInfo[relDescr.length];
        int i = 0;
        while (i < relDescr.length) {
            tempCmrFields[i] = new CMRInfoImpl(relDescr[i], this.schema);
            ++i;
        }
        return tempCmrFields;
    }

    private void initCMPFields() {
        PersistentField[] fields = null;
        Vector<CMPInfoImpl> vCmp = null;
        Vector<DVInfoImpl> vDvCmp = null;
        if (this.notPkCmpFields == null) {
            vCmp = new Vector<CMPInfoImpl>();
            vDvCmp = new Vector<DVInfoImpl>();
            fields = this.descr.getCmpFields();
            int i = 0;
            while (i < fields.length) {
                if (fields[i] instanceof DependentValueDescriptor) {
                    vDvCmp.addElement(new DVInfoImpl((DependentValueDescriptor)fields[i]));
                } else {
                    vCmp.addElement(new CMPInfoImpl(fields[i]));
                }
                ++i;
            }
            this.notPkCmpFields = vCmp.toArray(new CMPInfo[vCmp.size()]);
            this.dvCmpFields = vDvCmp.toArray(new DVInfo[vDvCmp.size()]);
        }
    }
}

