/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors;

import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.exceptions.BaseIllegalArgumentException;

public class SessionDescriptor
extends DeploymentDescriptor {
    public static final int STATELESS_SESSION = 0;
    public static final int STATEFUL_SESSION = 1;
    private int sessionType = -1;
    private int transactionType = -1;
    private int sessionTimeOut;
    private int statefulTimeOut;
    private boolean keepsOpenResources = false;
    private boolean passivate = false;
    private int lruLimit;
    private boolean statefulFailover = false;

    public boolean keepsOpenResources() {
        return this.keepsOpenResources;
    }

    public void setKeepsOpenResources(boolean keepsORes) {
        this.keepsOpenResources = keepsORes;
    }

    public boolean usePassivation() {
        return this.passivate;
    }

    public void setUsePassivation(boolean toPsv) {
        this.passivate = toPsv;
    }

    public int getLruLimit() {
        return this.lruLimit;
    }

    public void setLruLimit(int limit) {
        this.lruLimit = limit;
    }

    public boolean useStatefulFailover() {
        return this.statefulFailover;
    }

    public void setStatefulFailover(boolean _statefulFailover) {
        if (this.sessionType == 1) {
            this.statefulFailover = _statefulFailover;
        }
    }

    public int getSessionType() {
        return this.sessionType;
    }

    public void setSessionType(int sesType) {
        this.sessionType = sesType;
    }

    public int getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(int transType) {
        this.transactionType = transType;
    }

    public void setTransactionDescriptors(ControlDescriptor[] trans) {
        if (trans != null && trans.length > 0 && this.transactionType == 0) {
            throw new BaseIllegalArgumentException("ejb_2182", new Object[]{this.getEjbName()});
        }
        super.setTransactionDescriptors(trans);
    }

    public String getBootClassName() {
        if (this.sessionType == 0) {
            return "com.sap.engine.services.ejb.session.stateless.StatelessContainer";
        }
        return "com.sap.engine.services.ejb.session.stateful.StatefulContainer";
    }

    public int getSessionTimeout() {
        return this.sessionTimeOut;
    }

    public void setSessionTimeout(int timeOut) {
        this.sessionTimeOut = timeOut;
    }

    public int getStatefulTimeout() {
        return this.statefulTimeOut;
    }

    public void setStatefulTimeout(int timeOut) {
        this.statefulTimeOut = timeOut;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionDescriptor)) {
            return false;
        }
        if (!super.equals((DeploymentDescriptor)obj)) {
            return false;
        }
        SessionDescriptor sd = (SessionDescriptor)obj;
        if (this.sessionType != sd.getSessionType()) {
            return false;
        }
        if (this.transactionType != sd.getTransactionType()) {
            return false;
        }
        if (this.sessionTimeOut != sd.getSessionTimeout()) {
            return false;
        }
        if (this.statefulTimeOut != sd.getStatefulTimeout()) {
            return false;
        }
        if (this.keepsOpenResources != sd.keepsOpenResources()) {
            return false;
        }
        if (this.lruLimit != sd.getLruLimit()) {
            return false;
        }
        return this.passivate == sd.usePassivation();
    }

    public Object clone() {
        SessionDescriptor sd = (SessionDescriptor)super.clone();
        sd.setSessionType(this.sessionType);
        sd.setTransactionType(this.transactionType);
        sd.setSessionTimeout(this.sessionTimeOut);
        sd.setStatefulTimeout(this.statefulTimeOut);
        sd.setKeepsOpenResources(this.keepsOpenResources);
        sd.setLruLimit(this.lruLimit);
        sd.setUsePassivation(this.passivate);
        sd.setStatefulFailover(this.statefulFailover);
        return sd;
    }
}

