/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors;

import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.M2MRelationFieldMap;
import java.io.Serializable;

public class RelationDescriptor
implements Serializable {
    public static final int ONE_TO_ONE = 1;
    public static final int ONE_TO_MANY = 2;
    public static final int MANY_TO_ONE = 3;
    public static final int MANY_TO_MANY = 4;
    protected String relationName = null;
    protected String relationDescription = null;
    protected OneSideRelationDescriptor side1 = null;
    protected OneSideRelationDescriptor side2 = null;
    protected M2MRelationFieldMap m2mMap = null;
    private PersistentField cmpFieldInOneColumn = null;

    public boolean shareOneColumnWithCmpField() {
        return this.cmpFieldInOneColumn != null;
    }

    public PersistentField getCmpFieldInOneColumn() {
        return this.cmpFieldInOneColumn;
    }

    public void setCmpFieldInOneColumn(PersistentField _cmpFieldInOneColumn) {
        this.cmpFieldInOneColumn = _cmpFieldInOneColumn;
    }

    public OneSideRelationDescriptor getSide1() {
        return this.side1;
    }

    public void setSide1(OneSideRelationDescriptor side1) {
        this.side1 = side1;
    }

    public OneSideRelationDescriptor getSide2() {
        return this.side2;
    }

    public void setSide2(OneSideRelationDescriptor side2) {
        this.side2 = side2;
    }

    public String getRelationDescription() {
        return this.relationDescription;
    }

    public void setRelationDescription(String relationDescription) {
        this.relationDescription = relationDescription;
    }

    public String getRelationName() {
        return this.relationName;
    }

    public void setRelationName(String relationName) {
        this.relationName = relationName;
    }

    public OneSideRelationDescriptor getMySideRelationDescriptor(int ejbId) {
        if (ejbId == this.side1.getEjbId()) {
            return this.side1;
        }
        return this.side2;
    }

    public OneSideRelationDescriptor getRefSideRelationDescriptor(int ejbId) {
        if (ejbId == this.side1.getEjbId()) {
            return this.side2;
        }
        return this.side1;
    }

    public OneSideRelationDescriptor getPKSide() {
        if (this.getM2MMap() != null) {
            return null;
        }
        if (this.side1.isPKSide()) {
            return this.side1;
        }
        return this.side2;
    }

    public OneSideRelationDescriptor getFKSide() {
        if (this.getM2MMap() != null) {
            return null;
        }
        if (this.side1.isPKSide()) {
            return this.side2;
        }
        return this.side1;
    }

    public M2MRelationFieldMap getM2MMap() {
        return this.m2mMap;
    }

    public void setM2MMap(M2MRelationFieldMap m2mMap) {
        this.m2mMap = m2mMap;
    }

    public boolean recursiveRelation() {
        return this.side1.getEjbId() == this.side2.getEjbId();
    }

    public Object clone() {
        RelationDescriptor cloning = new RelationDescriptor();
        cloning.setRelationName(this.relationName == null ? null : new String(this.relationName));
        cloning.setRelationDescription(this.relationDescription == null ? null : new String(this.relationDescription));
        cloning.setSide1(this.side1 == null ? null : (OneSideRelationDescriptor)this.side1.clone());
        cloning.setSide2(this.side2 == null ? null : (OneSideRelationDescriptor)this.side2.clone());
        cloning.setM2MMap(this.m2mMap == null ? null : (M2MRelationFieldMap)this.m2mMap.clone());
        return cloning;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RelationDescriptor)) {
            return false;
        }
        RelationDescriptor temp = (RelationDescriptor)obj;
        if (!EqualUtils.equalObjects(this.relationName, temp.getRelationName())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.relationDescription, temp.getRelationDescription())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.side1, temp.getSide1())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.side2, temp.getSide2())) {
            return false;
        }
        return EqualUtils.equalObjects(this.m2mMap, temp.getM2MMap());
    }
}

