/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.ejb.ContainerBoot;
import com.sap.engine.services.ejb.deploy.descriptors.AccessControls;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.IORDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.exceptions.BaseIllegalArgumentException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.w3c.dom.Document;

public abstract class DeploymentDescriptor
implements Serializable,
Descriptor {
    public static final int NOT_INITED = -1;
    public static final int BEAN_TRANSACTION = 0;
    public static final int CONTAINER_TRANSACTION = 1;
    protected String beanClassName = null;
    private String remoteInterface = null;
    private String remoteHomeInterface = null;
    private String localInterface = null;
    private String localHomeInterface = null;
    protected String runtimeClassName = null;
    private String ejbHomeImpl = null;
    private String ejbLocalHomeImpl = null;
    private String ejbObjectImpl = null;
    private String ejbLocalObjectImpl = null;
    protected int[] useIndex = null;
    protected EJBJarDescriptor jarDescriptor;
    protected ControlDescriptor[] transactionDescriptors;
    private AccessControls[] accessControlEntries;
    private IORDescriptor[] iorDescriptors = null;
    private Properties beanProperties;
    private EnvironmentEntry[] environment;
    private ResourceReference[] resourceReferences;
    private ResourceEnvReference[] resourceEnvReferences;
    private EJBeanReference[] ejbeanReferences;
    private EJBeanLocalReference[] ejbeanLocalReferences;
    private ComponentReference[] compRefs;
    private MethodEntry[] uncallableMethods;
    private Hashtable roleReferences = new Hashtable();
    private SecurityIdentity securityIdentity;
    private String displayName;
    private String ejbName;
    private String jndiName;
    private String jndiNameUpdated;
    private transient SerializableFile smallIcon;
    private transient SerializableFile largeIcon;
    private transient ContainerBoot containerBoot;
    private String description;
    private int containerSize = 0;
    private int isolationLevel = -1;
    private transient Hashtable interfacesMap = new Hashtable();

    public void setMethodAliases(String intferfaceType, Hashtable methodAliases) {
        this.interfacesMap.put(intferfaceType, methodAliases);
    }

    public String getMethodAlias(String intferfaceType, Method method) {
        Hashtable methodAliases = (Hashtable)this.interfacesMap.get(intferfaceType);
        return (String)methodAliases.get(method);
    }

    public SerializableFile getLargeIcon() {
        return this.largeIcon;
    }

    public void setLargeIcon(String larIcon) {
        this.largeIcon = new SerializableFile(larIcon);
    }

    public SerializableFile getSmallIcon() {
        return this.smallIcon;
    }

    public void setSmallIcon(String smIcon) {
        this.smallIcon = new SerializableFile(smIcon);
    }

    public void setSmallIcon(SerializableFile smallIcon) {
        this.smallIcon = smallIcon;
    }

    public void setLargeIcon(SerializableFile largeIcon) {
        this.largeIcon = largeIcon;
    }

    public void setBeanName(String ejb_name, String appName) {
        if (ejb_name != null && !ejb_name.equals("")) {
            this.ejbName = ejb_name;
            if (this.jndiName == null) {
                this.jndiName = appName + "/" + ejb_name;
            }
        } else {
            this.ejbName = null;
        }
    }

    public void setBeanName(String ejb_name) {
        this.ejbName = ejb_name != null && !ejb_name.equals("") ? ejb_name : null;
    }

    public void setEjbName(String ejbName) {
        this.ejbName = ejbName;
    }

    public String getEjbName() {
        return this.ejbName;
    }

    public void setJndiName(String jndi_name) {
        this.jndiName = jndi_name;
    }

    public String getJndiName() {
        return this.jndiName;
    }

    public void setJndiNameUpdated(String jndi_name) {
        this.jndiNameUpdated = jndi_name;
    }

    public String getJndiNameUpdated() {
        return this.jndiNameUpdated;
    }

    public String getClassName() {
        return this.beanClassName;
    }

    public void setClassName(String bClassName) {
        this.beanClassName = bClassName;
        this.runtimeClassName = bClassName;
    }

    public String getRemoteHomeInterface() {
        return this.remoteHomeInterface;
    }

    public void setRemoteHomeInterface(String remHomeInterfaceClassName) {
        this.remoteHomeInterface = remHomeInterfaceClassName;
    }

    public String getRemoteInterface() {
        return this.remoteInterface;
    }

    public void setRemoteInterface(String remIntf) {
        this.remoteInterface = remIntf;
    }

    public String getLocalHomeInterface() {
        return this.localHomeInterface;
    }

    public void setLocalHomeInterface(String locHomeIntf) {
        this.localHomeInterface = locHomeIntf;
    }

    public String getLocalInterface() {
        return this.localInterface;
    }

    public void setLocalInterface(String locIntf) {
        this.localInterface = locIntf;
    }

    public boolean hasRemoteInterfaces() {
        return this.remoteInterface != null && this.remoteHomeInterface != null;
    }

    public boolean hasLocalInterfaces() {
        return this.localInterface != null && this.localHomeInterface != null;
    }

    public void setEjbHomeImpl(String ejbHome_impl) {
        this.ejbHomeImpl = ejbHome_impl;
    }

    public String getEjbHomeImpl() {
        return this.ejbHomeImpl;
    }

    public void setEjbObjectImpl(String ejbObject_impl) {
        this.ejbObjectImpl = ejbObject_impl;
    }

    public String getEjbObjectImpl() {
        return this.ejbObjectImpl;
    }

    public void setEjbLocalHomeImpl(String ejbLocalHome_impl) {
        this.ejbLocalHomeImpl = ejbLocalHome_impl;
    }

    public String getEjbLocalHomeImpl() {
        return this.ejbLocalHomeImpl;
    }

    public void setEjbLocalObjectImpl(String ejbLocalObject_impl) {
        this.ejbLocalObjectImpl = ejbLocalObject_impl;
    }

    public String getEjbLocalObjectImpl() {
        return this.ejbLocalObjectImpl;
    }

    public EJBJarDescriptor getEJBJarDescriptor() {
        return this.jarDescriptor;
    }

    public void setEJBJarDescriptor(EJBJarDescriptor descr) {
        this.jarDescriptor = descr;
    }

    public ControlDescriptor[] getTransactionDescriptors() {
        return this.transactionDescriptors;
    }

    public void setTransactionDescriptors(ControlDescriptor[] transactionDescriptors) {
        this.transactionDescriptors = transactionDescriptors;
    }

    public AccessControls[] getAccessControlEntries() {
        return this.accessControlEntries;
    }

    public void setAccessControlEntries(AccessControls[] accessControlEntries) {
        this.accessControlEntries = accessControlEntries;
    }

    public Properties getBeanProperties() {
        if (this.beanProperties != null) {
            return this.beanProperties;
        }
        return new Properties();
    }

    public void setBeanProperties(Properties bean_props) {
        this.beanProperties = bean_props;
    }

    public EnvironmentEntry[] getEnvironmentEntries() {
        return this.environment;
    }

    public void setEnvironmentEntries(EnvironmentEntry[] environment) {
        this.environment = environment;
    }

    public ResourceReference[] getResourceReferences() {
        return this.resourceReferences;
    }

    public void setResourceReferences(ResourceReference[] resourceReferences) {
        this.resourceReferences = resourceReferences;
    }

    public EJBeanReference[] getEJBeanReferences() {
        return this.ejbeanReferences;
    }

    public void setEJBeanReferences(EJBeanReference[] ejbeanRfs) {
        this.ejbeanReferences = ejbeanRfs;
    }

    public EJBeanLocalReference[] getEJBeanLocalReferences() {
        return this.ejbeanLocalReferences;
    }

    public void setEJBeanLocalReferences(EJBeanLocalReference[] ejbeanLocRfs) {
        this.ejbeanLocalReferences = ejbeanLocRfs;
    }

    public ComponentReference[] getServerComponentReferences() {
        return this.compRefs;
    }

    public void setServerComponentReferences(ComponentReference[] compReferences) {
        this.compRefs = compReferences;
    }

    public MethodEntry[] getUncalableMethods() {
        return this.uncallableMethods;
    }

    public void setUncalableMethods(MethodEntry[] uncallMeth) {
        this.uncallableMethods = uncallMeth;
    }

    public Hashtable getRoleReferences() {
        return this.roleReferences;
    }

    public void setRoleReferences(Hashtable roleReferences) {
        this.roleReferences = roleReferences;
    }

    public ResourceEnvReference[] getResourceEnvReferences() {
        return this.resourceEnvReferences;
    }

    public void setResourceEnvReferences(ResourceEnvReference[] resourceEnvReferences) {
        this.resourceEnvReferences = resourceEnvReferences;
    }

    public SecurityIdentity getSecurityIdentity() {
        return this.securityIdentity;
    }

    public void setSecurityIdentity(SecurityIdentity security_identity) {
        this.securityIdentity = security_identity;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getContainerSize() {
        return this.containerSize;
    }

    public void setContainerSize(int contSize) {
        this.containerSize = contSize;
    }

    public void setContainerBoot(ContainerBoot contBoot) {
        this.containerBoot = contBoot;
    }

    public ContainerBoot getContainerBoot() {
        return this.containerBoot;
    }

    public String getRuntimeClassName() {
        return this.runtimeClassName;
    }

    public int[] getUseIndex() {
        return this.useIndex;
    }

    public void setUseIndex(int[] use_index) {
        this.useIndex = use_index;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setIsolationLevel(String isoLevel) {
        if (isoLevel == null) throw new BaseIllegalArgumentException("ejb_2174", new Object[]{null});
        if (isoLevel.equals("Committed")) {
            this.isolationLevel = 2;
            return;
        } else if (isoLevel.equals("Uncommitted")) {
            this.isolationLevel = 1;
            return;
        } else if (isoLevel.equals("Repeatable")) {
            this.isolationLevel = 4;
            return;
        } else {
            if (!isoLevel.equals("Serializable")) throw new BaseIllegalArgumentException("ejb_2174", new Object[]{isoLevel});
            this.isolationLevel = 8;
        }
    }

    public void setUncommittedIsolationLevel() {
        this.isolationLevel = 1;
    }

    public void setIsolationLevel(int isolationLevel) {
        this.isolationLevel = isolationLevel;
    }

    public int getIsolationLevel() {
        return this.isolationLevel;
    }

    public abstract String getBootClassName();

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeploymentDescriptor)) {
            return false;
        }
        DeploymentDescriptor dd = (DeploymentDescriptor)obj;
        if (dd.beanClassName != null ? !dd.beanClassName.equals(this.beanClassName) : this.beanClassName != null) {
            return false;
        }
        if (dd.remoteInterface != null ? !dd.remoteInterface.equals(this.remoteInterface) : this.remoteInterface != null) {
            return false;
        }
        if (dd.remoteHomeInterface != null ? !dd.remoteHomeInterface.equals(this.remoteHomeInterface) : this.remoteHomeInterface != null) {
            return false;
        }
        if (dd.localInterface != null ? !dd.localInterface.equals(this.localInterface) : this.localInterface != null) {
            return false;
        }
        if (dd.localHomeInterface != null ? !dd.localHomeInterface.equals(this.localHomeInterface) : this.localHomeInterface != null) {
            return false;
        }
        if (dd.runtimeClassName != null ? !dd.runtimeClassName.equals(this.runtimeClassName) : this.runtimeClassName != null) {
            return false;
        }
        if (dd.ejbHomeImpl != null ? !dd.ejbHomeImpl.equals(this.ejbHomeImpl) : this.ejbHomeImpl != null) {
            return false;
        }
        if (dd.ejbLocalHomeImpl != null ? !dd.ejbLocalHomeImpl.equals(this.ejbLocalHomeImpl) : this.ejbLocalHomeImpl != null) {
            return false;
        }
        if (dd.ejbObjectImpl != null ? !dd.ejbObjectImpl.equals(this.ejbObjectImpl) : this.ejbObjectImpl != null) {
            return false;
        }
        if (dd.ejbLocalObjectImpl != null ? !dd.ejbLocalObjectImpl.equals(this.ejbLocalObjectImpl) : this.ejbLocalObjectImpl != null) {
            return false;
        }
        if (dd.jndiName != null ? !dd.jndiName.equals(this.jndiName) : this.jndiName != null) {
            return false;
        }
        if (dd.ejbName != null ? !dd.ejbName.equals(this.ejbName) : this.ejbName != null) {
            return false;
        }
        if (dd.displayName != null ? !dd.displayName.equals(this.displayName) : this.displayName != null) {
            return false;
        }
        if (dd.description != null ? !dd.description.equals(this.description) : this.description != null) {
            return false;
        }
        if (dd.smallIcon != null ? !dd.smallIcon.equals(this.smallIcon) : this.smallIcon != null) {
            return false;
        }
        if (dd.largeIcon != null ? !dd.largeIcon.equals(this.largeIcon) : this.largeIcon != null) {
            return false;
        }
        if (dd.containerSize != this.containerSize) {
            return false;
        }
        if (dd.beanProperties != null ? !((Hashtable)dd.beanProperties).equals(this.beanProperties) : this.beanProperties != null) {
            return false;
        }
        if (dd.securityIdentity != null ? !dd.securityIdentity.equals(this.securityIdentity) : this.securityIdentity != null) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(dd.transactionDescriptors, this.transactionDescriptors)) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(dd.accessControlEntries, this.accessControlEntries)) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(dd.environment, this.environment)) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(dd.resourceReferences, this.resourceReferences)) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(dd.ejbeanReferences, this.ejbeanReferences)) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(dd.ejbeanLocalReferences, this.ejbeanLocalReferences)) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(dd.uncallableMethods, this.uncallableMethods)) {
            return false;
        }
        if (!EqualUtils.equalHashtable(this.roleReferences, dd.roleReferences)) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(dd.resourceEnvReferences, this.resourceEnvReferences)) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(dd.compRefs, this.compRefs)) {
            return false;
        }
        if (dd.useIndex != null || this.useIndex != null) {
            if (dd.useIndex == null || this.useIndex == null) {
                return false;
            }
            if (dd.useIndex.length != this.useIndex.length) {
                return false;
            }
            int i = 0;
            while (i < dd.useIndex.length) {
                if (dd.useIndex[i] != this.useIndex[i]) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public Object clone() {
        int i;
        DeploymentDescriptor cloning = null;
        cloning = this instanceof CMPEntityDescriptor ? new CMPEntityDescriptor() : (this instanceof EntityDescriptor ? new EntityDescriptor() : (this instanceof MessageDrivenDescriptor ? new MessageDrivenDescriptor() : new SessionDescriptor()));
        cloning.beanClassName = this.beanClassName == null ? null : new String(this.beanClassName);
        cloning.runtimeClassName = this.runtimeClassName == null ? null : new String(this.runtimeClassName);
        cloning.remoteInterface = this.remoteInterface == null ? null : new String(this.remoteInterface);
        cloning.remoteHomeInterface = this.remoteHomeInterface == null ? null : new String(this.remoteHomeInterface);
        cloning.localInterface = this.localInterface == null ? null : new String(this.localInterface);
        cloning.localHomeInterface = this.localHomeInterface == null ? null : new String(this.localHomeInterface);
        cloning.ejbHomeImpl = this.ejbHomeImpl == null ? null : new String(this.ejbHomeImpl);
        cloning.ejbLocalHomeImpl = this.ejbLocalHomeImpl == null ? null : new String(this.ejbLocalHomeImpl);
        cloning.ejbObjectImpl = this.ejbObjectImpl == null ? null : new String(this.ejbObjectImpl);
        cloning.ejbLocalObjectImpl = this.ejbLocalObjectImpl == null ? null : new String(this.ejbLocalObjectImpl);
        cloning.jndiName = this.jndiName == null ? null : new String(this.jndiName);
        cloning.ejbName = this.ejbName == null ? null : new String(this.ejbName);
        cloning.displayName = this.displayName == null ? null : new String(this.displayName);
        cloning.description = this.description == null ? null : new String(this.description);
        cloning.containerSize = this.containerSize;
        cloning.smallIcon = this.smallIcon != null ? (SerializableFile)this.smallIcon.clone() : null;
        cloning.largeIcon = this.largeIcon != null ? (SerializableFile)this.largeIcon.clone() : null;
        cloning.securityIdentity = this.securityIdentity != null ? (SecurityIdentity)this.securityIdentity.clone() : null;
        if (this.useIndex == null) {
            cloning.useIndex = null;
        } else {
            cloning.useIndex = new int[this.useIndex.length];
            i = 0;
            while (i < this.useIndex.length) {
                cloning.useIndex[i] = this.useIndex[i];
                ++i;
            }
        }
        if (this.transactionDescriptors == null) {
            cloning.transactionDescriptors = null;
        } else {
            cloning.transactionDescriptors = new ControlDescriptor[this.transactionDescriptors.length];
            i = 0;
            while (i < this.transactionDescriptors.length) {
                cloning.transactionDescriptors[i] = this.transactionDescriptors[i] == null ? null : (ControlDescriptor)this.transactionDescriptors[i].clone();
                ++i;
            }
        }
        if (this.accessControlEntries == null) {
            cloning.accessControlEntries = null;
        } else {
            cloning.accessControlEntries = new AccessControls[this.accessControlEntries.length];
            i = 0;
            while (i < this.accessControlEntries.length) {
                cloning.accessControlEntries[i] = this.accessControlEntries[i] == null ? null : (AccessControls)this.accessControlEntries[i].clone();
                ++i;
            }
        }
        if (this.environment == null) {
            cloning.environment = null;
        } else {
            cloning.environment = new EnvironmentEntry[this.environment.length];
            i = 0;
            while (i < this.environment.length) {
                cloning.environment[i] = this.environment[i] == null ? null : (EnvironmentEntry)this.environment[i].clone();
                ++i;
            }
        }
        if (this.resourceReferences == null) {
            cloning.resourceReferences = null;
        } else {
            cloning.resourceReferences = new ResourceReference[this.resourceReferences.length];
            i = 0;
            while (i < this.resourceReferences.length) {
                cloning.resourceReferences[i] = this.resourceReferences[i] == null ? null : (ResourceReference)this.resourceReferences[i].clone();
                ++i;
            }
        }
        if (this.ejbeanReferences == null) {
            cloning.ejbeanReferences = null;
        } else {
            cloning.ejbeanReferences = new EJBeanReference[this.ejbeanReferences.length];
            i = 0;
            while (i < this.ejbeanReferences.length) {
                cloning.ejbeanReferences[i] = this.ejbeanReferences[i] == null ? null : (EJBeanReference)this.ejbeanReferences[i].clone();
                ++i;
            }
        }
        if (this.ejbeanLocalReferences == null) {
            cloning.ejbeanLocalReferences = null;
        } else {
            cloning.ejbeanLocalReferences = new EJBeanLocalReference[this.ejbeanLocalReferences.length];
            i = 0;
            while (i < this.ejbeanLocalReferences.length) {
                cloning.ejbeanLocalReferences[i] = this.ejbeanLocalReferences[i] == null ? null : (EJBeanLocalReference)this.ejbeanLocalReferences[i].clone();
                ++i;
            }
        }
        if (this.uncallableMethods == null) {
            cloning.uncallableMethods = null;
        } else {
            cloning.uncallableMethods = new MethodEntry[this.uncallableMethods.length];
            i = 0;
            while (i < this.uncallableMethods.length) {
                cloning.uncallableMethods[i] = this.uncallableMethods[i] == null ? null : (MethodEntry)this.uncallableMethods[i].clone();
                ++i;
            }
        }
        cloning.roleReferences = this.roleReferences == null ? null : (Hashtable)this.roleReferences.clone();
        if (this.resourceEnvReferences == null) {
            cloning.resourceEnvReferences = null;
        } else {
            cloning.resourceEnvReferences = new ResourceEnvReference[this.resourceEnvReferences.length];
            i = 0;
            while (i < this.resourceEnvReferences.length) {
                cloning.resourceEnvReferences[i] = this.resourceEnvReferences[i] == null ? null : (ResourceEnvReference)this.resourceEnvReferences[i].clone();
                ++i;
            }
        }
        if (this.compRefs == null) {
            cloning.compRefs = null;
        } else {
            cloning.compRefs = new ComponentReference[this.compRefs.length];
            i = 0;
            while (i < this.compRefs.length) {
                cloning.compRefs[i] = this.compRefs[i] == null ? null : (ComponentReference)this.compRefs[i].clone();
                ++i;
            }
        }
        if (this.beanProperties == null) {
            cloning.beanProperties = null;
        } else {
            cloning.beanProperties = new Properties();
            Enumeration<?> enumeration = this.beanProperties.propertyNames();
            String name = null;
            while (enumeration.hasMoreElements()) {
                name = (String)enumeration.nextElement();
                cloning.beanProperties.setProperty(new String(name), new String(this.beanProperties.getProperty(name)));
            }
        }
        return cloning;
    }

    public void setName(String name) {
        this.displayName = name;
    }

    public String getName() {
        return this.ejbName != null ? this.ejbName : this.displayName;
    }

    public void saveToFile(String name) {
    }

    public Document getAsDocument() {
        return null;
    }

    public void loadFromDocument(Document d, String s) {
    }

    public void loadFromFile(String s1, String s) {
    }

    public IORDescriptor[] getIORDescriptors() {
        return this.iorDescriptors;
    }

    public void setIORDescriptors(IORDescriptor[] iorDescriptors) {
        this.iorDescriptors = iorDescriptors;
    }

    public void setTransactionDescriptor(ControlDescriptor descr) {
        if (this.transactionDescriptors == null || this.transactionDescriptors.length == 0) {
            this.transactionDescriptors = new ControlDescriptor[]{descr};
        } else {
            MethodEntry descrEntry = descr.getMethodEntry();
            int i = 0;
            while (i < this.transactionDescriptors.length) {
                if (descrEntry.simpleEquals(this.transactionDescriptors[i].getMethodEntry())) {
                    this.transactionDescriptors[i].setIsolationLevel(descr.getIsolationLevelString());
                    this.transactionDescriptors[i].setDescription(descr.getDescription());
                    this.transactionDescriptors[i].setTransactionAttribute(descr.getTransactionAttribute());
                    return;
                }
                ++i;
            }
            ControlDescriptor[] result = new ControlDescriptor[this.transactionDescriptors.length + 1];
            System.arraycopy(this.transactionDescriptors, 0, result, 0, this.transactionDescriptors.length);
            result[this.transactionDescriptors.length] = descr;
            this.transactionDescriptors = result;
        }
    }
}

