/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.descriptors;

import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.frame.core.load.res.JarsResource;
import com.sap.engine.services.deploy.ear.common.CloneUtils;
import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import java.io.File;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.HashSet;

public class ApplicationDescriptor
implements Serializable {
    private String applicationName = null;
    private EJBJarDescriptor[] ejbJars = null;
    private HashSet othersJarNames = new HashSet();
    public boolean isLoaded = false;
    private transient ClassLoader ejbLoader = null;
    private transient ClassLoader appLoader = null;

    public ApplicationDescriptor(String name) {
        this.applicationName = name;
    }

    public Object clone() {
        ApplicationDescriptor descr = new ApplicationDescriptor(this.applicationName);
        descr.isLoaded = this.isLoaded;
        descr.appLoader = this.appLoader;
        descr.ejbLoader = this.ejbLoader;
        if (this.ejbJars != null) {
            EJBJarDescriptor[] jarDescriptors = new EJBJarDescriptor[this.ejbJars.length];
            int i = 0;
            while (i < jarDescriptors.length) {
                jarDescriptors[i] = this.ejbJars[i] != null ? (EJBJarDescriptor)this.ejbJars[i].clone() : null;
                ++i;
            }
            descr.setEJBJarDescriptors(jarDescriptors);
        }
        descr.setOthersJarNames(CloneUtils.cloneStringHashSet(this.othersJarNames));
        return descr;
    }

    public boolean equals(Object obj) {
        ApplicationDescriptor descr = null;
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationDescriptor)) {
            return false;
        }
        descr = (ApplicationDescriptor)obj;
        if (!EqualUtils.equalObjects(this.applicationName, descr.getName())) {
            return false;
        }
        if (this.isLoaded != descr.isLoaded) {
            return false;
        }
        if (!EqualUtils.equalUnOrderedArrays(this.ejbJars, descr.getEJBJarDescriptors())) {
            return false;
        }
        return EqualUtils.equalHashSets(this.othersJarNames, descr.getOthersJarNames());
    }

    public HashSet getOthersJarNames() {
        return this.othersJarNames;
    }

    public void setOthersJarNames(HashSet jarNames) {
        this.othersJarNames = jarNames;
    }

    public String getName() {
        return this.applicationName;
    }

    public EJBJarDescriptor[] getEJBJarDescriptors() {
        return this.ejbJars;
    }

    public void setEJBJarDescriptors(EJBJarDescriptor[] ejb_jars) {
        this.ejbJars = ejb_jars;
        int i = 0;
        while (i < this.ejbJars.length) {
            String oldDisplayName = this.ejbJars[i].getDisplayName();
            this.ejbJars[i].setDisplayName(this.applicationName + "_" + oldDisplayName + i);
            ++i;
        }
    }

    public void setEjbLoader(ClassLoader loader) {
        this.ejbLoader = loader;
    }

    public ClassLoader getEjbLoader() {
        return this.ejbLoader;
    }

    public void setAppLoader(ClassLoader loader) {
        this.appLoader = loader;
    }

    public ClassLoader getAppLoader() {
        return this.appLoader;
    }

    public void addOthersJars(String[] jarNames) {
        int j = 0;
        while (j < jarNames.length) {
            this.othersJarNames.add(jarNames[j]);
            ++j;
        }
        if (this.appLoader != null) {
            JarsResource jars = new JarsResource(jarNames);
            ((ResourceLoader)this.appLoader).addResource(jars);
        }
    }

    public String[] getOthersJars() {
        return ((AbstractCollection)this.othersJarNames).toArray(new String[this.othersJarNames.size()]);
    }

    public File[] getOthersJarFiles() {
        String[] jarNames = this.getOthersJars();
        File[] result = new File[jarNames.length];
        int i = 0;
        while (i < result.length) {
            result[i] = new File(jarNames[i]);
            ++i;
        }
        return result;
    }
}

