/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.admintool;

import com.sap.engine.lib.lang.MultiFileLoader;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.admintool.RMappingTool;
import com.sap.engine.services.ejb.deploy.admintool.RMappingTool11;
import com.sap.engine.services.ejb.deploy.admintool.XMLPersistentGenerator;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.xml.EJBJarParser;
import com.sap.engine.services.ejb.exceptions.BaseIOException;
import com.sap.engine.services.ejb.exceptions.ExceptionWrapperException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDeploymentException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBFileOperationException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLParserException;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class PersistentXMLBuilder {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$deploy$admintool$PersistentXMLBuilder == null ? (class$com$sap$engine$services$ejb$deploy$admintool$PersistentXMLBuilder = PersistentXMLBuilder.class$("com.sap.engine.services.ejb.deploy.admintool.PersistentXMLBuilder")) : class$com$sap$engine$services$ejb$deploy$admintool$PersistentXMLBuilder));
    private String metaInf = "META-INF";
    static /* synthetic */ Class class$com$sap$engine$services$ejb$deploy$admintool$PersistentXMLBuilder;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String createPersistentXML(File earFile, String[] jars, String tempDirName, String dbVendor, String dsName) throws DeploymentException {
        String ejbJarsWithPersistentXml = "";
        ZipFile zipFile = null;
        try {
            try {
                zipFile = new ZipFile(earFile);
                String tempPersistentDir = tempDirName + File.separator + "tempPersistent" + File.separator;
                this.extractZip(zipFile, tempPersistentDir);
                ZipEntry appXML = zipFile.getEntry("meta-inf/application.xml");
                if (appXML == null) {
                    appXML = zipFile.getEntry("META-INF/application.xml");
                }
                if (appXML == null) {
                    throw new EJBFileOperationException("ejb_2401", new String[]{earFile.getName()});
                }
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                Vector<File> vFiles = new Vector<File>();
                String jarName = null;
                while (entries.hasMoreElements()) {
                    jarName = entries.nextElement().getName();
                    vFiles.addElement(new File(tempPersistentDir, jarName));
                }
                if (jars != null) {
                    int i = 0;
                    while (i < jars.length) {
                        vFiles.addElement(new File(jars[i]));
                        ++i;
                    }
                }
                File[] files = vFiles.toArray(new File[vFiles.size()]);
                MultiFileLoader loader = new MultiFileLoader(files, this.getClass().getClassLoader());
                XMLPersistentGenerator generator = new XMLPersistentGenerator();
                ClassLoader cl = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                Document document = new StandardDOMParser().parse((InputStream)new BufferedInputStream(zipFile.getInputStream(appXML)));
                Thread.currentThread().setContextClassLoader(cl);
                Element root = document.getDocumentElement();
                String appName = this.getElementText((Element)root.getElementsByTagName("display-name").item(0));
                NodeList moduleList = root.getElementsByTagName("module");
                int i = 0;
                while (i < moduleList.getLength()) {
                    NodeList ejbList = ((Element)moduleList.item(i)).getElementsByTagName("ejb");
                    if (ejbList.getLength() != 0) {
                        jarName = this.getElementText((Element)ejbList.item(0));
                        if (!jarName.endsWith(".jar")) {
                            throw new EJBDeploymentException("ejb_2185", new String[]{jarName});
                        }
                        File ejbFile = new File(tempPersistentDir, jarName);
                        String persistentDirName = tempPersistentDir + jarName.substring(0, jarName.lastIndexOf(".")) + File.separator;
                        EJBJarDescriptor ejbDscr = this.getEjbDescr(ejbFile, persistentDirName, loader, appName, dbVendor, dsName);
                        if (ejbDscr == null) {
                            ejbJarsWithPersistentXml = ejbJarsWithPersistentXml + jarName + "  ";
                        } else if (!ejbDscr.getAbstractSchema().isEmpty()) {
                            new File(persistentDirName + this.metaInf + File.separator).mkdirs();
                            generator.generateXml(ejbDscr, persistentDirName + this.metaInf + File.separator + "persistent.xml");
                        }
                        this.makeJar(new File(persistentDirName), new File(tempPersistentDir, jarName));
                        this.cascadeDelete(new File(persistentDirName));
                    }
                    ++i;
                }
                File tempDir = new File(tempPersistentDir);
                this.makeJar(tempDir, earFile);
                this.cascadeDelete(new File(tempPersistentDir));
                String string = ejbJarsWithPersistentXml;
                Object var27_29 = null;
                if (zipFile == null) return string;
                try {
                    zipFile.close();
                    return string;
                }
                catch (IOException ioe) {
                    ExceptionWrapperException toThrow = new ExceptionWrapperException(400, ioe, "ejb_9050");
                    LOCATION.traceThrowableT(300, "", (Throwable)toThrow);
                }
                return string;
            }
            catch (SAXException e) {
                throw new EJBXMLParserException("ejb_2300", new String[]{"application.xml"}, e);
            }
            catch (IOException ioe) {
                throw new EJBFileOperationException("ejb_2402", new String[]{"application.xml"}, ioe);
            }
        }
        catch (Throwable throwable) {
            Object var27_30 = null;
            if (zipFile == null) throw throwable;
            try {}
            catch (IOException ioe) {
                ExceptionWrapperException toThrow = new ExceptionWrapperException(400, ioe, "ejb_9050");
                LOCATION.traceThrowableT(300, "", (Throwable)toThrow);
                throw throwable;
            }
            zipFile.close();
            throw throwable;
        }
    }

    private String getElementText(Element el) {
        NodeList nodeList = el.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                StandardDOMParser.trimWhiteSpaces((Node)node);
                if (!Symbols.isWhitespace((String)((Text)node).getData())) {
                    return ((Text)node).getData();
                }
            }
            ++i;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private EJBJarDescriptor getEjbDescr(File ejbFile, String persistentDirName, ClassLoader loader, String appName, String dbVendor, String dsName) throws IOException, DeploymentException {
        Object rTool;
        ZipFile ejbJar;
        block17: {
            EJBJarDescriptor eJBJarDescriptor;
            block16: {
                EJBJarDescriptor eJBJarDescriptor2;
                block15: {
                    EJBJarDescriptor eJBJarDescriptor3;
                    block14: {
                        ejbJar = null;
                        try {
                            ejbJar = new ZipFile(ejbFile);
                            this.extractZip(ejbJar, persistentDirName);
                            File ejbXml = new File(persistentDirName + "meta-inf/ejb-jar.xml");
                            if (!ejbXml.exists()) {
                                ejbXml = new File(persistentDirName + "META-INF/ejb-jar.xml");
                            }
                            if (!ejbXml.exists()) {
                                throw new BaseIOException("ejb_9033", new String[]{"ejb-jar.xml"});
                            }
                            EJBJarParser ejbParser = new EJBJarParser();
                            Vector warnings = new Vector();
                            EJBJarDescriptor ejbDscr = ejbParser.parseXml(new BufferedInputStream(new FileInputStream(ejbXml)), warnings, loader, appName, ejbJar.getName(), false, null, false, null);
                            ejbDscr.setJarName(ejbFile.getName());
                            if (ejbDscr.getAbstractSchema().isEmpty()) {
                                eJBJarDescriptor3 = ejbDscr;
                                Object var16_14 = null;
                                if (ejbJar == null) return eJBJarDescriptor3;
                                break block14;
                            }
                            File persistentXml = new File(persistentDirName + "meta-inf/persistent.xml");
                            if (persistentXml.exists()) {
                                eJBJarDescriptor2 = null;
                                break block15;
                            }
                            persistentXml = new File(persistentDirName + "META-INF/persistent.xml");
                            if (persistentXml.exists()) {
                                eJBJarDescriptor = null;
                                break block16;
                            }
                            persistentXml = null;
                            this.metaInf = "META-INF";
                            File storageXml = null;
                            if (persistentXml == null && !(storageXml = new File(persistentDirName + "meta-inf/storage.xml")).exists() && !(storageXml = new File(persistentDirName + "META-INF/storage.xml")).exists()) {
                                storageXml = null;
                            }
                            try {
                                if (storageXml != null) {
                                    RMappingTool11 rTool11 = new RMappingTool11();
                                    rTool11.setEJBJarDscr(ejbDscr);
                                    rTool11.readXML(new BufferedInputStream(new FileInputStream(storageXml)), dbVendor, dsName);
                                    if (storageXml.exists()) {
                                        storageXml.delete();
                                    }
                                } else {
                                    if (dsName == null) {
                                        throw new EJBDeploymentException("ejb_2187");
                                    }
                                    rTool = new RMappingTool(ejbDscr.getAbstractSchema(), dsName, dbVendor);
                                    ((RMappingTool)rTool).createSchemaMapping();
                                }
                                rTool = ejbDscr;
                                break block17;
                            }
                            catch (SAXException e) {
                                throw new EJBXMLParserException("ejb_2300", new String[]{"storage.xml"}, e);
                            }
                        }
                        catch (Throwable throwable) {
                            Object var16_18 = null;
                            if (ejbJar == null) throw throwable;
                            ejbJar.close();
                            throw throwable;
                        }
                    }
                    ejbJar.close();
                    return eJBJarDescriptor3;
                }
                Object var16_15 = null;
                if (ejbJar == null) return eJBJarDescriptor2;
                ejbJar.close();
                return eJBJarDescriptor2;
            }
            Object var16_16 = null;
            if (ejbJar == null) return eJBJarDescriptor;
            ejbJar.close();
            return eJBJarDescriptor;
        }
        Object var16_17 = null;
        if (ejbJar == null) return rTool;
        ejbJar.close();
        return rTool;
    }

    private void cascadeDelete(File f) {
        if (!f.isDirectory()) {
            f.delete();
            return;
        }
        File[] fileList = f.listFiles();
        int i = 0;
        while (i < fileList.length) {
            this.cascadeDelete(fileList[i]);
            ++i;
        }
        f.delete();
    }

    private void makeJar(File dir, File jarFile) throws IOException {
        ZipOutputStream jarOutStream = new ZipOutputStream(new FileOutputStream(jarFile));
        try {
            File[] files = dir.listFiles();
            int i = 0;
            while (i < files.length) {
                Vector entries = this.listNames(files[i]);
                int j = 0;
                while (j < entries.size()) {
                    String entryName = (String)entries.elementAt(j);
                    jarOutStream.putNextEntry(new ZipEntry(entryName));
                    FileInputStream fis = new FileInputStream(new File(dir, entryName));
                    BufferedInputStream bin = new BufferedInputStream(fis);
                    byte[] buff = new byte[100];
                    int index = 0;
                    while ((index = bin.read(buff)) == buff.length) {
                        jarOutStream.write(buff, 0, index);
                    }
                    if (index > 0) {
                        jarOutStream.write(buff, 0, index);
                    }
                    ((FilterOutputStream)jarOutStream).flush();
                    bin.close();
                    fis.close();
                    jarOutStream.closeEntry();
                    ++j;
                }
                ++i;
            }
            Object var14_13 = null;
        }
        catch (Throwable throwable) {
            Object var14_14 = null;
            jarOutStream.close();
            throw throwable;
        }
        jarOutStream.close();
    }

    private Vector listNames(File dir) throws IOException {
        Vector<String> result = new Vector<String>();
        String fileName = dir.getName();
        if (!dir.isDirectory()) {
            result.addElement(fileName);
            return result;
        }
        File[] fileList = dir.listFiles();
        int i = 0;
        while (i < fileList.length) {
            if (fileList[i].isDirectory()) {
                Vector newFileNames = this.listNames(fileList[i]);
                int j = 0;
                while (j < newFileNames.size()) {
                    result.addElement(fileName + "/" + (String)newFileNames.elementAt(j));
                    ++j;
                }
            } else {
                result.addElement(fileName + "/" + fileList[i].getName());
            }
            ++i;
        }
        return result;
    }

    private void extractZip(ZipFile zipFile, String dirName) throws IOException {
        new File(dirName).mkdirs();
        Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            String entryName = entry.getName().replace('/', File.separatorChar);
            int index = 0;
            index = entryName.lastIndexOf(File.separatorChar);
            if (index != -1) {
                new File(dirName, entryName.substring(0, index)).mkdirs();
            }
            if (entry.isDirectory()) continue;
            File destFile = new File(dirName, entryName);
            FileOutputStream out = new FileOutputStream(destFile);
            InputStream in = zipFile.getInputStream(entry);
            BufferedInputStream bin = new BufferedInputStream(in);
            try {
                byte[] buff = new byte[100];
                while ((index = bin.read(buff)) == buff.length) {
                    out.write(buff, 0, index);
                }
                if (index > 0) {
                    out.write(buff, 0, index);
                }
                out.flush();
            }
            catch (EOFException ex) {
                throw new BaseIOException("ejb_9035");
            }
            in.close();
            bin.close();
            out.close();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

