/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.admintool;

import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.SecurityRole;
import com.sap.engine.interfaces.security.SecurityRoleContext;
import com.sap.engine.lib.xml.StandardDOMWriter;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.IORDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLGeneratorException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class InqmyEjbGenerator {
    public static final String UTF8 = "UTF-8";
    public static final String dtd = "<!DOCTYPE ejb-j2ee-engine SYSTEM 'ejb-j2ee-engine.dtd'>";
    private Environment environment = null;
    private DocumentBuilderFactory factory = null;
    private DocumentBuilder builder = null;
    private Document mainDocument = null;
    private Element inqmyEjb = null;
    private DeploymentDescriptor[] descriptors = null;

    public InqmyEjbGenerator(Environment _environment) throws DeploymentException {
        this.environment = _environment;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        this.factory = DocumentBuilderFactory.newInstance();
        Thread.currentThread().setContextClassLoader(cl);
        try {
            this.builder = this.factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new EJBXMLGeneratorException("ejb_2321", (Throwable)pce);
        }
    }

    private void newDocument() throws DeploymentException {
        this.mainDocument = this.builder.newDocument();
        this.inqmyEjb = this.mainDocument.createElement("ejb-j2ee-engine");
    }

    public void generateXML(String applicationName, EJBJarDescriptor ejbJarDescr, String xmlFileName) throws DeploymentException {
        this.generateXML(applicationName, ejbJarDescr);
        this.writeXML(xmlFileName);
    }

    public Document generateXML(String applicationName, EJBJarDescriptor ejbJarDescr) throws DeploymentException {
        this.newDocument();
        this.descriptors = ejbJarDescr.getDDescriptors();
        if (this.descriptors != null && this.descriptors.length != 0) {
            String inqmyDescription = ejbJarDescr.getInqmyDescription();
            if (inqmyDescription != null && !inqmyDescription.trim().equals("")) {
                this.load(this.inqmyEjb, inqmyDescription, "description");
            }
            this.createEnterpriseBeans();
            this.createTransactionDescriptors();
            String policyConfigName = applicationName + "*" + ejbJarDescr.getJarName();
            SecurityContext jarSecCtx = this.environment.getSecurityContext().getPolicyConfigurationContext(policyConfigName);
            if (jarSecCtx == null) {
                throw new EJBXMLGeneratorException("ejb_2403", new Object[]{policyConfigName});
            }
            SecurityRoleContext secRoleCtx = jarSecCtx.getAuthorizationContext().getSecurityRoleContext();
            SecurityRole[] secRoles = secRoleCtx.listSecurityRoles();
            if (secRoles != null && secRoles.length != 0) {
                this.createSecurityPermissions(secRoles);
            }
        }
        return this.mainDocument;
    }

    private void writeXML(String xmlFileName) throws DeploymentException {
        this.mainDocument.appendChild(this.inqmyEjb);
        try {
            new StandardDOMWriter().write(this.mainDocument, xmlFileName, dtd, UTF8);
        }
        catch (IOException ioe) {
            throw new EJBXMLGeneratorException("ejb_2313", (Throwable)ioe);
        }
    }

    private boolean load(Element el, String value, String tagName) {
        if (value == null || value.trim().equals("")) {
            return false;
        }
        Element nextElement = this.mainDocument.createElement(tagName);
        Text textNode = this.mainDocument.createTextNode(value);
        nextElement.appendChild(textNode);
        el.appendChild(nextElement);
        return true;
    }

    private void createEnterpriseBeans() {
        Element ejbs = this.mainDocument.createElement("enterprise-beans");
        Element ejb = null;
        boolean add = false;
        DeploymentDescriptor dd = null;
        int i = 0;
        while (i < this.descriptors.length) {
            dd = this.descriptors[i];
            if (dd != null && this.load(ejb = this.mainDocument.createElement("enterprise-bean"), dd.getEjbName(), "ejb-name")) {
                if (dd.getJndiNameUpdated() != null) {
                    this.load(ejb, dd.getJndiNameUpdated(), "jndi-name");
                } else {
                    this.load(ejb, dd.getJndiName(), "jndi-name");
                }
                Properties bProps = dd.getBeanProperties();
                this.load(ejb, new Integer(dd.getContainerSize()).toString(), "container-size");
                this.createEjbRefs(ejb, dd.getEJBeanReferences());
                this.createEjbLocalRefs(ejb, dd.getEJBeanLocalReferences());
                this.createResourceRefs(ejb, dd.getResourceReferences());
                this.createResourceEnvRefs(ejb, dd.getResourceEnvReferences());
                this.createServerComponentRefs(ejb, dd.getServerComponentReferences());
                SecurityIdentity identity = dd.getSecurityIdentity();
                if (identity != null && !identity.isCallerIdentity()) {
                    this.createRunAsIdentityMap(ejb, identity.getRunAsIdentity());
                }
                this.createIORSecurity(ejb, dd.getIORDescriptors());
                if (dd instanceof SessionDescriptor) {
                    this.createSessionProps(ejb, (SessionDescriptor)dd, bProps);
                }
                if (dd instanceof EntityDescriptor) {
                    this.createEntityProps(ejb, (EntityDescriptor)dd, bProps);
                }
                if (dd instanceof MessageDrivenDescriptor) {
                    this.createMessageDrivenProps(ejb, bProps);
                }
                ejbs.appendChild(ejb);
                add = true;
            }
            ++i;
        }
        if (add) {
            this.inqmyEjb.appendChild(ejbs);
        }
    }

    private void createIORSecurity(Element el, IORDescriptor[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        Element iorConfig = null;
        Element transportConfig = null;
        Element asContext = null;
        Element sasContext = null;
        IORDescriptor ior = null;
        int i = 0;
        while (i < size) {
            ior = value[i];
            iorConfig = this.mainDocument.createElement("ior-security-config");
            transportConfig = this.mainDocument.createElement("transport-config");
            asContext = this.mainDocument.createElement("as-context");
            sasContext = this.mainDocument.createElement("sas-context");
            this.load(transportConfig, ior.getIntegrity(), "integrity");
            this.load(transportConfig, ior.getConfidentiality(), "confidentiality");
            this.load(transportConfig, ior.getEstablishTrustInTarget(), "establish-trust-in-target");
            this.load(transportConfig, ior.getEstablishTrustInClient(), "establish-trust-in-client");
            iorConfig.appendChild(transportConfig);
            this.load(asContext, ior.getAuthenticationMethod(), "auth-method");
            this.load(asContext, ior.getRealmName(), "realm");
            if (ior.isAuthMethodRequired()) {
                this.load(asContext, "true", "required");
            } else {
                this.load(asContext, "false", "required");
            }
            iorConfig.appendChild(asContext);
            this.load(sasContext, ior.getCallerPropagation(), "caller-propagation");
            iorConfig.appendChild(sasContext);
            el.appendChild(iorConfig);
            ++i;
        }
    }

    private void createSessionProps(Element el, SessionDescriptor sessD, Properties bProp) {
        boolean hasProps = false;
        Element session = this.mainDocument.createElement("session-props");
        if (sessD.getSessionTimeout() != 0) {
            hasProps = true;
            this.load(session, String.valueOf(sessD.getSessionTimeout()), "session-timeout");
        }
        if (sessD.usePassivation()) {
            hasProps = true;
            Element passivation = this.mainDocument.createElement("passivation");
            this.load(passivation, String.valueOf(sessD.getStatefulTimeout()), "passive-timeout");
            this.load(passivation, String.valueOf(sessD.getStatefulTimeout()), "lrulimit");
            session.appendChild(passivation);
        } else if (sessD.keepsOpenResources()) {
            hasProps = true;
            Element keepsOpenRes = this.mainDocument.createElement("keeps-open-resources");
            session.appendChild(keepsOpenRes);
        }
        if (bProp != null) {
            hasProps = true;
            this.createProperties(session, bProp);
        }
        if (hasProps) {
            el.appendChild(session);
        }
    }

    private void createEntityProps(Element el, EntityDescriptor entD, Properties bProp) {
        boolean hasProps = false;
        Element entity = this.mainDocument.createElement("entity-props");
        if (entD instanceof CMPEntityDescriptor) {
            this.load(entity, String.valueOf(((CMPEntityDescriptor)entD).getUnknownPKInterval()), "unknown-pk-interval");
            this.load(entity, String.valueOf(((CMPEntityDescriptor)entD).getCacheSize()), "initial-cache-size");
        }
        if (bProp != null) {
            hasProps = true;
            this.createProperties(entity, bProp);
        }
        if (hasProps) {
            el.appendChild(entity);
        }
    }

    private void createMessageDrivenProps(Element el, Properties bProp) {
        boolean hasProps = false;
        Element message = this.mainDocument.createElement("message-props");
        if (bProp != null) {
            hasProps = true;
            String destinationName = bProp.getProperty("DestinationName");
            this.load(message, destinationName, "destination-name");
            String connectionFactoryName = bProp.getProperty("ConnectionFactoryName");
            this.load(message, connectionFactoryName, "connection-factory-name");
            if (((Hashtable)bProp).size() > 2) {
                this.createProperties(message, bProp);
            }
        }
        if (hasProps) {
            el.appendChild(message);
        }
    }

    private void createProperties(Element el, Properties props) {
        Enumeration keys = ((Hashtable)props).keys();
        String name = null;
        String value = null;
        Element property = null;
        while (keys.hasMoreElements()) {
            name = (String)keys.nextElement();
            if (name.equals("DestinationName") || name.equals("ConnectionFactoryName")) continue;
            value = props.getProperty(name);
            property = this.mainDocument.createElement("property");
            this.load(property, name, "property-name");
            this.load(property, value, "property-value");
            el.appendChild(property);
        }
    }

    private void createEjbRefs(Element el, EJBeanReference[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        Element ref = null;
        EJBeanReference temp = null;
        int i = 0;
        while (i < size) {
            temp = value[i];
            String jndiName = temp.getReferenceJndiLink();
            if (jndiName != null) {
                ref = this.mainDocument.createElement("ejb-ref");
                this.load(ref, temp.getReferenceName(), "ejb-ref-name");
                this.load(ref, jndiName, "jndi-name");
                el.appendChild(ref);
            }
            ++i;
        }
    }

    private void createEjbLocalRefs(Element el, EJBeanLocalReference[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        Element ref = null;
        EJBeanLocalReference temp = null;
        int i = 0;
        while (i < size) {
            temp = value[i];
            String jndiName = temp.getReferenceJndiLink();
            if (jndiName != null) {
                ref = this.mainDocument.createElement("ejb-local-ref");
                this.load(ref, temp.getReferenceName(), "ejb-ref-name");
                this.load(ref, jndiName, "jndi-name");
                el.appendChild(ref);
            }
            ++i;
        }
    }

    private void createResourceRefs(Element el, ResourceReference[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        Element resRef = null;
        ResourceReference tempRef = null;
        int i = 0;
        while (i < size) {
            tempRef = value[i];
            String jndiName = tempRef.getResourceLink();
            if (jndiName != null || !tempRef.isTransactional()) {
                resRef = this.mainDocument.createElement("resource-ref");
                this.load(resRef, tempRef.getResourceName(), "res-ref-name");
                if (jndiName != null) {
                    this.load(resRef, jndiName, "res-link");
                }
                if (!tempRef.isTransactional()) {
                    Element nonTxSupport = this.mainDocument.createElement("non-transactional");
                    resRef.appendChild(nonTxSupport);
                }
                el.appendChild(resRef);
            }
            ++i;
        }
    }

    private void createResourceEnvRefs(Element el, ResourceEnvReference[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        Element ref = null;
        ResourceEnvReference temp = null;
        int i = 0;
        while (i < size) {
            temp = value[i];
            String jndiName = temp.getJndiName();
            if (jndiName != null) {
                ref = this.mainDocument.createElement("resource-env-ref");
                this.load(ref, temp.getName(), "resource-env-ref-name");
                this.load(ref, jndiName, "jndi-name");
                el.appendChild(ref);
            }
            ++i;
        }
    }

    private void createServerComponentRefs(Element el, ComponentReference[] value) {
        int size = -1;
        if (value == null || (size = value.length) == 0) {
            return;
        }
        Element ref = null;
        ComponentReference temp = null;
        int i = 0;
        while (i < size) {
            temp = value[i];
            ref = this.mainDocument.createElement("server-component-ref");
            this.load(ref, temp.getName(), "name");
            this.load(ref, temp.getType() == 1 ? "Interface" : "Service", "type");
            this.load(ref, temp.getJndiName(), "jndi-name");
            this.load(ref, temp.getDescription(), "description");
            el.appendChild(ref);
            ++i;
        }
    }

    private void createRunAsIdentityMap(Element el, RunAsIdentity value) {
        if (value == null) {
            return;
        }
        String userName = value.getUserName();
        if (userName != null && !userName.equals("")) {
            Element runAs = this.mainDocument.createElement("run-as-identity-map");
            this.load(runAs, userName, "user-name");
            runAs.appendChild(runAs);
            el.appendChild(runAs);
        }
    }

    private void createTransactionDescriptors() {
        int size = -1;
        Element transaction = this.mainDocument.createElement("transaction-descriptor");
        ControlDescriptor[] controls = null;
        Vector committed = new Vector();
        Vector uncommitted = new Vector();
        Vector repeatable = new Vector();
        Vector serializable = new Vector();
        int i = 0;
        while (i < this.descriptors.length) {
            controls = this.descriptors[i].getTransactionDescriptors();
            if (controls != null && (size = controls.length) != 0) {
                int j = 0;
                while (j < size) {
                    this.addMethodToIsolationList(controls[j], committed, uncommitted, repeatable, serializable);
                    ++j;
                }
            }
            ++i;
        }
        if (this.addIsolationLevels(transaction, committed, uncommitted, repeatable, serializable)) {
            this.inqmyEjb.appendChild(transaction);
        }
    }

    private void addMethodToIsolationList(ControlDescriptor control, Vector committed, Vector uncommitted, Vector repeatable, Vector serializable) {
        int level = control.getIsolationLevel();
        if (level == 2) {
            committed.add(control.getMethodEntry());
        } else if (level == 1) {
            uncommitted.add(control.getMethodEntry());
        } else if (level == 4) {
            repeatable.add(control.getMethodEntry());
        } else if (level == 8) {
            serializable.add(control.getMethodEntry());
        }
    }

    private boolean addIsolationLevels(Element transaction, Vector committed, Vector uncommitted, Vector repeatable, Vector serializable) {
        boolean add = false;
        if (this.makeList(transaction, committed, "Committed")) {
            add = true;
        }
        if (this.makeList(transaction, uncommitted, "Uncommitted")) {
            add = true;
        }
        if (this.makeList(transaction, repeatable, "Repeatable")) {
            add = true;
        }
        if (this.makeList(transaction, serializable, "Serializable")) {
            add = true;
        }
        return add;
    }

    private boolean makeList(Element trans, Vector methods, String type) {
        int size = -1;
        size = methods.size();
        if (size == 0) {
            return false;
        }
        Element level = this.mainDocument.createElement("isolation-level");
        this.load(level, type, "isolation-attribute");
        MethodEntry entry = null;
        Element method = null;
        String[] params = null;
        int sizeParams = -1;
        Element methodParams = null;
        int i = 0;
        while (i < size) {
            entry = (MethodEntry)methods.get(i);
            method = this.mainDocument.createElement("method");
            this.load(method, entry.getEjbName(), "ejb-name");
            this.load(method, entry.getMethodInterface(), "method-intf");
            this.load(method, entry.getMethodName(), "method-name");
            params = entry.getParameters();
            if (params != null && (sizeParams = params.length) != 0) {
                methodParams = this.mainDocument.createElement("method-params");
                int j = 0;
                while (j < sizeParams) {
                    this.load(methodParams, params[j], "method-param");
                    ++j;
                }
                method.appendChild(methodParams);
            }
            ++i;
        }
        trans.appendChild(level);
        return true;
    }

    private void createSecurityPermissions(SecurityRole[] secRoles) {
        boolean add = false;
        Element secPerm = this.mainDocument.createElement("security-permission");
        int i = 0;
        while (i < secRoles.length) {
            String name = secRoles[i].getName();
            String[] refRole = secRoles[i].getReference();
            if (refRole != null && refRole.length > 0) {
                Element map = this.mainDocument.createElement("security-role-map");
                secPerm.appendChild(map);
                this.load(map, name, "role-name");
                this.load(map, refRole[1], "server-role-name");
                add = true;
            } else {
                String[] groups;
                String[] users = secRoles[i].getUsers();
                if (this.createSecurityRoleMap(secPerm, name, users, groups = secRoles[i].getGroups())) {
                    add = true;
                }
            }
            ++i;
        }
        if (add) {
            this.inqmyEjb.appendChild(secPerm);
        }
    }

    private boolean createSecurityRoleMap(Element secPerm, String name, String[] users, String[] groups) {
        int i;
        boolean res = false;
        Element map = this.mainDocument.createElement("security-role-map");
        this.load(map, name, "role-name");
        if (users != null) {
            i = 0;
            while (i < users.length) {
                this.load(map, users[i], "user-name");
                res = true;
                ++i;
            }
        }
        if (groups != null) {
            i = 0;
            while (i < groups.length) {
                this.load(map, groups[i], "group-name");
                res = true;
                ++i;
            }
        }
        if (res) {
            secPerm.appendChild(map);
        }
        return res;
    }
}

