/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.admintool;

import com.sap.engine.lib.lang.MultiFileLoader;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.lib.xml.Symbols;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.tools.sql.StatementGeneratorsHolder;
import com.sap.engine.services.ejb.deploy.xml.EJBJarParser;
import com.sap.engine.services.ejb.deploy.xml.PersistentParser;
import com.sap.engine.services.ejb.exceptions.BaseIOException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBFileOperationException;
import java.io.BufferedInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class CreateStatementsBuilder {
    private Environment ejbEnv = null;
    private File earFile = null;
    private MultiFileLoader loader = null;
    private EJBJarParser ejbParser = null;
    private PersistentParser parser = null;
    private String[] jars = null;
    private String appName = null;

    public CreateStatementsBuilder(File _earFile, String[] _jars, Environment _ejbEnv) throws IOException {
        this.earFile = _earFile;
        this.jars = _jars;
        this.ejbEnv = _ejbEnv;
    }

    public String[][] getCreateStatements(String tempDirName, Properties dbProps) throws IOException, DeploymentException {
        AbstractSchema[] schema = this.readApplication(tempDirName);
        String[][] result = new String[schema.length][];
        int i = 0;
        while (i < schema.length) {
            if (!schema[i].isEmpty()) {
                StatementGeneratorsHolder holder = new StatementGeneratorsHolder(schema[i]);
                String[] createSt = holder.getCreateTableSt(dbProps);
                result[i] = new String[createSt.length + 1];
                result[i][0] = schema[i].getDBProperties().getDataSourceName();
                System.arraycopy(createSt, 0, result[i], 1, createSt.length);
            }
            ++i;
        }
        return result;
    }

    public String[][] getDropStatements(String tempDirName) throws IOException, DeploymentException {
        AbstractSchema[] schema = this.readApplication(tempDirName);
        String[][] result = new String[schema.length][];
        int i = 0;
        while (i < schema.length) {
            if (!schema[i].isEmpty()) {
                StatementGeneratorsHolder holder = new StatementGeneratorsHolder(schema[i]);
                String[] dropSt = holder.getDropTableSt();
                result[i] = new String[dropSt.length + 1];
                result[i][0] = schema[i].getDBProperties().getDataSourceName();
                System.arraycopy(dropSt, 0, result[i], 1, dropSt.length);
            }
            ++i;
        }
        return result;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private AbstractSchema[] readApplication(String tempDirName) throws IOException, DeploymentException {
        AbstractSchema[] abstractSchemaArray;
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.earFile);
            this.extractZip(zipFile, tempDirName);
            ZipEntry appXML = zipFile.getEntry("meta-inf/application.xml");
            if (appXML == null) {
                appXML = zipFile.getEntry("META-INF/application.xml");
            }
            if (appXML == null) {
                throw new BaseIOException("ejb_9033", new String[]{"application.xml"});
            }
            Document document = null;
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            try {
                document = new StandardDOMParser().parse((InputStream)new BufferedInputStream(zipFile.getInputStream(appXML)));
            }
            catch (SAXException e) {
                throw new BaseIOException("ejb_9034", new String[]{"application.xml"}, e);
            }
            Thread.currentThread().setContextClassLoader(cl);
            Element root = document.getDocumentElement();
            this.appName = this.getElementText((Element)root.getElementsByTagName("display-name").item(0));
            NodeList moduleList = root.getElementsByTagName("module");
            Vector<File> vLoaderFiles = new Vector<File>();
            Vector<File> vEjbFiles = new Vector<File>();
            int i = 0;
            while (i < moduleList.getLength()) {
                NodeList ejbList = ((Element)moduleList.item(i)).getElementsByTagName("ejb");
                if (ejbList.getLength() > 0) {
                    Element ejb = (Element)ejbList.item(0);
                    String ejbJarName = this.getElementText(ejb);
                    vEjbFiles.addElement(new File(tempDirName, ejbJarName));
                }
                ++i;
            }
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String jarName = entries.nextElement().getName();
                vLoaderFiles.addElement(new File(tempDirName, jarName));
            }
            if (this.jars != null) {
                int i2 = 0;
                while (i2 < this.jars.length) {
                    vLoaderFiles.addElement(new File(this.jars[i2]));
                    ++i2;
                }
            }
            this.addFilesFromLibrary("ejb20", vLoaderFiles);
            this.addFilesFromLibrary("jms", vLoaderFiles);
            this.addFilesFromLibrary("mail", vLoaderFiles);
            File[] files = vLoaderFiles.toArray(new File[vLoaderFiles.size()]);
            this.loader = new MultiFileLoader(files);
            this.ejbParser = new EJBJarParser();
            AbstractSchema[] schema = new AbstractSchema[vEjbFiles.size()];
            int i3 = 0;
            while (i3 < schema.length) {
                schema[i3] = this.getFilledAbstractSchema((File)vEjbFiles.elementAt(i3), tempDirName, this.loader);
                ++i3;
            }
            new File(tempDirName + File.separator + "tempPersistent").delete();
            this.cascadeDelete(new File(tempDirName));
            abstractSchemaArray = schema;
            Object var17_19 = null;
            if (zipFile == null) return abstractSchemaArray;
        }
        catch (Throwable throwable) {
            Object var17_20 = null;
            if (zipFile == null) throw throwable;
            zipFile.close();
            throw throwable;
        }
        zipFile.close();
        return abstractSchemaArray;
    }

    private String getElementText(Element el) {
        NodeList nodeList = el.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                StandardDOMParser.trimWhiteSpaces((Node)node);
                if (!Symbols.isWhitespace((String)((Text)node).getData())) {
                    return ((Text)node).getData();
                }
            }
            ++i;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private AbstractSchema getFilledAbstractSchema(File ejbFile, String dirName, ClassLoader loader) throws IOException, DeploymentException {
        AbstractSchema abstractSchema;
        ZipFile ejbJar;
        block7: {
            AbstractSchema abstractSchema2;
            block6: {
                ejbJar = null;
                try {
                    ejbJar = new ZipFile(ejbFile);
                    String persistentDirName = dirName + File.separator + "tempPersistent" + File.separator + ejbFile.getName().substring(0, ejbFile.getName().indexOf(46)) + File.separator;
                    this.extractZip(ejbJar, persistentDirName);
                    File ejbXml = new File(persistentDirName + "meta-inf/ejb-jar.xml");
                    if (!ejbXml.exists()) {
                        ejbXml = new File(persistentDirName + "META-INF/ejb-jar.xml");
                    }
                    if (!ejbXml.exists()) {
                        throw new BaseIOException("ejb_9033", new String[]{"ejb-jar.xml"});
                    }
                    Vector warnings = new Vector();
                    EJBJarDescriptor ejbDscr = this.ejbParser.parseXml(new BufferedInputStream(new FileInputStream(ejbXml)), warnings, loader, this.appName, ejbJar.getName(), false, null, false, null);
                    if (ejbDscr.getAbstractSchema().isEmpty()) {
                        abstractSchema2 = ejbDscr.getAbstractSchema();
                        Object var12_11 = null;
                        if (ejbJar == null) return abstractSchema2;
                        break block6;
                    }
                    File persistentXml = new File(persistentDirName + "meta-inf/persistent.xml");
                    if (!persistentXml.exists() && !(persistentXml = new File(persistentDirName + "META-INF/persistent.xml")).exists()) {
                        throw new EJBFileOperationException("ejb_2400", new String[]{ejbFile.getName()});
                    }
                    this.parser = new PersistentParser();
                    this.parser.parseXML(ejbDscr, new BufferedInputStream(new FileInputStream(persistentXml)), warnings, loader);
                    this.cascadeDelete(new File(persistentDirName));
                    abstractSchema = ejbDscr.getAbstractSchema();
                    break block7;
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    if (ejbJar == null) throw throwable;
                    ejbJar.close();
                    throw throwable;
                }
            }
            ejbJar.close();
            return abstractSchema2;
        }
        Object var12_12 = null;
        if (ejbJar == null) return abstractSchema;
        ejbJar.close();
        return abstractSchema;
    }

    private void cascadeDelete(File f) {
        if (!f.isDirectory()) {
            f.delete();
            return;
        }
        File[] fileList = f.listFiles();
        int i = 0;
        while (i < fileList.length) {
            this.cascadeDelete(fileList[i]);
            ++i;
        }
        f.delete();
    }

    private void extractZip(ZipFile _zipFile, String dirName) throws IOException {
        new File(dirName).mkdirs();
        Enumeration<? extends ZipEntry> enumeration = _zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry entry = enumeration.nextElement();
            String entryName = entry.getName().replace('/', File.separatorChar);
            int index = entryName.lastIndexOf(File.separatorChar);
            if (index != -1) {
                new File(dirName, entryName.substring(0, index)).mkdirs();
            }
            if (entry.isDirectory()) continue;
            File destFile = new File(dirName, entryName);
            FileOutputStream out = new FileOutputStream(destFile);
            InputStream in = _zipFile.getInputStream(entry);
            BufferedInputStream bin = new BufferedInputStream(in);
            byte[] buff = new byte[100];
            try {
                while ((index = bin.read(buff)) == buff.length) {
                    out.write(buff, 0, index);
                }
                if (index > 0) {
                    out.write(buff, 0, index);
                }
                out.flush();
            }
            catch (EOFException ex) {
                throw new BaseIOException("ejb_9035");
            }
            in.close();
            bin.close();
            out.close();
        }
    }

    private void addFilesFromLibrary(String libName, Vector vFiles) {
        String[] libJars = this.ejbEnv.getSystemMonitor().getLibrary(libName).getJars();
        int i = 0;
        while (i < libJars.length) {
            vFiles.addElement(new File(libJars[i]));
            ++i;
        }
    }
}

