/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy;

import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.exceptions.BaseClassNotFoundException;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.security.ProtectionDomain;
import java.util.Enumeration;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class EJBLoader
extends ReferencedLoader {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$deploy$EJBLoader == null ? (class$com$sap$engine$services$ejb$deploy$EJBLoader = EJBLoader.class$("com.sap.engine.services.ejb.deploy.EJBLoader")) : class$com$sap$engine$services$ejb$deploy$EJBLoader));
    private File[] source = null;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$deploy$EJBLoader;

    public EJBLoader(File[] _source, String _name, ClassLoader _parent, ProtectionDomain _domain) {
        super(_name, _parent, _domain);
        this.source = _source;
    }

    public URL getLocalResource(String resourceName) {
        ZipEntry entry = null;
        ZipFile jar = null;
        try {
            int i = 0;
            while (i < this.source.length) {
                jar = new ZipFile(this.source[i]);
                entry = jar.getEntry(resourceName);
                if (entry != null) {
                    jar.close();
                    return new URL("file://" + this.source[i].getCanonicalPath() + "!" + resourceName);
                }
                jar.close();
                ++i;
            }
        }
        catch (Exception e) {
            EJBResourceAccessor.location.pathT("Exception in EJBLoader.getLocalResource() : " + e.toString());
            this.closeJar(jar);
        }
        return null;
    }

    public InputStream getLocalResourceAsStream(String resourceName) {
        byte[] byteBuffer = this.getSourceBytes(resourceName);
        if (byteBuffer == null) {
            return null;
        }
        return new ByteArrayInputStream(byteBuffer);
    }

    protected Enumeration findLocalResources(String fileName) throws IOException {
        return this.getLocalResources(fileName);
    }

    public Enumeration getLocalResources(String resourceName) throws IOException {
        ZipEntry entry = null;
        ZipFile jar = null;
        Vector<URL> result = new Vector<URL>();
        try {
            int i = 0;
            while (i < this.source.length) {
                jar = new ZipFile(this.source[i]);
                entry = jar.getEntry(resourceName);
                if (entry != null) {
                    result.add(new URL("file://" + this.source[i].getCanonicalPath() + "!" + resourceName));
                }
                jar.close();
                ++i;
            }
        }
        catch (Exception e) {
            EJBResourceAccessor.location.pathT("Exception in EJBLoader.getLocalResources() : " + e.toString());
            this.closeJar(jar);
        }
        return result.elements();
    }

    public synchronized Class loadLocalClass(String className, String findName) throws ClassNotFoundException {
        Class<?> result = this.findLoadedClass(className);
        if (result != null) {
            return result;
        }
        byte[] byteBuffer = this.getSourceBytes(findName);
        if (byteBuffer == null) {
            BaseClassNotFoundException toThrow = new BaseClassNotFoundException("ejb_9036", new Object[]{findName}, 200);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        int index = className.lastIndexOf(46);
        if (index != -1) {
            String packageName = className.substring(0, index);
            this.definePackage(packageName, null);
        }
        return this.defineClass(className, byteBuffer, 0, byteBuffer.length, this.domain);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private synchronized byte[] getSourceBytes(String entryName) {
        byte[] byArray;
        ZipEntry entry = null;
        ZipFile jar = null;
        byte[] result = null;
        InputStream in = null;
        try {
            try {
                int i = 0;
                while (true) {
                    if (i >= this.source.length) {
                        byArray = null;
                        break;
                    }
                    jar = new ZipFile(this.source[i]);
                    entry = jar.getEntry(entryName);
                    if (entry != null) {
                        in = jar.getInputStream(entry);
                        byte[] byteBuffer = new byte[1024];
                        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
                        int length = in.read(byteBuffer, 0, 1024);
                        while (true) {
                            if (length == -1) {
                                in.close();
                                jar.close();
                                result = buffer.toByteArray();
                                buffer.close();
                                byte[] byArray2 = result;
                                Object var12_14 = null;
                                this.closeJar(jar);
                                return byArray2;
                            }
                            buffer.write(byteBuffer, 0, length);
                            length = in.read(byteBuffer, 0, 1024);
                        }
                    }
                    jar.close();
                    ++i;
                }
            }
            catch (IOException ioe) {
                LOCATION.traceThrowableT(500, null, (Throwable)ioe);
                byte[] byArray3 = null;
                Object var12_16 = null;
                this.closeJar(jar);
                return byArray3;
            }
        }
        catch (Throwable throwable) {
            Object var12_17 = null;
            this.closeJar(jar);
            throw throwable;
        }
        Object var12_15 = null;
        this.closeJar(jar);
        return byArray;
    }

    private void closeJar(ZipFile jar) {
        try {
            if (jar != null) {
                jar.close();
            }
        }
        catch (IOException ioe) {
            LOCATION.traceThrowableT(500, null, (Throwable)ioe);
        }
    }

    public String[] getResourceNames() {
        String[] result = new String[this.source.length];
        int i = 0;
        while (i < this.source.length) {
            try {
                result[i] = this.source[i].getCanonicalPath();
            }
            catch (IOException e) {
                result[i] = this.source[i].getAbsolutePath();
            }
            ++i;
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

