/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy;

import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.load.LoadContext;
import com.sap.engine.frame.core.load.ReferencedLoader;
import com.sap.engine.interfaces.security.ModificationContext;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.interfaces.security.UpdateSecurityContext;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.deploy.DeployAdmin;
import com.sap.engine.services.ejb.deploy.descriptors.ApplicationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.verifier.Verifier;
import com.sap.engine.services.ejb.exceptions.deployment.EJBConfigurationException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBFileOperationException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLParserException;
import com.sap.engine.services.ejb.util.AdminUtils;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class DeltaDeployAdmin {
    private static final String METHOD_MAKE_UPDATE = "DeltaDeployAdmin.makeUpdate(...)";
    public static final String CHANGED_ENTRIES = "changed_entries:";
    public static final String REMOVED_ENTRIES = "removed_entries:";
    public static final String ADDED_ENTRIES = "added_entries:";
    private DeployAdmin deployAdmin = null;
    private Environment environment = null;
    private LoadContext loadContext = null;

    public DeltaDeployAdmin(Environment _environment, DeployAdmin _deployAdmin) {
        this.deployAdmin = _deployAdmin;
        this.environment = _environment;
        this.loadContext = this.environment.getCoreContext().getLoadContext();
    }

    public ApplicationDescriptor makeUpdate(ApplicationDescriptor oldAppDescr, File[] newJars, InputStream[] altDDStreams, int addedJarsCount, String[] removedJarNames, ClassLoader earLoader, String[] remSupp, Configuration securityConfig, Properties props, Vector warnings) throws DeploymentException {
        int newJarsCount = newJars.length;
        String appName = oldAppDescr.getName();
        String appWorkDir = null;
        try {
            appWorkDir = this.environment.getDeployCommunicator().getMyWorkDirectory(appName);
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_2100", new Object[]{appName, METHOD_MAKE_UPDATE}, ioe);
        }
        File appRootDir = new File(appWorkDir);
        ApplicationDescriptor newAppDescr = new ApplicationDescriptor(appName);
        EJBJarDescriptor[] oldJarDescriptors = oldAppDescr.getEJBJarDescriptors();
        EJBJarDescriptor[] newJarDescriptors = new EJBJarDescriptor[newJarsCount];
        SecurityContext securityContext = this.environment.getSecurityContext();
        int j = 0;
        while (j < removedJarNames.length) {
            String policyConfigurationName = appName + "*" + removedJarNames[j];
            securityContext.unregisterPolicyConfiguration(policyConfigurationName);
            try {
                securityConfig.deleteConfiguration(removedJarNames[j]);
            }
            catch (ConfigurationException ce) {
                throw new EJBConfigurationException("ejb_2167", new Object[]{METHOD_MAKE_UPDATE, appName}, (Throwable)((Object)ce));
            }
            ++j;
        }
        UpdateSecurityContext updateSecCtx = securityContext.getUpdateSecurityContext();
        SecurityContext[] jarSecurityContexts = new SecurityContext[newJarsCount];
        int j2 = 0;
        while (j2 < addedJarsCount) {
            String jarName = newJars[j2].getName();
            String policyConfigurationName = appName + "*" + jarName;
            Configuration jarSecurityConfig = null;
            try {
                jarSecurityConfig = securityConfig.createSubConfiguration(jarName);
            }
            catch (ConfigurationException ce) {
                throw new EJBConfigurationException("ejb_2128", new Object[]{METHOD_MAKE_UPDATE, appName}, (Throwable)((Object)ce));
            }
            ModificationContext modificationContext = securityContext.getModificationContext();
            SecurityContext mySecContext = modificationContext.beginModifications(jarSecurityConfig);
            mySecContext.registerPolicyConfiguration(policyConfigurationName);
            jarSecurityContexts[j2] = mySecContext.getPolicyConfigurationContext(policyConfigurationName);
            newJarDescriptors[j2] = this.deployAdmin.parseSingleJar(newJars[j2], altDDStreams[j2], warnings, earLoader, appName, true, jarSecurityContexts[j2], false, null);
            ++j2;
        }
        int j3 = addedJarsCount;
        while (j3 < newJarsCount) {
            String jarName = newJars[j3].getName();
            String policyConfigurationName = appName + "*" + jarName;
            Configuration jarSecurityConfig = null;
            try {
                jarSecurityConfig = securityConfig.getSubConfiguration(jarName);
            }
            catch (ConfigurationException ce) {
                throw new EJBConfigurationException("ejb_2104", new Object[]{METHOD_MAKE_UPDATE, appName}, (Throwable)((Object)ce));
            }
            ModificationContext modificationContext = securityContext.getModificationContext();
            SecurityContext mySecContext = modificationContext.beginModifications(jarSecurityConfig);
            jarSecurityContexts[j3] = mySecContext.getPolicyConfigurationContext(policyConfigurationName);
            updateSecCtx.setSecurityContext(jarSecurityContexts[j3]);
            this.initDefaultSourceSecurity(appRootDir, jarName, updateSecCtx);
            newJarDescriptors[j3] = this.deployAdmin.parseSingleJar(newJars[j3], altDDStreams[j3], warnings, earLoader, appName, false, null, true, updateSecCtx);
            updateSecCtx.updateAuthorization();
            ++j3;
        }
        int[] oldJarIndexes = new int[oldJarDescriptors.length];
        int j4 = 0;
        while (j4 < oldJarDescriptors.length) {
            int oldJarIndex;
            oldJarIndexes[j4] = oldJarIndex = oldJarDescriptors[j4].getJarIndex();
            String jarName = oldJarDescriptors[j4].getJarName();
            if (!AdminUtils.stringInArray(removedJarNames, jarName)) {
                int i = 0;
                while (i < newJarsCount) {
                    if (jarName.equals(newJarDescriptors[i].getJarName())) {
                        newJarDescriptors[i].setJarIndex(oldJarIndex);
                        break;
                    }
                    ++i;
                }
            }
            ++j4;
        }
        int jarIndexCount = 0;
        if (oldJarIndexes.length > 0) {
            jarIndexCount = this.maxInt(oldJarIndexes);
        }
        int j5 = 0;
        while (j5 < addedJarsCount) {
            newJarDescriptors[j5].setJarIndex(++jarIndexCount);
            ++j5;
        }
        newAppDescr.setEJBJarDescriptors(newJarDescriptors);
        Verifier.check(newAppDescr, earLoader, warnings);
        this.deployAdmin.translateQL(appName, newJarDescriptors, earLoader, warnings);
        String[] appClassPaths = this.deployAdmin.makeCompilerClassPaths(appName, earLoader, warnings);
        String appMainClassPath = appClassPaths[0];
        String appCrossClassPath = appClassPaths[1];
        this.loadContext.registerReference(((ReferencedLoader)earLoader).getName(), "library:add_ejb");
        this.loadContext.registerReference(((ReferencedLoader)earLoader).getName(), "service:ejb");
        int j6 = 0;
        while (j6 < newJarsCount) {
            this.deployAdmin.deploySingleJar(newJarDescriptors[j6], newJars[j6], earLoader, appMainClassPath, appCrossClassPath, appRootDir, remSupp, jarSecurityContexts[j6]);
            ++j6;
        }
        return newAppDescr;
    }

    private int maxInt(int[] numbers) {
        int max = numbers[0];
        int i = 1;
        while (i < numbers.length) {
            int number = numbers[i];
            if (number > max) {
                max = number;
            }
            ++i;
        }
        return max;
    }

    private void initDefaultSourceSecurity(File appRootDir, String jarName, UpdateSecurityContext updateSecCtx) throws DeploymentException {
        Element ejbJ2eeEngineEl;
        Element securityPermEl;
        Document ejbJ2eeEngineDocument;
        File backupDir = new File(appRootDir, "backup");
        File altDDsDir = new File(appRootDir, "_oldAltdds");
        File jar = new File(backupDir, jarName);
        File altDDXml = new File(altDDsDir, jarName + ".xml");
        Document ejbJarDocument = null;
        ejbJarDocument = altDDXml.exists() ? this.parseXml(jar, "META-INF/ejb-jar.xml", altDDXml) : this.parseXml(jar, "META-INF/ejb-jar.xml", null);
        if (ejbJarDocument == null) {
            throw new EJBFileOperationException("ejb_2151", new Object[]{jar.getPath()});
        }
        Element ejbJarEl = ejbJarDocument.getDocumentElement();
        Element assemblyEl = (Element)ejbJarEl.getElementsByTagName("assembly-descriptor").item(0);
        if (assemblyEl != null) {
            NodeList secRolesList = assemblyEl.getElementsByTagName("security-role");
            updateSecCtx.setDefaultSourceRoles(secRolesList);
        }
        if ((ejbJ2eeEngineDocument = this.parseXml(jar, "META-INF/ejb-j2ee-engine.xml", null)) != null && (securityPermEl = (Element)(ejbJ2eeEngineEl = ejbJ2eeEngineDocument.getDocumentElement()).getElementsByTagName("security-permission").item(0)) != null) {
            NodeList securityRoleMapList = securityPermEl.getElementsByTagName("security-role-map");
            updateSecCtx.setDefaultSourceRoleMappings(securityRoleMapList);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Document parseXml(File jar, String xmlEntryName, File altDDXml) throws DeploymentException {
        Document document;
        ZipFile file;
        block17: {
            Document document2;
            block16: {
                file = null;
                try {
                    file = new ZipFile(jar);
                }
                catch (IOException ioe) {
                    throw new EJBFileOperationException("ejb_2150", new Object[]{jar.getPath()}, ioe);
                }
                try {
                    try {
                        BufferedInputStream xmlStream = null;
                        if (altDDXml != null) {
                            xmlStream = new BufferedInputStream(new FileInputStream(altDDXml));
                        } else {
                            ZipEntry entry = file.getEntry(xmlEntryName);
                            if (entry == null && (entry = file.getEntry(xmlEntryName.toLowerCase())) == null && (entry = file.getEntry(xmlEntryName.toUpperCase())) == null) {
                                document2 = null;
                                Object var11_12 = null;
                                break block16;
                            }
                            xmlStream = new BufferedInputStream(file.getInputStream(entry));
                        }
                        ClassLoader cl = Thread.currentThread().getContextClassLoader();
                        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
                        StandardDOMParser domParser = new StandardDOMParser();
                        Thread.currentThread().setContextClassLoader(cl);
                        try {
                            domParser.setBackwardsCompatibilityMode(true);
                        }
                        catch (SAXException sax) {
                            throw new EJBXMLParserException("ejb_2246", (Throwable)sax);
                        }
                        domParser.setValidation(true);
                        Document result = domParser.parse((InputStream)xmlStream);
                        xmlStream.close();
                        document = result;
                        break block17;
                    }
                    catch (IOException ioe) {
                        throw new EJBXMLParserException("ejb_2200", new Object[]{xmlEntryName, jar.getPath()}, ioe);
                    }
                    catch (SAXException sax) {
                        throw new EJBXMLParserException("ejb_2200", new Object[]{xmlEntryName, jar.getPath()}, sax);
                    }
                }
                catch (Throwable throwable) {
                    Object var11_14 = null;
                    try {
                        file.close();
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new EJBFileOperationException("ejb_9998", new Object[]{file.getName()}, ioe);
                    }
                }
            }
            try {}
            catch (IOException ioe) {
                throw new EJBFileOperationException("ejb_9998", new Object[]{file.getName()}, ioe);
            }
            file.close();
            return document2;
        }
        Object var11_13 = null;
        try {}
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_9998", new Object[]{file.getName()}, ioe);
        }
        file.close();
        return document;
    }
}

