/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.frame.state.ServiceState;
import com.sap.engine.services.ejb.EJBAdmin;
import com.sap.engine.services.ejb.EJBClusterEventListener;
import com.sap.engine.services.ejb.Environment;
import com.sap.engine.services.ejb.exceptions.ExceptionWrapperException;
import com.sap.engine.services.ejb.failover.EJBSerializatorImpl;
import com.sap.engine.services.ejb.runtime.EJBManagerImpl;
import com.sap.engine.services.ejb.runtime.RuntimeControlsImpl;
import java.rmi.RemoteException;
import java.util.HashSet;

public class EJBFrame
implements ApplicationServiceFrame {
    private ApplicationServiceContext appServiceContext = null;
    private Environment env;
    private EJBAdmin admin = null;

    public void start(ApplicationServiceContext _appServiceContext) throws ServiceException {
        this.appServiceContext = _appServiceContext;
        this.env = new Environment(this.appServiceContext);
        this.admin = new EJBAdmin(this.env);
        this.env.setEJBAdmin(this.admin);
        EJBClusterEventListener ejbClusterEventListener = new EJBClusterEventListener(this.admin);
        this.appServiceContext.getServiceState().registerClusterEventListener(ejbClusterEventListener);
        EJBManagerImpl manager = new EJBManagerImpl(this.admin);
        this.env.getObjectRegistry().registerInterfaceProvider("ejbmonitor", manager);
        EJBSerializatorImpl serializator = new EJBSerializatorImpl(this.admin);
        this.env.getObjectRegistry().registerInterfaceProvider("ejbserialization", serializator);
        ServiceState ownContext = this.appServiceContext.getServiceState();
        try {
            RuntimeControlsImpl managementInterface = new RuntimeControlsImpl(this.admin, this.env);
            ownContext.registerManagementInterface((ManagementInterface)managementInterface);
        }
        catch (RemoteException re) {
            new ExceptionWrapperException(400, re, "ejb_9052").log();
        }
        int mask = 228;
        HashSet<String> names = new HashSet<String>(8);
        names.add("timeout");
        names.add("iiop");
        names.add("failover");
        names.add("shell");
        names.add("cross");
        names.add("appcontext");
        names.add("csiv2");
        names.add("container");
        ownContext.registerContainerEventListener(mask, names, this.env);
    }

    public void stop() throws ServiceRuntimeException {
        try {
            this.admin.stopMyApplications();
            this.env.unregister();
            this.env.getObjectRegistry().unregisterInterfaceProvider("ejbmonitor");
            this.env.getObjectRegistry().unregisterInterfaceProvider("ejbserialization");
            this.appServiceContext.getServiceState().unregisterManagementInterface();
            this.appServiceContext.getServiceState().unregisterClusterEventListener();
        }
        catch (Exception e) {
            ServiceRuntimeException stoppingException = new ServiceRuntimeException("ejb_9053", (Throwable)e);
            stoppingException.log();
            throw stoppingException;
        }
    }
}

