/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb;

import com.sap.engine.services.ejb.ContainerBoot;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.deploy.descriptors.ApplicationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.exceptions.ExceptionWrapperException;
import java.util.Vector;

public class ApplicationThreadDestroyer
implements Runnable {
    private Object synch = null;
    private ApplicationDescriptor appDescr = null;
    private Vector warnings = null;

    public ApplicationThreadDestroyer(Object synch, ApplicationDescriptor appDescr, Vector warnings) {
        this.synch = synch;
        this.appDescr = appDescr;
        this.warnings = warnings;
    }

    public void run() {
        Object object = this.synch;
        synchronized (object) {
            try {
                this.destroyContainers();
                Object var3_2 = null;
                this.synch.notify();
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                this.synch.notify();
                throw throwable;
            }
        }
    }

    private void destroyContainers() {
        EJBJarDescriptor[] ejbJarDescrs = this.appDescr.getEJBJarDescriptors();
        int j = 0;
        while (j < ejbJarDescrs.length) {
            DeploymentDescriptor[] descriptors = ejbJarDescrs[j].getDDescriptors();
            int i = 0;
            while (i < descriptors.length) {
                String ejbName = descriptors[i].getEjbName();
                ContainerBoot container = descriptors[i].getContainerBoot();
                if (container != null) {
                    EJBResourceAccessor.location.pathT("Destroying container for bean: " + ejbName);
                    try {
                        container.destroy();
                    }
                    catch (Exception e) {
                        new ExceptionWrapperException(400, (Throwable)e).log();
                        this.warnings.add("Exception during destroy bean: " + ejbName + ". Reason: " + e.toString());
                    }
                    descriptors[i].setContainerBoot(null);
                }
                ++i;
            }
            ++j;
        }
    }
}

