/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.sfilechooser.tree;

import com.sap.engine.gui.images.ImageHolder;
import com.sap.engine.services.deploy.gui.sfilechooser.FileObject;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;

public class FileListRenderer
extends JLabel
implements ListCellRenderer {
    private ImageIcon filesIcon;
    private ImageIcon floppyIcon;
    private ImageIcon hddIcon;
    private ImageIcon foldersIcon;
    private ImageIcon archiveIcon;
    private ImageIcon dlpFile;
    private ImageIcon xmlFile;

    public FileListRenderer(String arg0, Icon arg1, int arg2) {
        super(arg0, arg1, arg2);
        this.initImages();
    }

    public FileListRenderer(String arg0, int arg1) {
        super(arg0, arg1);
        this.initImages();
    }

    public FileListRenderer(String arg0) {
        super(arg0);
        this.initImages();
    }

    public FileListRenderer(Icon arg0, int arg1) {
        super(arg0, arg1);
        this.initImages();
    }

    public FileListRenderer(Icon arg0) {
        super(arg0);
        this.initImages();
    }

    public FileListRenderer() {
        this.initImages();
    }

    public Component getListCellRendererComponent(JList arg0, Object value, int arg2, boolean selected, boolean arg4) {
        if (value != null) {
            if (value instanceof FileObject) {
                if (((FileObject)value).exists()) {
                    if (((FileObject)value).isDirectory()) {
                        this.setIcon(this.foldersIcon);
                        this.setToolTipText("Directory: " + ((FileObject)value).getAbsolutePath());
                    } else if (((FileObject)value).isFile()) {
                        if (this.isArchive(((FileObject)value).getName())) {
                            this.setIcon(this.archiveIcon);
                        } else if (this.isXML(((FileObject)value).getName())) {
                            this.setIcon(this.xmlFile);
                        } else if (this.isDlp(((FileObject)value).getName())) {
                            this.setIcon(this.dlpFile);
                        } else {
                            this.setIcon(this.filesIcon);
                        }
                        this.setToolTipText("File: " + ((FileObject)value).getAbsolutePath());
                    }
                }
                this.setText(((FileObject)value).toString());
                if (selected) {
                    this.setForeground(Color.blue);
                    this.setBackground(Color.black);
                } else {
                    this.setForeground(Color.black);
                    this.setBackground(Color.blue);
                }
            } else if (value instanceof String) {
                File myFile = new File((String)value);
                if (myFile.exists()) {
                    if (myFile.isDirectory()) {
                        this.setIcon(this.foldersIcon);
                        this.setToolTipText("Directory: " + value);
                    } else if (myFile.isFile()) {
                        if (this.isArchive(myFile.getName())) {
                            this.setIcon(this.archiveIcon);
                        } else if (this.isXML(myFile.getName())) {
                            this.setIcon(this.xmlFile);
                        } else if (this.isDlp(myFile.getName())) {
                            this.setIcon(this.dlpFile);
                        } else {
                            this.setIcon(this.filesIcon);
                        }
                        this.setToolTipText("File: " + value);
                    }
                }
                this.setText((String)value);
                if (selected) {
                    this.setForeground(Color.blue);
                    this.setBackground(Color.black);
                } else {
                    this.setForeground(Color.black);
                    this.setBackground(Color.blue);
                }
            }
        }
        return this;
    }

    private boolean isXML(String s) {
        if (s != null && s.indexOf(".") != -1) {
            String ext = s.substring(s.lastIndexOf("."));
            return ext.equalsIgnoreCase(".xml");
        }
        return false;
    }

    private boolean isDlp(String s) {
        if (s != null && s.indexOf(".") != -1) {
            String ext = s.substring(s.lastIndexOf("."));
            return ext.equalsIgnoreCase(".dlp");
        }
        return false;
    }

    private boolean isArchive(String s) {
        if (s != null && s.indexOf(".") != -1) {
            String ext = s.substring(s.lastIndexOf("."));
            return ext.equalsIgnoreCase(".arj") || ext.equalsIgnoreCase(".rar") || ext.equalsIgnoreCase(".ear") || ext.equalsIgnoreCase(".war") || ext.equalsIgnoreCase(".jar") || ext.equalsIgnoreCase(".sar") || ext.equalsIgnoreCase(".zip") || ext.equalsIgnoreCase(".ace") || ext.equalsIgnoreCase(".gz") || ext.equalsIgnoreCase(".bz") || ext.equalsIgnoreCase(".tar") || ext.equalsIgnoreCase(".bh") || ext.equalsIgnoreCase(".cab");
        }
        return false;
    }

    private void initImages() {
        this.floppyIcon = (ImageIcon)ImageHolder.floppyIcon;
        this.hddIcon = (ImageIcon)ImageHolder.hardDriveIcon;
        this.filesIcon = (ImageIcon)ImageHolder.fileIcon;
        this.foldersIcon = (ImageIcon)ImageHolder.folderIcon;
        this.archiveIcon = (ImageIcon)ImageHolder.archiveIcon;
        this.dlpFile = (ImageIcon)ImageHolder.dlpFile;
        this.xmlFile = (ImageIcon)ImageHolder.xmlFile;
    }
}

