/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.sfilechooser;

import com.sap.engine.services.deploy.gui.sfilechooser.DriveObject;
import java.io.File;
import java.util.Vector;

public class DefaultFileSystem {
    public DriveObject[] getSystemDrives() {
        String osName = System.getProperty("os.name");
        if (File.separatorChar == '/') {
            return this.getUnixDrive();
        }
        if (osName.toLowerCase().startsWith("windows")) {
            return this.getWindowsDrives();
        }
        if (osName.toLowerCase().startsWith("netware")) {
            return this.getNetwareDrive();
        }
        return this.getDefaultDrive();
    }

    protected DriveObject[] getUnixDrive() {
        DriveObject drvObj = new DriveObject("/", 2);
        return new DriveObject[]{drvObj};
    }

    protected DriveObject[] getNetwareDrive() {
        DriveObject drvObj = new DriveObject("Sys:\\", 2);
        return new DriveObject[]{drvObj};
    }

    protected DriveObject[] getWindowsDrives() {
        Vector<String> vector = new Vector<String>();
        char c = 'C';
        while (c <= 'Z') {
            char[] ac = new char[]{c, ':', '\\'};
            String s = new String(ac);
            File file = new File(s);
            if (file != null && file.exists()) {
                vector.addElement(s);
            }
            c = (char)(c + 1);
        }
        int startIndex = 0;
        boolean hasA_Drive = false;
        boolean hasB_Drive = false;
        hasA_Drive = true;
        hasB_Drive = true;
        startIndex = 2;
        int i = vector.size() + startIndex;
        DriveObject[] result = new DriveObject[i];
        if (hasA_Drive) {
            result[0] = new DriveObject("A:\\", 1);
        }
        if (hasB_Drive) {
            result[1] = new DriveObject("B:\\", 1);
        }
        int j = startIndex;
        while (j < i) {
            result[j] = new DriveObject((String)vector.elementAt(j - startIndex), 2);
            ++j;
        }
        return result;
    }

    protected DriveObject[] getDefaultDrive() {
        String homeDir = System.getProperty("user.home");
        int ind = homeDir.indexOf(File.separatorChar);
        String drv = "";
        drv = ind >= 0 ? homeDir.substring(0, ind + 1) : homeDir + File.separatorChar;
        return new DriveObject[]{new DriveObject(drv, 2)};
    }

    public File getFile(String file) {
        if (file == null) {
            return null;
        }
        return new File(file);
    }

    public String getUserDirectory() {
        return System.getProperty("user.dir");
    }

    public String getHomeDirectory() {
        return System.getProperty("user.home");
    }

    public String getFileSeparator() {
        return System.getProperty("file.separator");
    }

    public boolean createDirectory(String d) {
        return new File(d).mkdirs();
    }

    public boolean setFileName(String oldName, String newName) {
        File newFile = new File(newName);
        return new File(oldName).renameTo(newFile);
    }

    public boolean deleteFile(String[] filenames) {
        boolean successful = true;
        int i = 0;
        while (i < filenames.length) {
            boolean success = new File(filenames[i]).delete();
            if (!success) {
                successful = false;
            }
            ++i;
        }
        return successful;
    }
}

