/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.runtime;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.deployer.ExtendedEarReader;
import com.sap.engine.deploy.tool.tree.ArchiveDescriptorNode;
import com.sap.engine.deploy.tool.tree.BasicDescriptorNode;
import com.sap.engine.deploy.tool.tree.ClientDescriptorNode;
import com.sap.engine.deploy.tool.tree.ConnectorDescriptorNode;
import com.sap.engine.deploy.tool.tree.EARDescriptorNode;
import com.sap.engine.deploy.tool.tree.EJBDescriptorNode;
import com.sap.engine.deploy.tool.tree.EJBJarDescriptorNode;
import com.sap.engine.deploy.tool.tree.FilterDescriptorNode;
import com.sap.engine.deploy.tool.tree.ListenerDescriptorNode;
import com.sap.engine.deploy.tool.tree.ServletDescriptorNode;
import com.sap.engine.deploy.tool.tree.WebDescriptorNode;
import com.sap.engine.gui.CFileChooser;
import com.sap.engine.gui.LogMessageDialog;
import com.sap.engine.gui.LookAndFeelHandler;
import com.sap.engine.gui.TreeUtils;
import com.sap.engine.lib.xml.WrongStructureException;
import com.sap.engine.services.appclient.descriptor.ApplicationClientDescriptor;
import com.sap.engine.services.connector.jca.deploy.descriptor.JCDescriptor;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.ear.common.Descriptor;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.extended.ear.EARDescriptor;
import com.sap.engine.services.deploy.gui.DeployRuntimeView;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.servlets_jsp.descriptor.FilterDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ListenerDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.ServletDescriptor;
import com.sap.engine.services.servlets_jsp.descriptor.WebDeploymentDescriptor;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeModel;

public class EarLoader {
    private Frame mainFrame;
    private JTree tree;
    private CFileChooser chooser = null;
    private File additionalXMLsDir = null;
    private Vector errors = new Vector();
    private StringWriter strWr = null;

    public EarLoader() {
        this.chooser = new CFileChooser(this.mainFrame);
        LookAndFeelHandler.add(this.chooser);
    }

    public EarLoader(JTree _tree, Frame _frame) {
        this.mainFrame = _frame;
        this.tree = _tree;
        this.chooser = new CFileChooser(this.mainFrame);
        LookAndFeelHandler.add(this.chooser);
    }

    public void init(JTree _tree, Frame _frame) {
        this.mainFrame = _frame;
        this.tree = _tree;
        this.chooser = new CFileChooser(this.mainFrame);
        LookAndFeelHandler.add(this.chooser);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean loadEar(JTree tree, String fileName, ClassLoader loader, String loaderTempFolder, ApplicationInformationProvider appProvider) {
        File earFile = new File(fileName);
        this.additionalXMLsDir = new File(loaderTempFolder + File.separator + Long.toString(System.currentTimeMillis()));
        if (!earFile.exists()) {
            JOptionPane.showMessageDialog(this.mainFrame, "Error occurred while trying to load ear file - " + earFile.getAbsolutePath() + " does not exists!", "Error in refresh", 0);
            return false;
        }
        ExtendedEarReader reader = null;
        try {
            try {
                Hashtable table;
                reader = new ExtendedEarReader(fileName, new File(loaderTempFolder));
                reader.setLoader(loader);
                EARDescriptor descr = null;
                descr = reader.getFullEarDescriptor();
                this.errors = reader.getErrors();
                EARDescriptorNode earNode = new EARDescriptorNode(earFile.getName());
                earNode.setArchiveTime(earFile.lastModified());
                earNode.setArchiveFileName(fileName);
                tree.setRootVisible(true);
                if (tree.getModel() == null) {
                    tree.setModel(new DefaultTreeModel(earNode));
                } else {
                    ((DefaultTreeModel)tree.getModel()).setRoot(earNode);
                }
                appProvider.setRoot(earNode);
                if (descr != null) {
                    earNode.setEARDescriptor(descr);
                    earNode.setModifiedDescriptor(descr);
                }
                if (descr == null || descr.getArchiveTable() == null || descr.getArchiveTable().size() == 0) {
                    JOptionPane.showMessageDialog(this.mainFrame, "This application hasn't J2EE modules, so it cannot be loaded.\n Proceeding with deploy.", "Warning", 2);
                    boolean bl = false;
                    Object var16_17 = null;
                    Runtime.getRuntime().gc();
                    if (reader == null) return bl;
                    reader.clear();
                    return bl;
                }
                if (descr != null && (table = descr.getArchiveTable()) != null) {
                    ArchiveDescriptor archiveDescr = null;
                    Enumeration en = table.keys();
                    while (en.hasMoreElements()) {
                        String temp;
                        String name = temp = (String)en.nextElement();
                        if (temp.lastIndexOf(File.separator) > -1) {
                            name = temp.substring(temp.lastIndexOf(File.separator) + 1);
                        }
                        if ((archiveDescr = (ArchiveDescriptor)table.get(temp)) instanceof EJBJarDescriptor) {
                            earNode.add(this.loadEjbNode(archiveDescr, name));
                        } else if (archiveDescr instanceof WebDeploymentDescriptor) {
                            earNode.add(this.loadWebNode(archiveDescr, name));
                        } else if (archiveDescr instanceof ApplicationClientDescriptor) {
                            earNode.add(this.loadClientNode(archiveDescr, name));
                        } else if (archiveDescr instanceof JCDescriptor) {
                            earNode.add(this.loadConnectorNode(archiveDescr, name));
                        }
                        ((DefaultTreeModel)tree.getModel()).reload();
                        TreeUtils.expandTree(tree, 1);
                    }
                }
                this.passRoles();
            }
            catch (WrongStructureException wse) {
                DeployRuntimeView.logThrowableT(500, "Unexpected exception.", wse);
                this.strWr = new StringWriter();
                wse.printStackTrace(new PrintWriter(this.strWr));
                if (((EARDescriptorNode)tree.getModel().getRoot()).getChildCount() == 0) {
                    tree.setRootVisible(false);
                    ((EARDescriptorNode)tree.getModel().getRoot()).setEARDescriptor(null);
                } else {
                    tree.setRootVisible(false);
                    ((BasicDescriptorNode)tree.getModel().getRoot()).removeAllChildren();
                    ((EARDescriptorNode)tree.getModel().getRoot()).setEARDescriptor(null);
                }
                LogMessageDialog logErrorDialog = LogMessageDialog.getInstance(this.mainFrame);
                logErrorDialog.showErrorDialogNoLogFile("Error occurred while trying to load ear : \n" + earFile.getName(), this.strWr.getBuffer().toString());
                boolean table = false;
                Object var16_19 = null;
                Runtime.getRuntime().gc();
                if (reader == null) return table;
                reader.clear();
                return table;
            }
            catch (IOException e) {
                DeployRuntimeView.logThrowableT(500, "Unexpected exception.", e);
                this.strWr = new StringWriter();
                e.printStackTrace(new PrintWriter(this.strWr));
                if (((EARDescriptorNode)tree.getModel().getRoot()).getChildCount() == 0) {
                    tree.setRootVisible(false);
                    ((EARDescriptorNode)tree.getModel().getRoot()).setEARDescriptor(null);
                } else {
                    tree.setRootVisible(false);
                    ((BasicDescriptorNode)tree.getModel().getRoot()).removeAllChildren();
                    ((EARDescriptorNode)tree.getModel().getRoot()).setEARDescriptor(null);
                }
                LogMessageDialog logErrorDialog = LogMessageDialog.getInstance(this.mainFrame);
                logErrorDialog.showErrorDialogNoLogFile("Error occurred while trying to load ear : \n" + earFile.getName(), this.strWr.getBuffer().toString());
                boolean bl = false;
                Object var16_20 = null;
                Runtime.getRuntime().gc();
                if (reader == null) return bl;
                reader.clear();
                return bl;
            }
        }
        catch (Throwable throwable) {
            Object var16_21 = null;
            Runtime.getRuntime().gc();
            if (reader == null) throw throwable;
            reader.clear();
            throw throwable;
        }
        Object var16_18 = null;
        Runtime.getRuntime().gc();
        if (reader == null) return true;
        reader.clear();
        return true;
    }

    public void passRoles() {
        if (this.tree.getModel().getRoot() == null) {
            return;
        }
        SecurityRoles[] allRoles = null;
        SecurityRoles[] tempRoles = null;
        allRoles = this.mergeRoles(((EARDescriptorNode)this.tree.getModel().getRoot()).getModifiedDescriptor().getRoles(), allRoles);
        ArchiveDescriptorNode archNode = null;
        WebDeploymentDescriptor webDescr = null;
        EJBJarDescriptor ejbJarDescr = null;
        EARDescriptorNode root = (EARDescriptorNode)this.tree.getModel().getRoot();
        if (root.getChildCount() == 0) {
            root.getModifiedDescriptor().setRoles(null);
            return;
        }
        int i = 0;
        while (i < root.getChildCount()) {
            archNode = (ArchiveDescriptorNode)root.getChildAt(i);
            if (archNode instanceof EJBJarDescriptorNode) {
                ejbJarDescr = (EJBJarDescriptor)archNode.getCurrentDescriptor();
                if (ejbJarDescr != null) {
                    tempRoles = ejbJarDescr.getSecurityRoles();
                    allRoles = this.mergeRoles(tempRoles, allRoles);
                }
            } else if (archNode instanceof WebDescriptorNode && (webDescr = (WebDeploymentDescriptor)archNode.getCurrentDescriptor()) != null) {
                tempRoles = webDescr.getSecRoles();
                allRoles = this.mergeRoles(tempRoles, allRoles);
            }
            ++i;
        }
        root.getModifiedDescriptor().setRoles(allRoles);
        int i2 = 0;
        while (i2 < root.getChildCount()) {
            archNode = (ArchiveDescriptorNode)root.getChildAt(i2);
            if (archNode instanceof EJBJarDescriptorNode) {
                ejbJarDescr = (EJBJarDescriptor)archNode.getCurrentDescriptor();
                if (ejbJarDescr != null) {
                    ejbJarDescr.setSecurityRoles(allRoles);
                    archNode.setModifiedDescriptor(ejbJarDescr);
                }
            } else if (archNode instanceof WebDescriptorNode && (webDescr = (WebDeploymentDescriptor)archNode.getCurrentDescriptor()) != null) {
                webDescr.setSecRoles(allRoles);
                archNode.setModifiedDescriptor(webDescr);
            }
            ++i2;
        }
    }

    private SecurityRoles[] mergeRoles(SecurityRoles[] s1, SecurityRoles[] s2) {
        if (s1 == null) {
            return s2;
        }
        if (s2 == null) {
            return s1;
        }
        if (s1 == null && s2 == null) {
            return null;
        }
        Vector<SecurityRoles> elements = new Vector<SecurityRoles>();
        int i = 0;
        while (i < s1.length) {
            if (s1[i] != null) {
                elements.add(s1[i]);
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < s2.length) {
            if (s2[i2] != null && !this.containsRole(s2[i2], elements)) {
                elements.add(s2[i2]);
            }
            ++i2;
        }
        if (elements.size() > 0) {
            Object[] concatination = new SecurityRoles[elements.size()];
            elements.copyInto(concatination);
            return concatination;
        }
        return null;
    }

    private boolean containsRole(SecurityRoles role, Vector v) {
        if (v == null || role == null || role.getRoleName() == null) {
            return false;
        }
        SecurityRoles vEl = null;
        String roleDescr = role.getDescription();
        String vElDescr = null;
        int i = 0;
        while (i < v.size()) {
            vEl = (SecurityRoles)v.elementAt(i);
            vElDescr = vEl.getDescription();
            if (role.getRoleName().equals(vEl.getRoleName()) && (roleDescr == null && vElDescr == null || roleDescr == null && vElDescr != null && vElDescr.trim().equals("") || roleDescr != null && roleDescr.trim().equals("") && vElDescr == null || roleDescr != null && roleDescr.equals(vElDescr))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private ArchiveDescriptorNode loadEjbNode(ArchiveDescriptor descr, String name) {
        EJBDescriptorNode ejbNode = null;
        EJBJarDescriptorNode ejbJarNode = new EJBJarDescriptorNode(name);
        ejbJarNode.setArchiveFileName(this.getArchiveLocation() + name);
        if (descr.getDisplayName() == null) {
            descr.setDisplayName(((EJBJarDescriptor)descr).getJarName());
        }
        ejbJarNode.setArchiveDescriptor(descr);
        ejbJarNode.setAdditionalFiles(new Vector());
        File xmlsDir = new File(this.additionalXMLsDir, name.replace('.', '_'));
        ejbJarNode.setXMLFileName(xmlsDir.getAbsolutePath());
        DeploymentDescriptor[] beanDescr = ((EJBJarDescriptor)descr).getDDescriptors();
        if (beanDescr != null) {
            int i = 0;
            while (i < beanDescr.length) {
                if (beanDescr[i].getDisplayName() == null) {
                    beanDescr[i].setDisplayName(beanDescr[i].getEjbName());
                }
                String nodeName = null;
                if (beanDescr[i] instanceof CMPEntityDescriptor) {
                    Object[] cmpFld = ((CMPEntityDescriptor)beanDescr[i]).getPKCmpFields();
                    int index_for_remove = -1;
                    if (cmpFld != null) {
                        int j = 0;
                        while (j < cmpFld.length) {
                            if (cmpFld[j].getDescription() != null && cmpFld[j].getDescription().equals("Deployer genrates default PK if it is unknow; spec 10.8.3") && cmpFld[j].getFieldName() != null && cmpFld[j].getFieldName().equals("ejb_pk") && ((PersistentField)cmpFld[j]).getFieldType() != null && ((PersistentField)cmpFld[j]).getFieldType().equals("java.lang.Long")) {
                                index_for_remove = j;
                            }
                            ++j;
                        }
                        Vector<Object> cmp = new Vector<Object>();
                        if (index_for_remove > -1) {
                            int j2 = 0;
                            while (j2 < cmpFld.length) {
                                if (cmpFld[j2].getDescription() != null && !((PersistentField)cmpFld[j2]).getDescription().equals("Deployer genrates default PK if it is unknow; spec 10.8.3")) {
                                    cmp.add(cmpFld[j2]);
                                }
                                ++j2;
                            }
                            cmpFld = new PersistentField[cmp.size()];
                            cmp.copyInto(cmpFld);
                            ((CMPEntityDescriptor)beanDescr[i]).setPKCmpFields((PersistentField[])cmpFld);
                        }
                    }
                }
                if ((nodeName = beanDescr[i].getDisplayName() != null ? beanDescr[i].getDisplayName() : (beanDescr[i].getEjbName() != null ? beanDescr[i].getEjbName().toString() : "DafaultName" + i)) != null) {
                    ejbNode = new EJBDescriptorNode(nodeName.trim());
                    beanDescr[i].setDisplayName(nodeName.trim());
                    ejbNode.setDescriptor(beanDescr[i]);
                    ejbNode.setModifiedDescriptor((DeploymentDescriptor)beanDescr[i].clone());
                    ejbJarNode.add(ejbNode);
                }
                ++i;
            }
            ejbJarNode.setModifiedDescriptor((ArchiveDescriptor)descr.clone());
            TreeUtils.expandTree(this.tree, 1);
        }
        return ejbJarNode;
    }

    private ArchiveDescriptorNode loadWebNode(ArchiveDescriptor descr, String name) {
        int i;
        WebDescriptorNode webNode = new WebDescriptorNode(name);
        ServletDescriptorNode servletNode = null;
        FilterDescriptorNode filterNode = null;
        ListenerDescriptorNode listenerNode = null;
        webNode.setArchiveFileName(this.getArchiveLocation() + name);
        webNode.setArchiveDescriptor(descr);
        webNode.setModifiedDescriptor((ArchiveDescriptor)descr.clone());
        webNode.setAdditionalFiles(new Vector());
        File xmlsDir = new File(this.additionalXMLsDir, name.replace('.', '_'));
        webNode.setXMLFileName(xmlsDir.getAbsolutePath());
        ServletDescriptor[] servletDescr = ((WebDeploymentDescriptor)descr).getServlets();
        FilterDescriptor[] filterDescr = ((WebDeploymentDescriptor)descr).getFilters();
        ListenerDescriptor[] listenerDescr = ((WebDeploymentDescriptor)descr).getListenersDescriptor();
        String nodeName = null;
        if (servletDescr != null) {
            i = 0;
            while (i < servletDescr.length) {
                nodeName = null;
                nodeName = servletDescr[i].getDisplayName() != null ? servletDescr[i].getDisplayName() : (servletDescr[i].getServletName() != null ? servletDescr[i].getServletName() : "DefaultServletName" + i);
                if (nodeName != null) {
                    servletNode = new ServletDescriptorNode(nodeName.trim());
                    servletDescr[i].setDisplayName(nodeName.trim());
                    servletNode.setDescriptor(servletDescr[i]);
                    servletNode.setModifiedDescriptor((Descriptor)servletDescr[i].clone());
                    webNode.add(servletNode);
                }
                ++i;
            }
        }
        if (filterDescr != null) {
            i = 0;
            while (i < filterDescr.length) {
                nodeName = null;
                nodeName = filterDescr[i].getDisplayName() != null ? filterDescr[i].getDisplayName() : (filterDescr[i].getFilterName() != null ? filterDescr[i].getFilterName() : "DefaultFilterName" + i);
                if (nodeName != null) {
                    filterNode = new FilterDescriptorNode(nodeName.trim());
                    filterDescr[i].setDisplayName(nodeName.trim());
                    filterNode.setDescriptor(filterDescr[i]);
                    filterNode.setModifiedDescriptor((Descriptor)filterDescr[i].clone());
                    webNode.add(filterNode);
                }
                ++i;
            }
        }
        if (listenerDescr != null) {
            i = 0;
            while (i < listenerDescr.length) {
                nodeName = null;
                nodeName = listenerDescr[i].getName() != null ? listenerDescr[i].getName() : "DefaultListenerName1";
                if (nodeName != null) {
                    listenerNode = new ListenerDescriptorNode(nodeName.trim());
                    listenerDescr[i].setName(nodeName.trim());
                    listenerNode.setDescriptor(listenerDescr[i]);
                    listenerNode.setModifiedDescriptor((Descriptor)listenerDescr[i].clone());
                    webNode.add(listenerNode);
                }
                ++i;
            }
        }
        TreeUtils.expandTree(this.tree, 1);
        return webNode;
    }

    private ArchiveDescriptorNode loadClientNode(ArchiveDescriptor descr, String name) {
        ClientDescriptorNode clientNode = new ClientDescriptorNode(name);
        clientNode.setArchiveFileName(this.getArchiveLocation() + name);
        clientNode.setArchiveDescriptor(descr);
        clientNode.setModifiedDescriptor((ArchiveDescriptor)descr.clone());
        clientNode.setAdditionalFiles(new Vector());
        File xmlsDir = new File(this.additionalXMLsDir, name.replace('.', '_'));
        clientNode.setXMLFileName(xmlsDir.getAbsolutePath());
        return clientNode;
    }

    private ArchiveDescriptorNode loadConnectorNode(ArchiveDescriptor descr, String name) {
        ConnectorDescriptorNode connectorNode = new ConnectorDescriptorNode(name);
        connectorNode.setArchiveFileName(this.getArchiveLocation() + name);
        connectorNode.setArchiveDescriptor(descr);
        connectorNode.setModifiedDescriptor((ArchiveDescriptor)descr.clone());
        connectorNode.setAdditionalFiles(new Vector());
        File xmlsDir = new File(this.additionalXMLsDir, name.replace('.', '_'));
        connectorNode.setXMLFileName(xmlsDir.getAbsolutePath());
        return connectorNode;
    }

    private String getArchiveLocation() {
        String archPath = null;
        try {
            archPath = this.additionalXMLsDir.getCanonicalPath();
        }
        catch (IOException ioe) {
            DeployRuntimeView.logThrowableT(500, "Unexpected exception.", ioe);
            JOptionPane.showMessageDialog(this.mainFrame, "An IO error occurs, while trying to get the canonical path \nof the additional xml folder.", "ERROR", 0);
        }
        if (archPath != null && archPath.lastIndexOf(File.separator) != -1) {
            archPath = archPath.substring(0, archPath.lastIndexOf(File.separator) + 1);
        }
        return archPath;
    }

    public Vector getErrors() {
        return this.errors;
    }
}

