/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.runtime;

import com.sap.engine.gui.CEscapeDialog;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.ArchiveDescriptor;
import com.sap.engine.services.deploy.extended.ear.EarUpdater;
import com.sap.engine.services.deploy.extended.ear.ExtendedJar;
import com.sap.engine.services.deploy.gui.DeployRuntimeView;
import com.sap.engine.services.deploy.gui.runtime.MainDeployPanelLogical;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class EarDialog
extends CEscapeDialog
implements ActionListener {
    protected Frame frame;
    String name;
    String addClassPath = "";
    private JButton okButton = new JButton();
    private JButton cancelButton = new JButton();
    MainDeployPanelLogical deployPanel = null;
    public static final String OK_CMD = "OK_CMD";
    public static final String CANCEL_CMD = "CANCEL_CMD";
    public static final String TYPE_CMD = "TYPE_CMD";
    public boolean is_ok = false;
    public JRadioButton contTypeA = new JRadioButton("ContainerType A");
    public JRadioButton contTypeB = new JRadioButton("ContainerType B");
    public JCheckBoxMenuItem verifyAppExistenceItem = new JCheckBoxMenuItem("Application overwriting check");
    public JPanel extendedPanel = new JPanel();
    JPanel checkButtonPanel = new JPanel();
    public EarUpdater updater = null;
    public ExtendedJar[] jars = null;
    public ArchiveDescriptor[] descr = null;
    private boolean isLoaded = false;

    public EarDialog(Frame frame) {
        super(frame, "Deploy Dialog", true);
        this.frame = frame;
        this.deployPanel = new MainDeployPanelLogical(frame);
        this.init();
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAddClassPath(String addClassPath) {
        this.addClassPath = addClassPath;
    }

    public void setEar() throws IOException {
        this.isLoaded = this.deployPanel.loadEarAction(this.name, this.addClassPath);
    }

    protected void init() {
        JPanel buttonsPanel = new JPanel();
        JPanel radioPanel = new JPanel();
        radioPanel.setLayout(new BorderLayout());
        this.okButton.setText("OK");
        this.okButton.setActionCommand(OK_CMD);
        this.okButton.addActionListener(this);
        this.cancelButton.setText("Cancel");
        this.cancelButton.setActionCommand(CANCEL_CMD);
        this.cancelButton.addActionListener(this);
        this.verifyAppExistenceItem.setState(true);
        buttonsPanel.add(this.okButton);
        buttonsPanel.add(this.cancelButton);
        this.extendedPanel.setLayout(new BorderLayout());
        this.extendedPanel.add((Component)this.deployPanel, "Center");
        this.checkButtonPanel.setLayout(new BorderLayout());
        this.checkButtonPanel.add((Component)this.verifyAppExistenceItem, "North");
        this.checkButtonPanel.add((Component)buttonsPanel, "South");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)this.extendedPanel, "Center");
        this.getContentPane().add((Component)this.checkButtonPanel, "South");
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(OK_CMD)) {
            this.okAction();
        } else if (cmd.equals(CANCEL_CMD)) {
            this.cancelAction();
        }
    }

    protected void okAction() {
        this.deployPanel.updateNodeProperties();
        this.is_ok = true;
        ((Component)this).setVisible(false);
        this.updater = new EarUpdater();
        this.updater.setFile(this.name);
        try {
            this.updater.setTempDir(this.name.substring(0, this.name.lastIndexOf(File.separator)) + File.separator + "updater_temp");
            this.updater.update(this.deployPanel.getDescriptors(), this.deployPanel.getEARDescriptor());
        }
        catch (DeploymentException de) {
            DeployRuntimeView.logThrowableT(500, "Unexpected exception.", (Throwable)((Object)de));
            JOptionPane.showMessageDialog(this.frame, "Cannot deploy application. Error during ");
            this.is_ok = false;
        }
    }

    protected void cancelAction() {
        this.is_ok = false;
        ((Component)this).setVisible(false);
    }

    public boolean isOK() {
        return this.is_ok;
    }

    public void setRemoteSecurity(RemoteSecurity node) {
        this.deployPanel.setRemoteSecurity(node);
    }

    public boolean getContainerType() {
        return this.contTypeB.isSelected();
    }

    public void deleteTampFiles() {
        this.updater.clear();
    }

    public String getAppName() {
        return this.deployPanel.getEARDescriptor().getApplicationID();
    }

    public boolean isFerifying() {
        return this.verifyAppExistenceItem.getState();
    }

    public void setCheckAppVisible(boolean state) {
        this.verifyAppExistenceItem.setVisible(state);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelAction();
    }

    public void show() {
        if (!this.isLoaded) {
            this.getContentPane().remove(this.extendedPanel);
            ((Component)this).setSize(260, 100);
            this.setLocationRelativeTo(this.frame);
        } else {
            this.getContentPane().remove(this.extendedPanel);
            this.getContentPane().remove(this.checkButtonPanel);
            this.getContentPane().add((Component)this.extendedPanel, "Center");
            this.getContentPane().add((Component)this.checkButtonPanel, "South");
        }
        super.show();
    }
}

