/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.mapping.tree;

import com.sap.engine.services.deploy.gui.mapping.tree.ClassFileMappingTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.DirMappingTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.FileMappingTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.ManifestTreeNode;
import com.sap.engine.services.deploy.gui.mapping.tree.MappingTree;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreePath;

public class TreeMouseListener
extends MouseAdapter {
    public void mouseClicked(MouseEvent e) {
        Object o = e.getSource();
        if (!(o instanceof JTree)) {
            return;
        }
        MappingTree tree = (MappingTree)o;
        int row = tree.getRowForLocation(e.getX(), e.getY());
        if (row < 0) {
            return;
        }
        if (e.getClickCount() == 2) {
            TreePath path = tree.getPathForRow(row);
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            if (node instanceof FileMappingTreeNode) {
                return;
            }
            if (node instanceof ClassFileMappingTreeNode) {
                return;
            }
            if (node instanceof ManifestTreeNode) {
                return;
            }
            DirMappingTreeNode obj = (DirMappingTreeNode)node;
            if (obj.getMapObjValue().getFilePath().equals("Directories")) {
                return;
            }
            tree.repaint();
        } else {
            Rectangle r = tree.getRowBounds(row);
            if (e.getX() > r.x && e.getX() < r.x + 12) {
                TreePath path = tree.getPathForRow(row);
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (node instanceof FileMappingTreeNode) {
                    return;
                }
                if (node instanceof ClassFileMappingTreeNode) {
                    return;
                }
                if (node instanceof ManifestTreeNode) {
                    return;
                }
                DirMappingTreeNode obj = (DirMappingTreeNode)node;
                if (obj.getMapObjValue().getFilePath().equals("Directories")) {
                    return;
                }
                obj.getMapObjValue().setIncluded(!obj.getMapObjValue().isIncluded());
                if (tree.getDirMapPanel() != null) {
                    if (!obj.getMapObjValue().isIncluded()) {
                        tree.getDirMapPanel().setAllDisable();
                    } else {
                        tree.getDirMapPanel().setAllEnable();
                    }
                }
                tree.repairSelections(path, obj.getMapObjValue().isIncluded());
                tree.repaint();
            }
        }
    }
}

