/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.mapping;

import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;

public class MappingObject {
    private String filePath = "";
    private Properties mappings;
    private boolean included = true;
    private Vector excluded;

    public MappingObject() {
        this.mappings = new Properties();
        this.excluded = new Vector();
    }

    public MappingObject(String filePath, Properties mappings) {
        this.mappings = mappings;
        this.filePath = filePath;
        this.excluded = new Vector();
    }

    public MappingObject(String filePath, Properties mappings, boolean included) {
        this.mappings = mappings;
        this.filePath = filePath;
        this.included = included;
        this.excluded = new Vector();
    }

    public void setFilePath(String path) {
        this.filePath = path;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public void setMappings(Properties map) {
        this.mappings = map;
    }

    public Properties getMappings() {
        return this.mappings;
    }

    public void setIncluded(boolean ifIncluded) {
        this.included = ifIncluded;
    }

    public boolean isIncluded() {
        return this.included;
    }

    public Vector getExcludedFilters() {
        return this.excluded;
    }

    public void setExcludedFilters(Vector vec) {
        this.excluded = vec;
    }

    public boolean equals(Object map) {
        if (map == null) {
            return false;
        }
        if (!(map instanceof MappingObject)) {
            return false;
        }
        if (this.filePath != null) {
            if (!this.filePath.equals(((MappingObject)map).getFilePath())) {
                return false;
            }
            if (!((Hashtable)this.mappings).equals(((MappingObject)map).getMappings())) {
                return false;
            }
            if (!this.included == ((MappingObject)map).isIncluded()) {
                return false;
            }
            if (!this.excluded.equals(((MappingObject)map).getExcludedFilters())) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return this.filePath;
    }

    public Object clone() {
        MappingObject ttmp = new MappingObject(new String(this.filePath), (Properties)((Hashtable)this.mappings).clone(), this.included);
        if (this.excluded != null) {
            Vector exl = new Vector();
            int i = 0;
            while (i < this.excluded.size()) {
                exl.add(this.excluded.elementAt(i));
                ++i;
            }
            ttmp.setExcludedFilters(exl);
        }
        return ttmp;
    }
}

