/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.ear;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.tree.EARDescriptorNode;
import com.sap.engine.deploy.tool.tree.ImageHolder;
import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.jar.InfoObject;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.gui.common.AdditionalPanelLogical;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.ear.AppReferencePanelLogical;
import com.sap.engine.services.deploy.gui.ear.ApplicationAdditonalPanel;
import com.sap.engine.services.deploy.gui.ear.ComponentToContainerLogical;
import com.sap.engine.services.deploy.gui.ear.ContextPanel;
import com.sap.engine.services.deploy.gui.ear.SecurityViewPanel;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JTabbedPane;

public class SimpleEarDescriptorTabPanel
extends BasicPanelView {
    protected JTabbedPane theTabbedPane = new JTabbedPane(1);
    protected ContextPanel contextPanel;
    protected SecurityViewPanel securityViewPanel;
    protected AppReferencePanelLogical appReferencePanel;
    protected ApplicationAdditonalPanel appAdditionalPanel;
    protected ComponentToContainerLogical componentToContainerPanel;
    protected AdditionalPanelLogical additionalPanel;
    protected int madeFrom;
    protected SimpleEarDescriptor simpleDescr;
    private ApplicationInformationProvider appProvider;

    public SimpleEarDescriptorTabPanel(Frame _frame, int _madeFrom) {
        this.mainFrame = _frame;
        this.madeFrom = _madeFrom;
        SerializableFile[] defaultIcons = new SerializableFile[2];
        new ImageHolder();
        defaultIcons[0] = ImageHolder.eEarIcon;
        new ImageHolder();
        defaultIcons[1] = ImageHolder.eEarBigIcon;
        this.additionalPanel = new AdditionalPanelLogical(this.mainFrame, defaultIcons, "Application", false, false, _madeFrom);
        this.additionalPanel.setButtonsEnabled(true);
        if (this.madeFrom == 2) {
            this.additionalPanel.setForEar(true);
            this.additionalPanel.setEnabled(true);
        }
        if (this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 0) {
            this.additionalPanel.setForEar(true);
            this.additionalPanel.setEnabled(false);
        }
        this.securityViewPanel = new SecurityViewPanel(this.mainFrame, this.madeFrom);
        this.appReferencePanel = new AppReferencePanelLogical(this.mainFrame, this.madeFrom);
        this.appAdditionalPanel = new ApplicationAdditonalPanel(this.mainFrame, this.madeFrom);
        this.componentToContainerPanel = new ComponentToContainerLogical(this.mainFrame, this.madeFrom);
        this.contextPanel = new ContextPanel(null, this.madeFrom);
        this.jbInit();
    }

    protected void jbInit() {
        this.theTabbedPane.removeAll();
        this.theTabbedPane.addTab("Context", this.contextPanel);
        this.theTabbedPane.addTab("Security View", this.securityViewPanel);
        if (this.madeFrom == 3 || this.madeFrom == 4 || this.madeFrom == 5) {
            JTabbedPane union = new JTabbedPane();
            union.addTab("Reference", this.appReferencePanel);
            union.addTab("Property", this.appAdditionalPanel);
            union.addTab("Distribution", this.componentToContainerPanel);
            this.theTabbedPane.add("Extra Information", union);
        }
        this.theTabbedPane.addTab("Additional", this.additionalPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.theTabbedPane, "Center");
    }

    public String getDisplayName() {
        return this.additionalPanel.getDisplayName();
    }

    public void init(int madeFromConstant) {
        if (this.madeFrom != 3 && madeFromConstant == 3 || this.madeFrom != 5 && madeFromConstant == 5 || this.madeFrom != 4 && madeFromConstant == 4) {
            this.theTabbedPane.remove(this.additionalPanel);
            JTabbedPane union = new JTabbedPane();
            union.addTab("Reference", this.appReferencePanel);
            union.addTab("Property", this.appAdditionalPanel);
            union.addTab("Distribution", this.componentToContainerPanel);
            this.theTabbedPane.add("Extra Information", union);
            this.theTabbedPane.addTab("Additional", this.additionalPanel);
        }
        this.madeFrom = madeFromConstant;
        this.additionalPanel.init(madeFromConstant);
        this.securityViewPanel.init(madeFromConstant);
        this.contextPanel.init(madeFromConstant);
    }

    public void clear() {
        this.contextPanel.clear();
        this.securityViewPanel.clear();
        this.appReferencePanel.clear();
        this.appAdditionalPanel.clear();
        this.componentToContainerPanel.clear();
        this.additionalPanel.clear();
    }

    public int isCorrect() {
        int secondIndex;
        int isCorrectIndex = this.contextPanel.isCorrect();
        if (isCorrectIndex < (secondIndex = this.securityViewPanel.isCorrect())) {
            isCorrectIndex = secondIndex;
        }
        if (isCorrectIndex < (secondIndex = this.appReferencePanel.isCorrect())) {
            isCorrectIndex = secondIndex;
        }
        if (isCorrectIndex < (secondIndex = this.appAdditionalPanel.isCorrect())) {
            isCorrectIndex = secondIndex;
        }
        if (isCorrectIndex < (secondIndex = this.componentToContainerPanel.isCorrect())) {
            isCorrectIndex = secondIndex;
        }
        if (isCorrectIndex < (secondIndex = this.additionalPanel.isCorrect())) {
            isCorrectIndex = secondIndex;
        }
        return isCorrectIndex;
    }

    public void commitChange() {
        SerializableFile[] icons = this.additionalPanel.commitChanges();
        if (icons != null) {
            SerializableFile file = icons[0];
            InfoObject info = null;
            if (file != null) {
                info = new InfoObject(file.getFileName(), file.getAbsoluteFilePath());
            }
            if (this.appProvider != null && this.appProvider.getRoot() != null) {
                ((EARDescriptorNode)this.appProvider.getRoot()).addAdditionalFile(info);
            }
            this.simpleDescr.setSmallIcon(file);
            file = icons[1];
            info = null;
            if (file != null) {
                info = new InfoObject(file.getFileName(), file.getAbsoluteFilePath());
            }
            if (this.appProvider != null && this.appProvider.getRoot() != null) {
                ((EARDescriptorNode)this.appProvider.getRoot()).addAdditionalFile(info);
            }
            this.simpleDescr.setLargeIcon(file);
        }
        this.simpleDescr.setDisplayName(this.additionalPanel.getDisplayName());
        this.simpleDescr.setDescription(this.additionalPanel.getDescription());
        this.securityViewPanel.commitChange();
        this.simpleDescr.setRoles(this.securityViewPanel.getSecurityRoles());
        this.contextPanel.commitChange();
        this.appReferencePanel.commitChange();
        this.appAdditionalPanel.commitChange();
        this.componentToContainerPanel.commitChange();
        this.simpleDescr.replaceModules(this.contextPanel.getModules());
    }

    public void setDescriptor(SimpleEarDescriptor descr) {
        Vector infos;
        this.simpleDescr = descr;
        SerializableFile[] icons = new SerializableFile[]{this.simpleDescr.getSmallIcon(), this.simpleDescr.getLargeIcon()};
        if (this.madeFrom == 2 && this.appProvider != null && this.appProvider.getRoot() != null && (infos = ((EARDescriptorNode)this.appProvider.getRoot()).getAdditionalFiles()) != null) {
            InfoObject temp = null;
            int i = 0;
            while (i < infos.size()) {
                temp = (InfoObject)infos.elementAt(i);
                if (temp != null) {
                    int j = 0;
                    while (j < icons.length) {
                        if (icons[j] != null && icons[j].getFileName() != null && icons[j].getFileName().equals(temp.getEntryName())) {
                            icons[j].setAbsoluteFilePath(temp.getFilePath());
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        this.additionalPanel.setDescriptor(icons, this.simpleDescr.getDescription(), this.simpleDescr.getDisplayName(), this.simpleDescr.getDisplayName() + " ear", this.getArchiveFile());
        this.additionalPanel.setButtonsEnabled(true);
        this.securityViewPanel.setDescriptor(this.simpleDescr);
        this.contextPanel.setDescriptor(descr.getWEBs());
        this.appReferencePanel.setDescriptor(this.simpleDescr);
        this.appAdditionalPanel.setDescriptor(this.simpleDescr);
        this.componentToContainerPanel.setDescriptor(this.simpleDescr);
    }

    public void setContext(RemoteSecurity node) {
        this.securityViewPanel.setContext(node);
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setLoader(ClassLoader loader) {
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider _appProvider) {
        if (this.additionalPanel != null) {
            this.additionalPanel.setApplicationInformationProvider(_appProvider);
            this.additionalPanel.setArchiveName(this.getArchiveFile());
        }
        if (this.securityViewPanel != null) {
            this.securityViewPanel.setApplicationInformationProvider(_appProvider);
        }
        if (this.contextPanel != null) {
            this.contextPanel.setApplicationInformationProvider(_appProvider);
        }
        if (this.appReferencePanel != null) {
            this.appReferencePanel.setApplicationInformationProvider(_appProvider);
        }
        if (this.appAdditionalPanel != null) {
            this.appAdditionalPanel.setApplicationInformationProvider(_appProvider);
        }
        if (this.componentToContainerPanel != null) {
            this.componentToContainerPanel.setApplicationInformationProvider(_appProvider);
        }
        this.appProvider = _appProvider;
    }

    public void setDisplayName(String displayName) {
        if (this.additionalPanel != null) {
            SerializableFile[] icons = new SerializableFile[]{this.simpleDescr.getSmallIcon(), this.simpleDescr.getLargeIcon()};
            this.additionalPanel.setDescriptor(icons, this.simpleDescr.getDescription(), displayName, this.simpleDescr.getDisplayName() + " ear", this.getArchiveFile());
        }
    }

    private String getArchiveFile() {
        if (this.appProvider != null && this.appProvider.getRoot() != null && this.madeFrom != 2) {
            return ((EARDescriptorNode)this.appProvider.getRoot()).getArchiveFileName();
        }
        return null;
    }

    public JTabbedPane getTheTab() {
        this.jbInit();
        return this.theTabbedPane;
    }

    public AdditionalPanelLogical getAdditionalPanelLogical() {
        return this.additionalPanel;
    }
}

