/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.ear;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.ear.WarListRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.StringTokenizer;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ContextPanel
extends BasicPanelView
implements ListSelectionListener,
ActionListener {
    private JList dataList;
    private DefaultListModel listModel;
    private JTextField fileText;
    private JTextField rootText;
    private JButton modifyButton;
    private J2EEModule[] modules;
    private int oldSelection = -1;
    private int madeFrom;
    private ApplicationInformationProvider appProvider;
    public static final String MODIFY_CMD = "MODIFY_CMD";

    public ContextPanel(J2EEModule[] modules1, int _madeFrom) {
        this.madeFrom = _madeFrom;
        if (modules1 != null) {
            this.modules = new J2EEModule[modules1.length];
            System.arraycopy(modules1, 0, this.modules, 0, modules1.length);
        } else {
            this.modules = null;
        }
        this.visualInit();
        this.init();
    }

    private void visualInit() {
        JPanel leftPanel = new JPanel();
        JPanel rightPanel = new JPanel();
        this.setLayout(new BorderLayout());
        leftPanel.setLayout(new BorderLayout());
        rightPanel.setLayout(new GridBagLayout());
        JScrollPane scrollPane = new JScrollPane();
        this.listModel = new DefaultListModel();
        this.dataList = new JList(this.listModel);
        this.dataList.setSelectionMode(0);
        this.dataList.addListSelectionListener(this);
        scrollPane.getViewport().setView(this.dataList);
        this.fileText = new JTextField();
        this.fileText.setEnabled(false);
        this.rootText = new JTextField();
        this.modifyButton = new JButton("Modify");
        this.modifyButton.setEnabled(false);
        this.modifyButton.setActionCommand(MODIFY_CMD);
        this.modifyButton.addActionListener(this);
        JLabel fileLabel = new JLabel("File Name:");
        JLabel rootLabel = new JLabel("Context Root:");
        rightPanel.add((Component)fileLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        rightPanel.add((Component)this.fileText, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        rightPanel.add((Component)rootLabel, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        rightPanel.add((Component)this.rootText, new GridBagConstraints(1, 1, 1, 1, 0.1, 0.0, 10, 2, new Insets(5, 5, 5, 5), 0, 0));
        rightPanel.add((Component)this.modifyButton, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.1, 11, 0, new Insets(5, 5, 5, 5), 0, 0));
        leftPanel.add((Component)scrollPane, "Center");
        leftPanel.setPreferredSize(new Dimension(150, 400));
        leftPanel.setBorder(new TitledBorder(BorderFactory.createEtchedBorder(), "WAR Files"));
        JSplitPane split = new JSplitPane();
        split.setLeftComponent(leftPanel);
        split.setRightComponent(rightPanel);
        split.setDividerLocation(200);
        this.add((Component)split, "Center");
        this.dataList.setCellRenderer(new WarListRenderer());
    }

    private void init() {
        if (this.modules != null) {
            int i = 0;
            while (i < this.modules.length) {
                this.listModel.add(0, this.modules[i]);
                ++i;
            }
        }
    }

    public void valueChanged(ListSelectionEvent e) {
        if (!this.dataList.isSelectionEmpty()) {
            if (this.oldSelection == -1) {
                this.display((J2EEModule)this.dataList.getSelectedValue());
                this.oldSelection = this.dataList.getSelectedIndex();
            } else {
                this.checkPanel();
                this.oldSelection = this.dataList.getSelectedIndex();
                this.display((J2EEModule)this.dataList.getSelectedValue());
            }
            this.modifyButton.setEnabled(true);
        } else {
            this.modifyButton.setEnabled(false);
            this.oldSelection = -1;
            this.fileText.setText("");
            this.rootText.setText("");
        }
    }

    public J2EEModule[] getModules() {
        return this.modules;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals(MODIFY_CMD)) {
            ((J2EEModule)this.listModel.getElementAt(this.oldSelection)).setContextRoot(this.rootText.getText().trim().equals("") ? "/" : this.rootText.getText().trim());
            this.fileText.setText("");
            this.rootText.setText("");
            this.dataList.clearSelection();
        }
    }

    public void setDescriptor(J2EEModule[] modules1) {
        this.clear();
        if (modules1 != null) {
            this.modules = new J2EEModule[modules1.length];
            System.arraycopy(modules1, 0, this.modules, 0, modules1.length);
        } else {
            this.modules = null;
        }
        this.init();
    }

    public void commitChange() {
        Object[] arr = this.dataList.getSelectedValues();
        if (arr != null && arr.length != 0) {
            this.modules = new J2EEModule[arr.length];
            System.arraycopy(arr, 0, this.modules, 0, arr.length);
        } else {
            this.modules = null;
        }
        this.fileText.setText("");
        this.rootText.setText("");
        this.dataList.clearSelection();
    }

    public void checkPanel() {
        String root = this.rootText.getText().trim();
        if (!((J2EEModule)this.listModel.getElementAt(this.oldSelection)).getContextRoot().equals(root)) {
            int answer = JOptionPane.showConfirmDialog(this.mainFrame, "There is new root <" + root + "> described.\n Would you like to modify it?", "Warning", 0, 2);
            if (answer == 0) {
                ((J2EEModule)this.listModel.getElementAt(this.oldSelection)).setContextRoot(this.rootText.getText().trim().equals("") ? "/" : this.rootText.getText().trim());
            }
            this.fileText.setText("");
            this.rootText.setText("");
        }
    }

    public int isCorrect() {
        return 0;
    }

    public void init(int constant) {
    }

    public void clear() {
        this.listModel.clear();
        this.fileText.setText("");
        this.rootText.setText("");
        this.oldSelection = -1;
    }

    private void display(J2EEModule moduleToDisplay) {
        this.fileText.setText(this.separate(this.processString(moduleToDisplay.getUri(), true)));
        this.rootText.setText(moduleToDisplay.getContextRoot());
    }

    protected String processString(String str, boolean saving) {
        char separator = File.separatorChar;
        String str2 = "";
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (saving) {
                if (ch == separator) {
                    ch = '\\';
                }
            } else if (ch == '\\') {
                ch = separator;
            }
            str2 = str2 + ch;
            ++i;
        }
        return str2;
    }

    private String separate(String s) {
        StringTokenizer st = new StringTokenizer(s, "\\");
        String s1 = null;
        while (st.hasMoreTokens()) {
            s1 = st.nextToken();
        }
        return s1;
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setLoader(ClassLoader loader) {
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }
}

