/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.ear;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.deploy.tool.tree.EARDescriptorNode;
import com.sap.engine.gui.editorproperties.PropertiesTableModel;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.ear.ComponentToContainerPanel;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class ComponentToContainerLogical
extends ComponentToContainerPanel {
    protected PropertiesTableModel tableModel;
    protected Hashtable hash;
    protected SimpleEarDescriptor descr = null;
    protected int madeFrom = 3;
    protected ApplicationInformationProvider appProvider;

    public ComponentToContainerLogical(Frame frame, int madeFrom) {
        this.mainFrame = frame;
        this.madeFrom = madeFrom;
        this.tableModel = new PropertiesTableModel("Component", "Containers(use \";\" for delimiter)");
        this.initEditor();
    }

    private void initEditor() {
        this.table.setModel(this.tableModel);
        this.table.getSelectionModel().addListSelectionListener(this);
        this.addButton.addActionListener(this);
        this.modifyButton.addActionListener(this);
        this.removeButton.addActionListener(this);
        this.clearButton.addActionListener(this);
        this.componentComboBox.addKeyListener(this);
        this.containerTextField.addKeyListener(this);
    }

    public void actionPerformed(ActionEvent ae) {
        String cmd = ae.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addBtnAction();
            this.clear();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.removeBtnAction();
            this.clear();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyBtnAction();
            this.clear();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.clear();
        }
    }

    private void addBtnAction() {
        if (this.componentComboBox.getSelectedIndex() == -1) {
            return;
        }
        this.tableModel.addRow((String)this.componentComboBox.getSelectedItem(), this.containerTextField.getText());
        this.componentComboBox.setSelectedIndex(-1);
        this.containerTextField.setText("");
        this.componentComboBox.requestFocus();
    }

    private void removeBtnAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        this.tableModel.removeRow(selRow);
        if (selRow >= this.table.getRowCount() && this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
        this.table_valueChanged();
    }

    private void modifyBtnAction() {
        int selRow = this.table.getSelectedRow();
        this.table.editingStopped(new ChangeEvent(this.table));
        this.tableModel.addRow((String)this.componentComboBox.getSelectedItem(), this.containerTextField.getText());
        if (selRow >= this.table.getRowCount() && this.table.getRowCount() > 0) {
            this.table.setRowSelectionInterval(this.table.getRowCount() - 1, this.table.getRowCount() - 1);
        } else {
            this.table.getSelectionModel().clearSelection();
        }
        this.table_valueChanged();
    }

    public void valueChanged(ListSelectionEvent e) {
        if (e == null || e.getValueIsAdjusting()) {
            return;
        }
        this.table_valueChanged();
    }

    private void table_valueChanged() {
        int row = this.table.getSelectedRow();
        if (row >= this.table.getRowCount() || row < 0) {
            this.clear();
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.clearButton.setEnabled(true);
            return;
        }
        this.addButton.setEnabled(true);
        this.modifyButton.setEnabled(true);
        this.removeButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.componentComboBox.setSelectedItem(this.tableModel.getValueAt(row, 0));
        this.containerTextField.setText((String)this.tableModel.getValueAt(row, 1));
    }

    public void keyPressed(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            this.addBtnAction();
        }
    }

    public void keyReleased(KeyEvent e) {
    }

    public void keyTyped(KeyEvent e) {
    }

    private String getArchiveFile() {
        if (this.appProvider != null && this.appProvider.getRoot() != null && this.madeFrom != 2) {
            return ((EARDescriptorNode)this.appProvider.getRoot()).getArchiveFileName();
        }
        return null;
    }

    private void evaluate(JComboBox comboBox, String add) {
        if (add == null || comboBox == null) {
            return;
        }
        comboBox.removeItem(add);
        comboBox.addItem(add);
        comboBox.setSelectedItem(add);
    }

    private void setComponents() {
        String archiveFile;
        this.componentComboBox.removeAllItems();
        if (this.descr != null && (archiveFile = this.getArchiveFile()) != null) {
            try {
                ZipFile zip = null;
                String temp = archiveFile.substring(0, archiveFile.lastIndexOf(File.separator)) + File.separator + "deploy_temp" + archiveFile.substring(archiveFile.lastIndexOf(File.separator));
                zip = new File(temp).exists() ? new ZipFile(temp) : new ZipFile(archiveFile);
                Enumeration<? extends ZipEntry> enumeration = zip.entries();
                ZipEntry entry = null;
                while (enumeration != null && enumeration.hasMoreElements()) {
                    entry = enumeration.nextElement();
                    if (entry == null || entry.getName() == null) continue;
                    this.evaluate(this.componentComboBox, entry.getName());
                }
            }
            catch (IOException exc) {
                JOptionPane.showMessageDialog(this.mainFrame, "An I/O error occurs.", "Error", 0);
            }
        }
    }

    public void setDescriptor(SimpleEarDescriptor descr) {
        this.descr = descr;
        this.tableModel.clearAll();
        this.componentComboBox.setSelectedIndex(-1);
        this.containerTextField.setText("");
        this.table.getSelectionModel().clearSelection();
        if (descr == null) {
            return;
        }
        this.setComponents();
        this.componentComboBox.setSelectedIndex(-1);
        Hashtable newHash = descr.getAdditionalModules();
        if (newHash != null) {
            String key = null;
            String value = null;
            Enumeration keysEnum = newHash.keys();
            boolean isErrorInfo = false;
            String message = "The information about ear components in the application-j2ee-engine.xml is wrong.\nThe errors are: \n";
            while (keysEnum.hasMoreElements()) {
                key = (String)keysEnum.nextElement();
                value = (String)newHash.get(key);
                if (key != null && !key.trim().equals("") && value != null && !value.trim().equals("")) {
                    this.componentComboBox.setSelectedItem(key);
                    if (key.equals(this.componentComboBox.getSelectedItem())) {
                        this.tableModel.addRow(key, value);
                        continue;
                    }
                    message = message + "   The component named <" + key + "> does not exist in the ear file.\n";
                    isErrorInfo = true;
                    continue;
                }
                if (key == null || key.trim().equals("")) {
                    message = message + "   Wrong component name: " + (key == null ? "null" : "empty string") + ".\n";
                    isErrorInfo = true;
                    continue;
                }
                message = message + "   Wrong container(s) name: " + (value == null ? "null" : "empty string") + ".\n";
                isErrorInfo = true;
            }
            if (isErrorInfo) {
                JOptionPane.showMessageDialog(this.mainFrame, message, "WARNING", 2);
            }
        }
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
    }

    public void clear() {
        this.table.clearSelection();
        this.componentComboBox.setSelectedIndex(-1);
        this.containerTextField.setText("");
        this.addButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        Hashtable<String, String> newHash = null;
        String key = null;
        String value = null;
        int i = 0;
        while (i < this.tableModel.getRowCount()) {
            if (newHash == null) {
                newHash = new Hashtable<String, String>();
            }
            key = (String)this.tableModel.getValueAt(i, 0);
            value = (String)this.tableModel.getValueAt(i, 1);
            newHash.put(key, value);
            ++i;
        }
        if (this.descr != null) {
            this.descr.setAdditionalModules(newHash);
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void insertUpdate(DocumentEvent e) {
        this.setEnabledButtons();
    }

    public void removeUpdate(DocumentEvent e) {
        this.setEnabledButtons();
    }

    public void changedUpdate(DocumentEvent e) {
        this.setEnabledButtons();
    }

    public void itemStateChanged(ItemEvent e) {
        this.setEnabledButtons();
    }

    private void setEnabledButtons() {
        String copmonentEL = (String)this.componentComboBox.getSelectedItem();
        String container = this.containerTextField.getText();
        if (copmonentEL != null && !copmonentEL.trim().equals("")) {
            if (!container.trim().equals("")) {
                int row = this.table.getSelectedRow();
                if (row >= this.table.getRowCount() || row < 0) {
                    this.addButton.setEnabled(true);
                    this.modifyButton.setEnabled(false);
                } else if (copmonentEL.equals(this.tableModel.getValueAt(row, 0))) {
                    this.addButton.setEnabled(false);
                    this.modifyButton.setEnabled(true);
                } else {
                    this.table.clearSelection();
                    this.addButton.setEnabled(true);
                    this.modifyButton.setEnabled(false);
                }
                this.clearButton.setEnabled(true);
            } else {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(false);
                this.clearButton.setEnabled(true);
            }
        } else if (!container.trim().equals("")) {
            this.addButton.setEnabled(false);
            this.clearButton.setEnabled(true);
        } else {
            this.addButton.setEnabled(false);
            this.clearButton.setEnabled(false);
        }
    }
}

