/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common.additional;

import com.sap.engine.services.deploy.gui.common.ImageHolder;
import com.sap.engine.services.deploy.gui.common.additional.SecurityUserObject;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class UsersTreeRenderer
extends JLabel
implements TreeCellRenderer {
    private Icon userIcon;
    private Icon userGroup;

    public UsersTreeRenderer() {
        this.setOpaque(true);
        this.initImages();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        SecurityUserObject info = (SecurityUserObject)((DefaultMutableTreeNode)value).getUserObject();
        if (info.getType() == 9) {
            this.setIcon(this.userIcon);
        } else if (info.getType() == 10) {
            this.setIcon(this.userGroup);
        } else {
            System.out.println("WRONG TYPE : " + info.getType());
        }
        this.setText(value.toString());
        this.setBackground(selected ? UIManager.getColor("Tree.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(selected ? UIManager.getColor("Tree.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    public Dimension getPreferredSize() {
        Dimension retDimension = super.getPreferredSize();
        if (retDimension != null) {
            retDimension = new Dimension(retDimension.width + 10, retDimension.height);
        }
        return retDimension;
    }

    private void initImages() {
        this.userIcon = ImageHolder.aUserIcon;
        this.userGroup = ImageHolder.aUserGroup;
    }
}

