/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common.additional;

import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class EnvironmentTableModel
extends AbstractTableModel {
    String[] names = new String[]{GuiSettings.getResourceString("EnvProp_NameColumn", "Environment Name"), GuiSettings.getResourceString("PropType_NameColumn", "Property Type"), GuiSettings.getResourceString("EnvProp_ValueColumn", "Environment Value")};
    protected Vector properties = new Vector();
    static /* synthetic */ Class class$java$lang$String;

    public int getColumnCount() {
        return 3;
    }

    public int getRowCount() {
        return this.properties.size();
    }

    public Object getValueAt(int row, int col) {
        EnvironmentEntry entry = (EnvironmentEntry)this.properties.elementAt(row);
        String key = entry.getEntryName();
        String type = entry.getEntryType();
        Object value = entry.getEntryValue();
        switch (col) {
            case 0: {
                return key;
            }
            case 1: {
                return type;
            }
            case 2: {
                if (value != null) {
                    return value.toString();
                }
                return "";
            }
        }
        return null;
    }

    public String getColumnName(int column) {
        return this.names[column];
    }

    public Class getColumnClass(int col) {
        return class$java$lang$String == null ? (class$java$lang$String = EnvironmentTableModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int row, int col) {
        return false;
    }

    public void setValueAt(Object aValue, int row, int column) {
    }

    public EnvironmentEntry getEntry(int index) {
        return (EnvironmentEntry)this.properties.elementAt(index);
    }

    public void addRow(EnvironmentEntry entry) {
        String key = "";
        if (entry != null) {
            if (entry.getEntryName() == null || entry.getEntryName().trim().length() == 0) {
                return;
            }
            key = entry.getEntryName();
            int keyIndex = this.getIndex(key.trim());
            if (keyIndex < 0) {
                this.properties.addElement(entry);
            } else {
                this.properties.setElementAt(entry, keyIndex);
            }
        }
        this.fireTableDataChanged();
    }

    public EnvironmentEntry[] getEntries() {
        Object[] entries = null;
        if (this.properties.size() > 0) {
            entries = new EnvironmentEntry[this.properties.size()];
            this.properties.copyInto(entries);
        }
        if (entries != null) {
            int i = 0;
            while (i < entries.length) {
                if (((EnvironmentEntry)entries[i]).getEntryDescription() != null && ((EnvironmentEntry)entries[i]).getEntryDescription().trim().length() == 0) {
                    ((EnvironmentEntry)entries[i]).setEntryDescription(null);
                }
                if (((EnvironmentEntry)entries[i]).getEntryValue() != null && ((EnvironmentEntry)entries[i]).getEntryValue().toString().trim().length() == 0) {
                    ((EnvironmentEntry)entries[i]).setEntryValue(null);
                }
                ++i;
            }
        }
        return entries;
    }

    public void removeRow(int row) {
        this.properties.removeElementAt(row);
        this.fireTableDataChanged();
    }

    public int getIndex(String propName) {
        int i = 0;
        while (i < this.getRowCount()) {
            if (propName.equals((String)this.getValueAt(i, 0))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void removeAll() {
        int i = this.getRowCount() - 1;
        while (i >= 0) {
            this.removeRow(i);
            --i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

