/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.RunAsMapPanel;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import com.sap.engine.services.deploy.gui.common.additional.ListRenderer;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import com.sap.engine.services.deploy.gui.common.additional.SecurityTreeNode;
import com.sap.engine.services.deploy.gui.common.additional.SecurityTreeRenderer;
import com.sap.engine.services.security.gui.userstore.usermanagement.tree.UserTreePanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.DefaultTreeSelectionModel;

public abstract class UserMappingPanel
extends BasicPanelView
implements ActionListener,
TreeSelectionListener,
ListSelectionListener,
ChangeListener {
    public static final String ADD_CMD = "ADD_CMD";
    public static final String REMOVE_CMD = "REMOVE_CMD";
    protected SecurityTreeNode root = new SecurityTreeNode(new SecurityRoles(), 0);
    protected DefaultTreeModel model = new DefaultTreeModel(this.root);
    protected BorderLayout borderLayout1 = new BorderLayout();
    protected BorderLayout borderLayout2 = new BorderLayout();
    protected BorderLayout borderLayout3 = new BorderLayout();
    protected BorderLayout borderLayout4 = new BorderLayout();
    protected GridBagLayout gridBagLayout1 = new GridBagLayout();
    protected GridBagLayout gridBagLayout2 = new GridBagLayout();
    protected JSplitPane mainSplitPane = new JSplitPane();
    protected JPanel rolesPanel = new JPanel();
    protected JPanel identityPanel = new JPanel();
    protected JPanel buttonPanel = new JPanel();
    protected JPanel serverRolesPanel = new JPanel();
    protected JPanel radioButtonsPanel = new JPanel();
    protected JScrollPane roleScrollPane = new JScrollPane();
    protected JScrollPane selScrollPane = new JScrollPane();
    protected JScrollPane serverRoleScrollPane = new JScrollPane();
    protected RunAsMapPanel runAsPanel = new RunAsMapPanel();
    protected UserTreePanel userPanel = new UserTreePanel();
    protected JTree rolesTree = new JTree(this.model);
    protected DefaultListModel selectedModel = new DefaultListModel();
    protected DefaultListModel serverRolesModel = new DefaultListModel();
    protected JList selectedList = new JList(this.selectedModel);
    protected JList serverSecRolesList = new JList(this.serverRolesModel);
    protected JButton addButton = new JButton();
    protected JButton removeButton = new JButton();
    protected Border eatchedBorder = BorderFactory.createEtchedBorder();
    protected TitledBorder titledBorder1 = BorderFactory.createTitledBorder(this.eatchedBorder, GuiSettings.getResourceString("SecurityRoles_border", "Security Roles"));
    protected TitledBorder titledBorder2 = BorderFactory.createTitledBorder(this.eatchedBorder, GuiSettings.getResourceString("SelectedUsers_border", "Selected Users"));
    protected TitledBorder titledBorder3 = BorderFactory.createTitledBorder(this.eatchedBorder, GuiSettings.getResourceString("ServerSecRole_border", "Server Roles"));
    protected JRadioButton serverSecRoleButton = new JRadioButton("Server Security Role");
    protected JRadioButton userManagmentButton = new JRadioButton("User Security Management");
    protected ButtonGroup group = new ButtonGroup();

    public UserMappingPanel() {
        this.init();
    }

    private void init() {
        this.setLayout(this.borderLayout1);
        this.add((Component)this.mainSplitPane, "Center");
        this.initRolesPanel();
        this.mainSplitPane.add((Component)this.rolesPanel, "left");
        this.initIdentityPanel();
        this.mainSplitPane.add((Component)this.identityPanel, "right");
        this.initFields();
        this.setListeners();
    }

    private void initRolesPanel() {
        this.rolesPanel.setLayout(this.borderLayout2);
        this.rolesPanel.setBorder(this.titledBorder1);
        this.rolesPanel.setPreferredSize(new Dimension(200, 100));
        this.rolesPanel.setMinimumSize(new Dimension(150, 100));
        this.rolesPanel.add((Component)this.roleScrollPane, "Center");
        this.roleScrollPane.getViewport().add((Component)this.rolesTree, null);
        this.rolesTree.setSelectionModel(new DefaultTreeSelectionModel());
        this.rolesTree.setCellRenderer(new SecurityTreeRenderer());
        this.rolesTree.getSelectionModel().setSelectionMode(1);
    }

    private void initIdentityPanel() {
        this.identityPanel.setLayout(this.gridBagLayout1);
        this.selScrollPane.setBorder(this.titledBorder2);
        this.identityPanel.add((Component)this.selScrollPane, new GridBagConstraints(0, 0, 1, 1, 0.4, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.initButtonsPanel();
        this.identityPanel.add((Component)this.buttonPanel, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.1, 10, 3, new Insets(0, 0, 0, 0), 0, 0));
        this.initRadioButtonsPanel();
        this.identityPanel.add((Component)this.radioButtonsPanel, new GridBagConstraints(0, 1, 3, 1, 0.1, 0.0, 10, 2, new Insets(0, 0, 0, 0), 0, 0));
        this.initServerRolesPanel();
        this.identityPanel.add((Component)this.serverRolesPanel, new GridBagConstraints(2, 0, 1, 1, 0.4, 0.0, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.selScrollPane.getViewport().add((Component)this.selectedList, null);
        this.mainSplitPane.setDividerLocation(200);
        this.selectedList.setCellRenderer(new ListRenderer());
        this.selectedList.setSelectionMode(0);
    }

    private void initButtonsPanel() {
        this.buttonPanel.setLayout(this.gridBagLayout2);
        this.addButton.setText(GuiSettings.getResourceString("Left_Button", "<<"));
        this.removeButton.setText(GuiSettings.getResourceString("Right_Button", ">>"));
        this.buttonPanel.add((Component)this.addButton, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.buttonPanel.add((Component)this.removeButton, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 0, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initServerRolesPanel() {
        this.serverRolesPanel.setLayout(this.borderLayout3);
        this.serverRolesModel.removeAllElements();
        SecurityRoles temp = new SecurityRoles();
        temp.setServerRoleName("administrators");
        this.serverRolesModel.addElement(new ListValues(temp, 22));
        temp = new SecurityRoles();
        temp.setServerRoleName("guests");
        this.serverRolesModel.addElement(new ListValues(temp, 22));
        temp = new SecurityRoles();
        temp.setServerRoleName("all");
        this.serverRolesModel.addElement(new ListValues(temp, 22));
        this.serverSecRolesList.setCellRenderer(new ListRenderer());
        this.serverSecRolesList.setSelectionMode(0);
        this.serverRoleScrollPane.setBorder(this.titledBorder3);
        this.serverRoleScrollPane.getViewport().add((Component)this.serverSecRolesList, null);
        this.serverRolesPanel.add(this.serverRoleScrollPane);
    }

    private void initRadioButtonsPanel() {
        this.group.add(this.serverSecRoleButton);
        this.group.add(this.userManagmentButton);
        this.serverSecRoleButton.setSelected(true);
        this.radioButtonsPanel.add(this.serverSecRoleButton);
        this.radioButtonsPanel.add(this.userManagmentButton);
        this.serverSecRoleButton.setEnabled(false);
        this.userManagmentButton.setEnabled(false);
    }

    protected void initFields() {
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }

    private void setListeners() {
        this.selectedList.addListSelectionListener(this);
        this.rolesTree.addTreeSelectionListener(this);
        this.userPanel.addTreeSelectionListener(this);
        this.userPanel.addListSelectionListener(this);
        this.serverSecRolesList.addListSelectionListener(this);
        this.serverSecRoleButton.addChangeListener(this);
        this.userManagmentButton.addChangeListener(this);
        this.removeButton.setActionCommand(REMOVE_CMD);
        this.removeButton.addActionListener(this);
        this.addButton.setActionCommand(ADD_CMD);
        this.addButton.addActionListener(this);
    }

    public abstract void actionPerformed(ActionEvent var1);

    public abstract void valueChanged(TreeSelectionEvent var1);

    public abstract void valueChanged(ListSelectionEvent var1);

    public abstract void stateChanged(ChangeEvent var1);
}

