/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.common.RunAsIdentity;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.gui.common.BasicPanelView;
import com.sap.engine.services.deploy.gui.common.DescriptionPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class RunAsIdentityPanel
extends BasicPanelView
implements DocumentListener {
    public static final String RUN_AS_COMBO = "RUN_AS_COMBO";
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private JLabel roleNameLabel = new JLabel();
    private JComboBox roleNameComboBox = new JComboBox();
    private DescriptionPanel descrPanel = new DescriptionPanel();
    private Border eatchedBorder = BorderFactory.createEtchedBorder();
    private TitledBorder titledBorder1 = BorderFactory.createTitledBorder(this.eatchedBorder, GuiSettings.getResourceString("RunAsIdentity_PanelName", "Run As Identity"));
    private ApplicationInformationProvider appProvider;
    private RunAsIdentity runAsIdentity = null;
    private SecurityRoles[] roles = null;
    private int madeFrom;
    private boolean setText = false;

    public RunAsIdentityPanel(Frame mainFrame, int madeFrom) {
        this.init(madeFrom);
        this.setFrame(mainFrame);
        this.init();
        ((JTextField)this.roleNameComboBox.getEditor().getEditorComponent()).getDocument().addDocumentListener(this);
    }

    private void init() {
        this.setLayout(this.gridBagLayout);
        this.setBorder(this.titledBorder1);
        this.roleNameLabel.setText(GuiSettings.getResourceString("RunAsIdentity_RoleName", "Role Name:"));
        this.descrPanel.setNewBorder(GuiSettings.getResourceString("RunAsIdentityDescr_border", "Run As Identity Description"));
        this.add((Component)this.roleNameLabel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 0, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.roleNameComboBox, new GridBagConstraints(1, 0, 1, 1, 0.1, 0.0, 13, 1, new Insets(5, 5, 5, 5), 0, 0));
        this.add((Component)this.descrPanel, new GridBagConstraints(0, 1, 2, 1, 0.1, 0.1, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    private void initComboBox(String roleName) {
        this.roleNameComboBox.removeAllItems();
        this.roleNameComboBox.setEditable(true);
        this.roleNameComboBox.addItem("");
        if (roleName == null) {
            roleName = "";
        }
        if (this.roles != null) {
            String temp = null;
            int size = this.roles.length;
            int i = 0;
            while (i < size) {
                if (this.roles[i] != null) {
                    temp = this.roles[i].getRoleName();
                    this.roleNameComboBox.addItem(temp);
                }
                ++i;
            }
        }
        this.roleNameComboBox.setSelectedItem(roleName);
        this.validate();
        this.repaint();
    }

    public void setRunAsIdentity(RunAsIdentity identity) {
        if (identity == null) {
            identity = new RunAsIdentity("");
        }
        this.runAsIdentity = identity;
        String description = identity.getDescription();
        if (description != null) {
            this.descrPanel.setText(description);
        } else {
            this.descrPanel.setText("");
        }
        this.initComboBox(this.runAsIdentity.getSecurityRoleName());
    }

    public void setSecurityRoles(SecurityRoles[] roles) {
        if (roles == null) {
            roles = new SecurityRoles[]{};
        }
        this.roles = roles;
        if (this.runAsIdentity == null) {
            this.initComboBox("");
        } else {
            this.initComboBox(this.runAsIdentity.getSecurityRoleName());
        }
    }

    public RunAsIdentity getRunAsIdentity() {
        return this.runAsIdentity;
    }

    public void init(int madeFromConstant) {
        this.madeFrom = madeFromConstant;
        if (this.madeFrom == 2 || this.madeFrom == 1 || this.madeFrom == 4 || this.madeFrom == 0) {
            this.enableComponents(true);
        } else {
            this.enableComponents(false);
        }
    }

    public void clear() {
        this.runAsIdentity = new RunAsIdentity("");
        this.setText = true;
        this.roleNameComboBox.setSelectedItem("");
        this.setText = false;
        this.descrPanel.setText("");
    }

    public int isCorrect() {
        return 0;
    }

    public void commitChange() {
        String descr;
        String roleName = ((JTextField)this.roleNameComboBox.getEditor().getEditorComponent()).getText();
        if (!roleName.trim().equals(this.runAsIdentity.getSecurityRoleName())) {
            this.runAsIdentity.setSecurityRoleName(roleName);
        }
        if (!(descr = this.descrPanel.getText()).equals(this.runAsIdentity.getDescription())) {
            this.runAsIdentity.setDescription(descr);
        }
    }

    public void setLoader(ClassLoader loader) {
    }

    public void enableComponents(boolean type) {
        this.descrPanel.setEnabled(type);
        this.roleNameComboBox.setEnabled(type);
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.commitChange();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.commitChange();
        }
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.commitChange();
        }
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }
}

