/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.ResourceRefPanel;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class ResourceRefPanelLogical
extends ResourceRefPanel {
    private ResourceReference[] reference = null;
    private Vector resReference = new Vector();
    private Vector listValues = new Vector();
    private ResourceReference lastReference = null;
    private Object[] options = new Object[]{GuiSettings.getResourceString("YesOption", "Yes"), GuiSettings.getResourceString("NoOption", "No")};
    int constant;
    boolean flag;
    private boolean selectWithMouse = true;
    private boolean setText = false;
    private ApplicationInformationProvider appProvider;

    public ResourceRefPanelLogical(Frame mainFrame, boolean isClient) {
        super(isClient);
        this.mainFrame = mainFrame;
        this.disableFields();
    }

    public ResourceRefPanelLogical(Frame mainFrame, int constant, boolean isClient) {
        super(isClient);
        this.mainFrame = mainFrame;
        this.constant = constant;
        this.flag = false;
        if (constant == 1 || constant == 2 || constant == 6) {
            this.valuesPanel.remove(this.linkLabel);
            this.valuesPanel.remove(this.linkTextField);
            this.valuesPanel.remove(this.transactionalCheckBox);
        }
        this.initList(this.resReference);
        this.initComboBoxes();
        this.disableFields();
    }

    private void disableFields() {
        if (this.constant == 0) {
            this.nameTextField.setEnabled(true);
            this.typeComboBox.setEnabled(true);
            this.authorizationComboBox.setEnabled(true);
            this.shareComboBox.setEnabled(true);
            this.linkTextField.setEnabled(true);
            this.transactionalCheckBox.setEnabled(true);
            this.descrPanel.setEnabled(true);
        } else if (this.constant == 3) {
            this.nameTextField.setEnabled(false);
            this.typeComboBox.setEnabled(false);
            this.authorizationComboBox.setEnabled(false);
            this.shareComboBox.setEnabled(false);
            if (this.nameTextField.getText() != null && !this.nameTextField.getText().equals("")) {
                this.linkTextField.setEnabled(true);
                this.transactionalCheckBox.setEnabled(true);
                this.descrPanel.setEnabled(true);
            } else {
                this.linkTextField.setEnabled(false);
                this.transactionalCheckBox.setEnabled(false);
                this.descrPanel.setEnabled(false);
            }
        } else if (this.constant == 1 || this.constant == 4 || this.constant == 5 || this.constant == 6) {
            this.nameTextField.setEnabled(true);
            if (this.nameTextField.getText() != null && this.nameTextField.getText().trim().length() != 0) {
                this.typeComboBox.setEnabled(true);
                this.authorizationComboBox.setEnabled(true);
                this.shareComboBox.setEnabled(true);
                this.transactionalCheckBox.setEnabled(true);
                this.descrPanel.setEnabled(true);
            } else {
                this.typeComboBox.setEnabled(false);
                this.authorizationComboBox.setEnabled(false);
                this.shareComboBox.setEnabled(false);
                this.transactionalCheckBox.setEnabled(false);
                this.descrPanel.setEnabled(false);
            }
            if (this.constant == 1) {
                this.valuesPanel.remove(this.linkLabel);
                this.valuesPanel.remove(this.linkTextField);
                this.valuesPanel.remove(this.transactionalCheckBox);
            }
        } else if (this.constant == 2) {
            this.nameTextField.setEnabled(false);
            if (this.nameTextField.getText() != null && this.nameTextField.getText().trim().length() != 0) {
                this.typeComboBox.setEnabled(true);
                this.authorizationComboBox.setEnabled(true);
                this.shareComboBox.setEnabled(true);
                this.descrPanel.setEnabled(true);
            } else {
                this.typeComboBox.setEnabled(false);
                this.authorizationComboBox.setEnabled(false);
                this.shareComboBox.setEnabled(false);
                this.descrPanel.setEnabled(false);
            }
            this.valuesPanel.remove(this.linkLabel);
            this.valuesPanel.remove(this.linkTextField);
        }
    }

    private int convertSharing(String shareValue) {
        if (shareValue.equals(ResourceRefPanel.SHARABLE)) {
            return 0;
        }
        if (shareValue.equals(ResourceRefPanel.UNSHARABLE)) {
            return 1;
        }
        return 0;
    }

    private String convertSharing(int shareValue) {
        if (shareValue == 0) {
            return ResourceRefPanel.SHARABLE;
        }
        if (shareValue == 1) {
            return ResourceRefPanel.UNSHARABLE;
        }
        return ResourceRefPanel.SHARABLE;
    }

    public void valueChanged(ListSelectionEvent e) {
        this.disableFields();
        if (this.constant == 3 || this.constant == 2) {
            this.modifyButton.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.removeButton.setEnabled(false);
        } else {
            this.modifyButton.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
        if (!this.selectWithMouse) {
            if (this.resourceList.getSelectedValue() != null) {
                this.lastReference = ((ListValues)this.resourceList.getSelectedValue()).getResourceReference();
                this.initFields(this.lastReference);
            } else {
                this.clearAll();
            }
            return;
        }
        if (!this.resourceList.isSelectionEmpty()) {
            this.flag = true;
            ResourceReference currentReference = new ResourceReference();
            if (this.lastReference == null) {
                this.lastReference = ((ListValues)this.resourceList.getSelectedValue()).getResourceReference();
                this.initFields(this.lastReference);
            } else {
                if (this.lastReference.equals(((ListValues)this.resourceList.getSelectedValue()).getResourceReference())) {
                    return;
                }
                if (this.lastReference != null && this.lastReference.getResourceName().equals(this.nameTextField.getText())) {
                    int result;
                    currentReference = new ResourceReference(this.nameTextField.getText().trim(), (String)this.typeComboBox.getSelectedItem(), this.linkTextField.getText().trim().equals("") ? null : this.linkTextField.getText().trim(), this.getType((String)this.authorizationComboBox.getSelectedItem()));
                    currentReference.setResourceSharingScope(this.convertSharing((String)this.shareComboBox.getSelectedItem()));
                    currentReference.setTransactional(this.transactionalCheckBox.isSelected());
                    currentReference.setResourceDescription(this.descrPanel.getText().equals("") ? null : this.descrPanel.getText());
                    if (!this.lastReference.equals(currentReference) && (result = JOptionPane.showOptionDialog(this.mainFrame, GuiSettings.getResourceString("ChangesMessage", "You have made changes at Resource Reference:") + " " + currentReference.getResourceName() + " " + GuiSettings.getResourceString("QuestionMessage", "do you want to save them? "), "Warning", -1, 2, null, this.options, this.options[0])) == 0) {
                        this.lastReference.setResourceType((String)this.typeComboBox.getSelectedItem());
                        this.lastReference.setResourceAuthorization(this.getType((String)this.authorizationComboBox.getSelectedItem()));
                        this.lastReference.setResourceSharingScope(this.convertSharing((String)this.shareComboBox.getSelectedItem()));
                        this.lastReference.setResourceLink(this.linkTextField.getText().trim().equals("") ? null : this.linkTextField.getText().trim());
                        this.lastReference.setTransactional(this.transactionalCheckBox.isSelected());
                        this.lastReference.setResourceDescription(this.descrPanel.getText().equals("") ? null : this.descrPanel.getText());
                        ResourceReference temp = null;
                        int i = 0;
                        while (i < this.resReference.size()) {
                            temp = (ResourceReference)this.resReference.elementAt(i);
                            if (temp.getResourceName().equals(this.lastReference.getResourceName())) {
                                this.resReference.setElementAt(this.lastReference, i);
                                if (this.lastReference.getResourceType().trim().equals("javax.sql.DataSource")) {
                                    ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(7);
                                    break;
                                }
                                if (this.lastReference.getResourceType().trim().equals("javax.jms.QueueConnectionFactory")) {
                                    ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(8);
                                    break;
                                }
                                if (this.lastReference.getResourceType().trim().equals("javax.jms.TopicConnectionFactory")) {
                                    ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(9);
                                    break;
                                }
                                if (this.lastReference.getResourceType().trim().equals("javax.mail.Session")) {
                                    ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(10);
                                    break;
                                }
                                if (this.lastReference.getResourceType().trim().equals("javax.resource.cci.ConnectionFactory")) {
                                    ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(12);
                                    break;
                                }
                                if (!this.lastReference.getResourceType().trim().equals("java.net.URL")) break;
                                ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(13);
                                break;
                            }
                            ++i;
                        }
                    }
                }
                this.lastReference = ((ListValues)this.resourceList.getSelectedValue()).getResourceReference();
                this.initFields(this.lastReference);
            }
            this.disableFields();
        } else {
            this.clearAll();
            this.lastReference = null;
        }
    }

    private void initFields(ResourceReference resourceRef) {
        if (resourceRef != null) {
            if (this.selectWithMouse) {
                this.setText = true;
                this.nameTextField.setText(resourceRef.getResourceName());
                this.setText = false;
            }
            this.typeComboBox.setSelectedItem(resourceRef.getResourceType());
            this.authorizationComboBox.setSelectedItem(this.chooseType(resourceRef.getResourceAuthorization()));
            this.shareComboBox.setSelectedItem(this.convertSharing(resourceRef.getResourceSharingScope()));
            this.linkTextField.setText(resourceRef.getResourceLink());
            this.transactionalCheckBox.setSelected(resourceRef.isTransactional());
            this.descrPanel.setText(resourceRef.getResourceDescription());
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addActionPerformed();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyActionPerformed();
        }
        if (cmd.equals("REMOVE_CMD")) {
            this.removeActionPerformed();
        } else {
            this.clearActionPerformed();
        }
        this.clearAll();
    }

    private void initList(Vector resReference1) {
        this.listValues = new Vector();
        if (resReference1 != null && resReference1.size() != 0) {
            int i = 0;
            while (i < resReference1.size()) {
                if (((ResourceReference)resReference1.elementAt(i)).getResourceType().trim().equals("javax.sql.DataSource")) {
                    this.listValues.addElement(new ListValues((ResourceReference)resReference1.elementAt(i), 7));
                } else if (((ResourceReference)resReference1.elementAt(i)).getResourceType().trim().equals("javax.jms.QueueConnectionFactory")) {
                    this.listValues.addElement(new ListValues((ResourceReference)resReference1.elementAt(i), 8));
                } else if (((ResourceReference)resReference1.elementAt(i)).getResourceType().trim().equals("javax.jms.TopicConnectionFactory")) {
                    this.listValues.addElement(new ListValues((ResourceReference)resReference1.elementAt(i), 9));
                } else if (((ResourceReference)resReference1.elementAt(i)).getResourceType().trim().equals("javax.mail.Session")) {
                    this.listValues.addElement(new ListValues((ResourceReference)resReference1.elementAt(i), 10));
                } else if (((ResourceReference)resReference1.elementAt(i)).getResourceType().trim().equals("javax.resource.cci.ConnectionFactory")) {
                    this.listValues.addElement(new ListValues((ResourceReference)resReference1.elementAt(i), 12));
                } else if (((ResourceReference)resReference1.elementAt(i)).getResourceType().trim().equals("java.net.URL")) {
                    this.listValues.addElement(new ListValues((ResourceReference)resReference1.elementAt(i), 13));
                }
                ++i;
            }
        }
        this.resourceList.setListData(this.listValues);
    }

    private void initComboBoxes() {
        if (this.resReference.size() != 0) {
            int i = 0;
            while (i < this.resReference.size()) {
                if (((ResourceReference)this.resReference.elementAt(i)).getResourceAuthorization() == 3) {
                    this.authorizationComboBox.setSelectedIndex(0);
                } else {
                    this.authorizationComboBox.setSelectedIndex(1);
                }
                ++i;
            }
        }
    }

    public void modifyActionPerformed() {
        this.addActionPerformed();
    }

    public void addActionPerformed() {
        ResourceReference newResource = new ResourceReference();
        ResourceReference reference = null;
        Vector currentValues = new Vector();
        newResource.setResourceName(this.nameTextField.getText().trim());
        newResource.setResourceAuthorization(this.getType((String)this.authorizationComboBox.getSelectedItem()));
        newResource.setResourceType((String)this.typeComboBox.getSelectedItem());
        newResource.setResourceSharingScope(this.convertSharing((String)this.shareComboBox.getSelectedItem()));
        if (this.linkTextField.getText().trim().equals("")) {
            newResource.setResourceLink(null);
        } else {
            newResource.setResourceLink(this.linkTextField.getText().trim());
        }
        newResource.setTransactional(this.transactionalCheckBox.isSelected());
        if (this.descrPanel.getText().equals("")) {
            newResource.setResourceDescription(null);
        } else {
            newResource.setResourceDescription(this.descrPanel.getText());
        }
        ListModel model = this.resourceList.getModel();
        int size = model.getSize();
        int i = 0;
        while (i < size) {
            currentValues.addElement(model.getElementAt(i));
            ++i;
        }
        boolean toAdd = true;
        int i2 = 0;
        while (i2 < currentValues.size()) {
            if (newResource.getResourceName().equals(((ListValues)currentValues.elementAt(i2)).getResourceReference().getResourceName())) {
                toAdd = false;
            }
            ++i2;
        }
        if (toAdd) {
            this.resReference.addElement(newResource);
            this.initList(this.resReference);
        } else if (!this.resourceList.isSelectionEmpty()) {
            reference = ((ListValues)this.resourceList.getSelectedValue()).getResourceReference();
            this.addAction(reference);
            ((ListValues)this.resourceList.getSelectedValue()).setResourceReference(reference);
        }
    }

    private void addAction(ResourceReference ref) {
        block29: {
            Vector currentValues = new Vector();
            if (ref == null) break block29;
            if (ref.getResourceName().equals(this.nameTextField.getText().trim())) {
                ref.setResourceType((String)this.typeComboBox.getSelectedItem());
                ref.setResourceAuthorization(this.getType((String)this.authorizationComboBox.getSelectedItem()));
                ref.setResourceSharingScope(this.convertSharing((String)this.shareComboBox.getSelectedItem()));
                ref.setResourceLink(this.linkTextField.getText().trim().equals("") ? null : this.linkTextField.getText().trim());
                ref.setTransactional(this.transactionalCheckBox.isSelected());
                ref.setResourceDescription(this.descrPanel.getText().equals("") ? null : this.descrPanel.getText());
                ResourceReference temp = null;
                int i = 0;
                while (i < this.resReference.size()) {
                    temp = (ResourceReference)this.resReference.elementAt(i);
                    if (temp.getResourceName().equals(ref.getResourceName())) {
                        this.resReference.setElementAt(ref, i);
                        if (this.lastReference.getResourceType().trim().equals("javax.sql.DataSource")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(7);
                        } else if (this.lastReference.getResourceType().trim().equals("javax.jms.QueueConnectionFactory")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(8);
                        } else if (this.lastReference.getResourceType().trim().equals("javax.jms.TopicConnectionFactory")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(9);
                        } else if (this.lastReference.getResourceType().trim().equals("javax.mail.Session")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(10);
                        } else if (this.lastReference.getResourceType().trim().equals("javax.resource.cci.ConnectionFactory")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(12);
                        } else if (this.lastReference.getResourceType().trim().equals("java.net.URL")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i)).setType(13);
                        }
                        this.repaint();
                        this.validate();
                        break;
                    }
                    ++i;
                }
            } else {
                ListModel model = this.resourceList.getModel();
                int size = model.getSize();
                int i = 0;
                while (i < size) {
                    currentValues.addElement(model.getElementAt(i));
                    ++i;
                }
                ResourceReference current = null;
                int i2 = 0;
                while (i2 < currentValues.size()) {
                    current = ((ListValues)currentValues.elementAt(i2)).getResourceReference();
                    if (current.getResourceName().equals(this.nameTextField.getText().trim())) {
                        int result = JOptionPane.showOptionDialog(this.mainFrame, GuiSettings.getResourceString("ReplaceResourceMessage", "Do you really want to replace the Resource Reference") + " " + this.nameTextField.getText(), "Warning", -1, 2, null, this.options, this.options[0]);
                        if (result != 0) break;
                        ref.setResourceType((String)this.typeComboBox.getSelectedItem());
                        ref.setResourceAuthorization(this.getType((String)this.authorizationComboBox.getSelectedItem()));
                        ref.setResourceSharingScope(this.convertSharing((String)this.shareComboBox.getSelectedItem()));
                        ref.setResourceLink(this.linkTextField.getText().trim().equals("") ? null : this.linkTextField.getText().trim());
                        ref.setTransactional(this.transactionalCheckBox.isSelected());
                        ref.setResourceDescription(this.descrPanel.getText().equals("") ? null : this.descrPanel.getText());
                        this.resReference.setElementAt(ref, i2);
                        if (this.lastReference.getResourceType().trim().equals("javax.sql.DataSource")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i2)).setType(7);
                        } else if (this.lastReference.getResourceType().trim().equals("javax.jms.QueueConnectionFactory")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i2)).setType(8);
                        } else if (this.lastReference.getResourceType().trim().equals("javax.jms.TopicConnectionFactory")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i2)).setType(9);
                        } else if (this.lastReference.getResourceType().trim().equals("javax.mail.Session")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i2)).setType(10);
                        } else if (this.lastReference.getResourceType().trim().equals("javax.resource.cci.ConnectionFactory")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i2)).setType(12);
                        } else if (this.lastReference.getResourceType().trim().equals("java.net.URL")) {
                            ((ListValues)this.resourceList.getModel().getElementAt(i2)).setType(13);
                        }
                        this.repaint();
                        this.validate();
                        break;
                    }
                    ++i2;
                }
            }
        }
    }

    public void removeActionPerformed() {
        ResourceReference reference = null;
        if (!this.resourceList.isSelectionEmpty()) {
            reference = ((ListValues)this.resourceList.getSelectedValue()).getResourceReference();
            this.resReference.removeElement(reference);
            this.initList(this.resReference);
        }
    }

    public void clearActionPerformed() {
        this.clearAll();
        this.lastReference = null;
    }

    private void clearAll() {
        if (this.selectWithMouse) {
            this.setText = true;
            this.nameTextField.setText("");
            this.setText = false;
        }
        this.authorizationComboBox.setSelectedIndex(0);
        this.typeComboBox.setSelectedIndex(0);
        this.shareComboBox.setSelectedIndex(0);
        this.linkTextField.setText("");
        this.transactionalCheckBox.setSelected(true);
        this.descrPanel.setText("");
        this.resourceList.clearSelection();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
    }

    private int getType(String typeName) {
        int number = 0;
        if (typeName.equals("Application")) {
            number = 3;
        } else if (typeName.equals("Servlet")) {
            number = 1;
        } else if (typeName.equals("Container")) {
            number = 2;
        }
        return number;
    }

    private String chooseType(int number) {
        String type = "";
        if (number == 3) {
            type = "Application";
        } else if (number == 1) {
            type = "Servlet";
        } else if (number == 2) {
            type = "Container";
        }
        return type;
    }

    private void checkDisabled() {
        String refName = this.nameTextField.getText();
        if (refName.equals("")) {
            this.clear();
            this.disableFields();
            return;
        }
        if (!refName.trim().equals("")) {
            this.disableFields();
        } else {
            this.disableFields();
        }
        this.selectWithMouse = false;
        Vector currentValues = new Vector();
        ListModel model = this.resourceList.getModel();
        int size = model.getSize();
        int i = 0;
        while (i < size) {
            currentValues.addElement(model.getElementAt(i));
            ++i;
        }
        boolean toAdd = true;
        this.resourceList.clearSelection();
        int i2 = 0;
        while (i2 < currentValues.size()) {
            if (refName.equals(((ListValues)currentValues.elementAt(i2)).getResourceReference().getResourceName())) {
                toAdd = false;
                this.resourceList.setSelectedValue(currentValues.elementAt(i2), true);
                break;
            }
            ++i2;
        }
        if (refName.trim().length() != 0) {
            if (toAdd) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(true);
                this.clearButton.setEnabled(true);
                if (this.constant != 3 && this.constant != 2) {
                    this.removeButton.setEnabled(true);
                }
            }
        } else {
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        this.selectWithMouse = true;
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void setDescriptor(ResourceReference[] rReference) {
        this.flag = false;
        this.disableFields();
        this.reference = null;
        this.resReference = new Vector();
        this.listValues = new Vector();
        this.lastReference = null;
        this.clearAll();
        this.reference = rReference;
        if (rReference != null) {
            int i = 0;
            while (i < rReference.length) {
                if (!this.resReference.contains(rReference[i])) {
                    this.resReference.addElement(rReference[i]);
                }
                ++i;
            }
        }
        this.initList(this.resReference);
        this.initComboBoxes();
        this.checkDisabled();
    }

    public void commitChange() {
        if (this.resReference.size() > 0) {
            this.reference = new ResourceReference[this.resReference.size()];
            this.resReference.copyInto(this.reference);
        } else {
            this.reference = null;
        }
    }

    public int isCorrect() {
        return 0;
    }

    public void init(int madeFromConstant) {
        this.constant = madeFromConstant;
    }

    public void clear() {
        this.clearAll();
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI(this);
        this.descrPanel.updateLook_Feel();
    }

    public void setLoader(ClassLoader loader) {
    }

    public ResourceReference[] getReference() {
        return this.reference != null && this.reference.length == 0 ? null : this.reference;
    }

    public void setReference(ResourceReference[] reference) {
        this.reference = reference;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }
}

