/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.gui.common.EnvironmentPanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.GuiSettings;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.ListModel;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class EnvironmentPanelLogical
extends EnvironmentPanel {
    private EnvironmentEntry[] envEntryReference = null;
    private EnvironmentEntry lastEntry = null;
    private Vector listValues = new Vector();
    private Vector envEntryRef = new Vector();
    int constant;
    private boolean selectWithMouse = true;
    private boolean setText = false;
    private ApplicationInformationProvider appProvider;

    public EnvironmentPanelLogical() {
    }

    public EnvironmentPanelLogical(Frame mainFrame, int constant) {
        this.mainFrame = mainFrame;
        this.constant = constant;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("REMOVE_CMD")) {
            this.deleteBtnActionPerformed();
        } else if (cmd.equals("CLEAR_CMD")) {
            this.clearBtnActionPerformed();
        } else if (cmd.equals("ADD_CMD")) {
            this.setBtnActionPerformed();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyBTNActionPerformed();
        }
        this.clearAll();
    }

    public void valueChanged(ListSelectionEvent e) {
        this.checkEnable();
        if (this.constant == 3 || this.constant == 2) {
            this.modifyButton.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.removeButton.setEnabled(false);
        } else {
            this.modifyButton.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.removeButton.setEnabled(true);
        }
        if (!this.selectWithMouse) {
            if (this.referenceList.getSelectedValue() != null) {
                this.lastEntry = ((ListValues)this.referenceList.getSelectedValue()).getEnvironmentEntry();
                this.initFields(this.lastEntry);
            } else {
                this.clearAll();
            }
            return;
        }
        if (!this.referenceList.isSelectionEmpty()) {
            EnvironmentEntry tempEntry = new EnvironmentEntry();
            if (this.lastEntry == null) {
                this.lastEntry = ((ListValues)this.referenceList.getSelectedValue()).getEnvironmentEntry();
                this.initFields(this.lastEntry);
            } else if (this.lastEntry != null && this.lastEntry.getEntryName().equals(this.nameTextField.getText())) {
                if (this.nameTextField.getText() != null && !this.nameTextField.getText().trim().equals("")) {
                    tempEntry.setEntryName(this.nameTextField.getText().trim());
                } else {
                    tempEntry.setEntryName(null);
                }
                tempEntry.setEntryType((String)this.typeComboBox.getSelectedItem());
                if (this.valueTextField.getText() != null && !this.valueTextField.getText().trim().equals("")) {
                    tempEntry.setEntryValue(this.getPropertyValue((String)this.typeComboBox.getSelectedItem()));
                } else {
                    tempEntry.setEntryValue(null);
                }
                if (this.descrPanel.getText() == null || this.descrPanel.getText().trim().equals("")) {
                    tempEntry.setEntryDescription(null);
                } else {
                    tempEntry.setEntryDescription(this.descrPanel.getText());
                }
                if (!this.lastEntry.equals(tempEntry)) {
                    Object[] options = new Object[]{GuiSettings.getResourceString("YesOption", "Yes"), GuiSettings.getResourceString("NoOption", "No")};
                    int result = JOptionPane.showOptionDialog(this.mainFrame, GuiSettings.getResourceString("EJBeanRefChangesMsg", "The EJB reference") + " " + this.lastEntry.getEntryName() + " " + GuiSettings.getResourceString("CommitChangesMsg", "has changed. Do you want to commit these changes?"), "Warning", -1, 2, null, options, options[0]);
                    if (result == 0) {
                        this.lastEntry.setEntryType((String)this.typeComboBox.getSelectedItem());
                        if (this.valueTextField.getText() != null && !this.valueTextField.getText().trim().equals("")) {
                            this.lastEntry.setEntryValue(this.getPropertyValue((String)this.typeComboBox.getSelectedItem()));
                        } else {
                            this.lastEntry.setEntryValue(null);
                        }
                        if (this.descrPanel.getText() != null) {
                            this.lastEntry.setEntryDescription(this.descrPanel.getText().trim().equals("") ? null : this.descrPanel.getText().trim());
                        } else {
                            this.lastEntry.setEntryDescription(null);
                        }
                        EnvironmentEntry temp = null;
                        int i = 0;
                        while (i < this.envEntryRef.size()) {
                            temp = (EnvironmentEntry)this.envEntryRef.elementAt(i);
                            if (temp.getEntryName().equals(this.lastEntry.getEntryName())) {
                                ((ListValues)this.referenceList.getModel().getElementAt(i)).setType(14);
                                this.envEntryRef.setElementAt(this.lastEntry, i);
                                break;
                            }
                            ++i;
                        }
                    }
                }
            }
            this.lastEntry = ((ListValues)this.referenceList.getSelectedValue()).getEnvironmentEntry();
            this.initFields(this.lastEntry);
        } else {
            this.clearAll();
        }
    }

    public void keyPressed(KeyEvent e) {
        int code = e.getKeyCode();
        if (this.nameTextField.getText().trim().equals("")) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
        if (code == 10) {
            this.setBtnActionPerformed();
        }
    }

    public void keyTyped(KeyEvent e) {
    }

    public void keyReleased(KeyEvent e) {
        int code = e.getKeyCode();
        if (this.nameTextField.getText().trim().equals("")) {
            this.addButton.setEnabled(false);
        } else {
            this.addButton.setEnabled(true);
        }
        if (code == 10) {
            this.setBtnActionPerformed();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object getPropertyValue(String entryType) {
        String value = null;
        String temp = this.valueTextField.getText().trim();
        if (entryType == null) {
            return null;
        }
        if (temp.startsWith("${")) {
            return new String(temp);
        }
        if (entryType.equals("java.lang.String")) {
            return new String(temp);
        }
        if (entryType.equals("java.lang.Boolean")) {
            if (temp.equals("")) {
                return null;
            }
            if (temp.equalsIgnoreCase("true") || temp.equalsIgnoreCase("false")) {
                if (temp.equalsIgnoreCase("true")) {
                    return new Boolean("true");
                }
                if (!temp.equalsIgnoreCase("false")) return value;
                return new Boolean("false");
            }
            JOptionPane.showMessageDialog(this.mainFrame, GuiSettings.getResourceString("TrueOrFalseValueMsg", "You must enter boolean values - true or false!"), "Error", 2);
            this.valueTextField.setText("");
            return null;
        }
        if (entryType.equals("java.lang.Integer")) {
            if (temp.equals("")) {
                return null;
            }
            try {
                return Integer.valueOf(temp);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.mainFrame, GuiSettings.getResourceString("LegalIntegerValuesMsg", "You must enter legal integer value between") + " " + Integer.MIN_VALUE + " " + GuiSettings.getResourceString("AndMsg", "and") + " " + Integer.MAX_VALUE + "!", "Error", 2);
                this.valueTextField.setText("");
                return null;
            }
        }
        if (entryType.equals("java.lang.Float")) {
            if (temp.equals("")) {
                return null;
            }
            try {
                return Float.valueOf(temp);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.mainFrame, GuiSettings.getResourceString("LegalFloatValueMsg", "You must enter legal float value between") + Float.MIN_VALUE + " " + GuiSettings.getResourceString("AndMsg", "and") + Float.MAX_VALUE + "!", "Error", 2);
                this.valueTextField.setText("");
                return null;
            }
        }
        if (entryType.equals("java.lang.Double")) {
            if (temp.equals("")) {
                return null;
            }
            try {
                return Double.valueOf(temp);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.mainFrame, GuiSettings.getResourceString("LegalDoubleValueMsg", "You must enter legal double value between") + " " + Double.MIN_VALUE + " " + GuiSettings.getResourceString("AndMsg", "and") + Double.MAX_VALUE + "!", "Error", 2);
                this.valueTextField.setText("");
                return null;
            }
        }
        if (entryType.equals("java.lang.Long")) {
            if (temp.equals("")) {
                return null;
            }
            try {
                return Long.valueOf(temp);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.mainFrame, GuiSettings.getResourceString("LegalLongValueMsg", "You must enter legal long value between") + " " + Long.MIN_VALUE + " " + GuiSettings.getResourceString("AndMsg", "and") + Long.MAX_VALUE + "!", "Error", 2);
                this.valueTextField.setText("");
                return null;
            }
        }
        if (entryType.equals("java.lang.Short")) {
            if (temp.equals("")) {
                return null;
            }
            try {
                return Short.valueOf(temp);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.mainFrame, GuiSettings.getResourceString("LegalShortValueMsg", "You must enter legal short value between") + " " + Short.MIN_VALUE + " " + GuiSettings.getResourceString("AndMsg", "and") + Short.MAX_VALUE + "!", "Error", 2);
                this.valueTextField.setText("");
                return null;
            }
        }
        if (entryType.equals("java.lang.Byte")) {
            if (temp.equals("")) {
                return null;
            }
            try {
                return Byte.valueOf(temp);
            }
            catch (NumberFormatException ex) {
                JOptionPane.showMessageDialog(this.mainFrame, GuiSettings.getResourceString("LegalByteValueMsg", "You must enter legal byte value between") + " " + -128 + " " + GuiSettings.getResourceString("AndMsg", "and") + 127 + "!", "Error", 2);
                this.valueTextField.setText("");
                return null;
            }
        }
        if (!entryType.equals("java.lang.Character")) return value;
        if (temp.equals("")) {
            return null;
        }
        try {
            if (temp.toCharArray().length > 1) throw new NumberFormatException("You must enter legal character value!");
            return new Character(temp.toCharArray()[0]);
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this.mainFrame, GuiSettings.getResourceString("LegalCharacterValueMsg", "You must enter legal character value between") + " " + '\u0000' + " " + GuiSettings.getResourceString("AndMsg", "and") + '\uffff' + "!", "Error", 2);
            this.valueTextField.setText("");
            return null;
        }
    }

    public void deleteBtnActionPerformed() {
        EnvironmentEntry reference = null;
        if (!this.referenceList.isSelectionEmpty()) {
            reference = ((ListValues)this.referenceList.getSelectedValue()).getEnvironmentEntry();
            this.envEntryRef.removeElement(reference);
            this.initList(this.envEntryRef);
        }
    }

    public void clearBtnActionPerformed() {
        this.clearAll();
    }

    public void modifyBTNActionPerformed() {
        this.setBtnActionPerformed();
    }

    public void setBtnActionPerformed() {
        EnvironmentEntry newEntry = new EnvironmentEntry();
        EnvironmentEntry entry = null;
        Vector currentValues = new Vector();
        if (this.nameTextField.getText() != null && !this.nameTextField.getText().trim().equals("")) {
            newEntry.setEntryName(this.nameTextField.getText().trim());
        } else {
            newEntry.setEntryName(null);
        }
        newEntry.setEntryType((String)this.typeComboBox.getSelectedItem());
        if (this.valueTextField.getText() != null && !this.valueTextField.getText().trim().equals("")) {
            newEntry.setEntryValue(this.getPropertyValue((String)this.typeComboBox.getSelectedItem()));
        } else {
            newEntry.setEntryValue(null);
        }
        if (this.descrPanel.getText() == null || this.descrPanel.getText().trim().equals("")) {
            newEntry.setEntryDescription(null);
        } else {
            newEntry.setEntryDescription(this.descrPanel.getText().trim());
        }
        ListModel model = this.referenceList.getModel();
        int size = model.getSize();
        int i = 0;
        while (i < size) {
            currentValues.addElement(model.getElementAt(i));
            ++i;
        }
        boolean toAdd = true;
        int i2 = 0;
        while (i2 < currentValues.size()) {
            if (newEntry.getEntryName().equals(((ListValues)currentValues.elementAt(i2)).getEnvironmentEntry().getEntryName())) {
                toAdd = false;
                break;
            }
            ++i2;
        }
        if (toAdd) {
            this.envEntryRef.addElement(newEntry);
            this.initList(this.envEntryRef);
        } else {
            entry = ((ListValues)this.referenceList.getSelectedValue()).getEnvironmentEntry();
            this.addAction(entry);
            ((ListValues)this.referenceList.getSelectedValue()).setEnvironmentEntry(entry);
        }
    }

    private void addAction(EnvironmentEntry entry) {
        Vector currentValues = new Vector();
        if (entry.getEntryName().equals(this.nameTextField.getText().trim())) {
            entry.setEntryType((String)this.typeComboBox.getSelectedItem());
            if (this.valueTextField.getText() != null && !this.valueTextField.getText().trim().equals("")) {
                entry.setEntryValue(this.getPropertyValue((String)this.typeComboBox.getSelectedItem()));
            } else {
                entry.setEntryValue(null);
            }
            if (this.descrPanel.getText() != null) {
                entry.setEntryDescription(this.descrPanel.getText().trim().equals("") ? null : this.descrPanel.getText().trim());
            } else {
                entry.setEntryDescription(null);
            }
            EnvironmentEntry temp = null;
            int i = 0;
            while (i < this.envEntryRef.size()) {
                temp = (EnvironmentEntry)this.envEntryRef.elementAt(i);
                if (temp.getEntryName().equals(entry.getEntryName())) {
                    this.envEntryRef.setElementAt(entry, i);
                    ((ListValues)this.referenceList.getModel().getElementAt(i)).setType(14);
                    this.repaint();
                    this.validate();
                    break;
                }
                ++i;
            }
        } else {
            ListModel model = this.referenceList.getModel();
            int size = model.getSize();
            int i = 0;
            while (i < size) {
                currentValues.addElement(model.getElementAt(i));
                ++i;
            }
            EnvironmentEntry current = null;
            int i2 = 0;
            while (i2 < currentValues.size()) {
                current = ((ListValues)currentValues.elementAt(i2)).getEnvironmentEntry();
                if (current.getEntryName().equals(this.nameTextField.getText().trim())) {
                    Object[] options = new Object[]{GuiSettings.getResourceString("YesOption", "Yes"), GuiSettings.getResourceString("NoOption", "No")};
                    int result = JOptionPane.showOptionDialog(this.mainFrame, GuiSettings.getResourceString("ReplaceEntryMessage", "Do you really want to replace the EnvironmentEntry") + " " + this.nameTextField.getText(), "Warning", -1, 2, null, options, options[0]);
                    if (result != 0) break;
                    entry.setEntryType((String)this.typeComboBox.getSelectedItem());
                    if (this.valueTextField.getText() != null && !this.valueTextField.getText().trim().equals("")) {
                        entry.setEntryValue(this.getPropertyValue((String)this.typeComboBox.getSelectedItem()));
                    } else {
                        entry.setEntryValue(null);
                    }
                    if (this.descrPanel.getText() != null) {
                        entry.setEntryDescription(this.descrPanel.getText().trim().equals("") ? null : this.descrPanel.getText().trim());
                    } else {
                        entry.setEntryDescription(null);
                    }
                    ((ListValues)this.referenceList.getModel().getElementAt(i2)).setType(14);
                    this.repaint();
                    this.validate();
                    this.envEntryRef.setElementAt(entry, i2);
                    break;
                }
                ++i2;
            }
        }
    }

    private void initFields(EnvironmentEntry entry) {
        if (this.selectWithMouse) {
            this.setText = true;
            this.nameTextField.setText(entry.getEntryName());
            this.setText = false;
        }
        this.typeComboBox.setSelectedItem(entry.getEntryType());
        if (entry.getEntryValue() != null) {
            this.valueTextField.setText(entry.getEntryValue().toString());
        } else {
            this.valueTextField.setText(null);
        }
        this.descrPanel.setText(entry.getEntryDescription());
    }

    public void commitChange() {
        if (this.envEntryRef.size() > 0) {
            this.envEntryReference = new EnvironmentEntry[this.envEntryRef.size()];
            this.envEntryRef.copyInto(this.envEntryReference);
        } else {
            this.envEntryReference = null;
        }
    }

    public void checkEnable() {
        if (this.constant == 1 || this.constant == 4 || this.constant == 5 || this.constant == 6) {
            this.nameTextField.setEnabled(true);
            if (this.nameTextField.getText() != null && this.nameTextField.getText().trim().length() != 0) {
                this.valueTextField.setEnabled(true);
                this.typeComboBox.setEnabled(true);
                this.descrPanel.setEnabled(true);
            } else {
                this.valueTextField.setEnabled(false);
                this.typeComboBox.setEnabled(false);
                this.descrPanel.setEnabled(false);
            }
        } else if (this.constant == 2 || this.constant == 3) {
            this.nameTextField.setEnabled(false);
            this.typeComboBox.setEnabled(false);
            if (this.nameTextField.getText() != null && this.nameTextField.getText().trim().length() != 0) {
                this.valueTextField.setEnabled(true);
                this.descrPanel.setEnabled(true);
            } else {
                this.valueTextField.setEnabled(false);
                this.descrPanel.setEnabled(false);
            }
        }
    }

    public void init(int madeFromConstant) {
        this.constant = madeFromConstant;
    }

    public int isCorrect() {
        return 0;
    }

    public EnvironmentEntry[] getDescriptor() {
        return this.envEntryReference;
    }

    public void setDescriptor(EnvironmentEntry[] entries) {
        this.envEntryReference = null;
        this.lastEntry = null;
        this.envEntryRef = new Vector();
        this.listValues = new Vector();
        this.referenceList.setListData(this.listValues);
        this.clearAll();
        this.envEntryReference = entries;
        if (this.envEntryReference != null) {
            int i = 0;
            while (i < this.envEntryReference.length) {
                this.envEntryRef.addElement(this.envEntryReference[i]);
                ++i;
            }
        }
        this.initList(this.envEntryRef);
    }

    private void clearAll() {
        if (this.selectWithMouse) {
            this.setText = true;
            this.nameTextField.setText("");
            this.setText = false;
        }
        this.typeComboBox.setSelectedIndex(0);
        this.valueTextField.setText("");
        this.descrPanel.setText("");
        this.referenceList.clearSelection();
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.checkEnable();
    }

    private void checkDisabled() {
        String entryName = this.nameTextField.getText();
        if (entryName.equals("")) {
            this.clear();
            this.checkEnable();
            return;
        }
        if (!entryName.trim().equals("")) {
            this.checkEnable();
        } else {
            this.checkEnable();
        }
        this.selectWithMouse = false;
        Vector currentValues = new Vector();
        ListModel model = this.referenceList.getModel();
        int size = model.getSize();
        int i = 0;
        while (i < size) {
            currentValues.addElement(model.getElementAt(i));
            ++i;
        }
        boolean toAdd = true;
        this.referenceList.clearSelection();
        int i2 = 0;
        while (i2 < currentValues.size()) {
            if (entryName.equals(((ListValues)currentValues.elementAt(i2)).getEnvironmentEntry().getEntryName())) {
                toAdd = false;
                this.referenceList.setSelectedValue(currentValues.elementAt(i2), true);
                break;
            }
            ++i2;
        }
        if (entryName.trim().length() != 0) {
            if (toAdd) {
                this.addButton.setEnabled(true);
                this.modifyButton.setEnabled(false);
                this.clearButton.setEnabled(true);
                this.removeButton.setEnabled(false);
            } else {
                this.addButton.setEnabled(false);
                this.modifyButton.setEnabled(true);
                this.clearButton.setEnabled(true);
                if (this.constant != 3 && this.constant != 2) {
                    this.removeButton.setEnabled(true);
                }
            }
        } else {
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(false);
            this.clearButton.setEnabled(false);
            this.removeButton.setEnabled(false);
        }
        this.selectWithMouse = true;
    }

    public void changedUpdate(DocumentEvent event) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void insertUpdate(DocumentEvent event) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    public void removeUpdate(DocumentEvent event) {
        if (!this.setText) {
            this.checkDisabled();
        }
    }

    private void initList(Vector envEntry) {
        this.listValues = new Vector();
        if (envEntry != null && envEntry.size() != 0) {
            int i = 0;
            while (i < envEntry.size()) {
                this.listValues.addElement(new ListValues((EnvironmentEntry)envEntry.elementAt(i), 14));
                ++i;
            }
        }
        this.referenceList.setListData(this.listValues);
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI(this);
        this.descrPanel.updateLook_Feel();
    }

    public void clear() {
        this.clearAll();
    }

    public void setLoader(ClassLoader loader) {
    }

    public EnvironmentEntry[] getEnvEntryReference() {
        return this.envEntryReference != null && this.envEntryReference.length == 0 ? null : this.envEntryReference;
    }

    public void setEnvEntryReference(EnvironmentEntry[] envEntryReference) {
        this.envEntryReference = envEntryReference;
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }
}

