/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui.common;

import com.sap.engine.deploy.tool.ApplicationInformationProvider;
import com.sap.engine.services.deploy.ear.common.ComponentReference;
import com.sap.engine.services.deploy.gui.common.ComponentReferencePanel;
import com.sap.engine.services.deploy.gui.common.ErrorReportObject;
import com.sap.engine.services.deploy.gui.common.additional.ListValues;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentEvent;
import javax.swing.event.ListSelectionEvent;

public class ComponentReferencePanelLogical
extends ComponentReferencePanel {
    private boolean isRemoving = false;
    private ComponentReference[] reference = null;
    private ClassLoader class_loader = null;
    private int constant;
    private boolean flag;
    private ApplicationInformationProvider appProvider;

    public ComponentReferencePanelLogical(Frame mainFrame, int constant) {
        super(constant);
        this.constant = constant;
        this.clearAll();
        this.mainFrame = mainFrame;
        this.flag = false;
    }

    private void disableFields() {
        this.nameTextField.setEnabled(true);
        this.typeCombo.setEnabled(true);
        this.jndiCombo.setEnabled(true);
        this.descrPanel.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.modifyButton.setEnabled(true);
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(true);
    }

    public void valueChanged(ListSelectionEvent e) {
        if (this.isRemoving) {
            return;
        }
        if (!this.inCheckDisabled) {
            this.checPanel();
        }
        if (!this.referencesList.isSelectionEmpty()) {
            this.modifyButton.setEnabled(true);
            this.clearButton.setEnabled(true);
            this.removeButton.setEnabled(true);
            this.addButton.setEnabled(false);
            this.typeCombo.setEnabled(true);
            this.jndiCombo.setEnabled(true);
            this.descrPanel.setEnabled(true);
            this.show((ListValues)this.referencesList.getSelectedValue());
        } else {
            this.clearAll();
        }
    }

    private void show(ListValues listValue) {
        if (!this.inCheckDisabled || !this.nameTextField.getText().trim().equals(listValue.getComponentReference().getName())) {
            this.setNameText = true;
            this.nameTextField.setText(listValue.getComponentReference().getName());
            this.setNameText = false;
        }
        this.typeCombo.setSelectedIndex(listValue.getComponentReference().getType() == 1 ? 1 : 0);
        String jndiName = listValue.getComponentReference().getJndiName();
        if (jndiName == null) {
            ((JTextField)this.jndiCombo.getEditor().getEditorComponent()).setText("");
        } else {
            ((JTextField)this.jndiCombo.getEditor().getEditorComponent()).setText(jndiName.trim());
        }
        String description = listValue.getComponentReference().getDescription();
        if (description == null) {
            this.descrPanel.setText("");
        } else {
            this.descrPanel.setText(description.trim());
        }
    }

    private ComponentReference getValueAt(int index) {
        Vector currentValues = new Vector();
        ComponentReference value = null;
        int size = this.model.getSize();
        int i = 0;
        while (i < size) {
            currentValues.addElement(this.model.getElementAt(i));
            ++i;
        }
        if (currentValues.size() != 0 && index > -1 && index < currentValues.size()) {
            value = ((ListValues)currentValues.elementAt(index)).getComponentReference();
        }
        return value;
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ADD_CMD")) {
            this.addActionPerformed();
        } else if (cmd.equals("MODIFY_CMD")) {
            this.modifyActionPerformed();
        } else if (cmd.equals("REMOVE_CMD")) {
            this.isRemoving = true;
            this.removeActionPerformed();
            this.isRemoving = false;
        } else {
            this.clearActionPerformed();
        }
    }

    private void modifyActionPerformed() {
        boolean answer = true;
        ListValues value = this.findCompRef(this.nameTextField.getText().trim());
        ComponentReference ref = value.getComponentReference();
        this.modifyActionPerformed(ref, this.typeCombo.getSelectedIndex(), ((JTextField)this.jndiCombo.getEditor().getEditorComponent()).getText().trim(), this.descrPanel.getText().trim());
    }

    private void modifyActionPerformed(ComponentReference ref, int type, String jndi, String descr) {
        ref.setType(type);
        if (!descr.equals("")) {
            ref.setDescription(descr);
        } else {
            ref.setDescription(null);
        }
        if (!jndi.equals("")) {
            ref.setJndiName(jndi);
        } else {
            ref.setJndiName(null);
        }
        this.modifyAction = true;
        this.clearActionPerformed();
        this.modifyAction = false;
    }

    private void addActionPerformed() {
        ComponentReference ref = new ComponentReference();
        ref.setName(this.nameTextField.getText().trim());
        ref.setType(this.typeCombo.getSelectedIndex());
        ref.setJndiName(((JTextField)this.jndiCombo.getEditor().getEditorComponent()).getText().trim().equals("") ? null : ((JTextField)this.jndiCombo.getEditor().getEditorComponent()).getText().trim());
        ref.setDescription(this.descrPanel.getText().equals("") ? null : this.descrPanel.getText());
        this.model.addElement(new ListValues(ref, 19));
        this.clearActionPerformed();
    }

    public void removeActionPerformed() {
        ListValues value = this.findCompRef(this.nameTextField.getText().trim());
        this.model.removeElement(value);
        this.clearActionPerformed();
    }

    public void clearActionPerformed() {
        if (!this.referencesList.isSelectionEmpty()) {
            this.referencesList.clearSelection();
        }
        this.clearAll();
    }

    private ListValues findCompRef(String name) {
        int size = this.model.size();
        int i = 0;
        while (i < size) {
            if (name.equals(((ListValues)this.model.get(i)).getName().trim())) {
                return (ListValues)this.model.get(i);
            }
            ++i;
        }
        return null;
    }

    private void checPanel() {
        String name = this.nameTextField.getText().trim();
        int type = this.typeCombo.getSelectedIndex();
        if (!name.equals("")) {
            String description = this.descrPanel.getText().trim();
            String jndi = ((JTextField)this.jndiCombo.getEditor().getEditorComponent()).getText().trim();
            ListValues ref = this.findCompRef(name);
            int answer = 1;
            if (ref != null) {
                ComponentReference compRef = ref.getComponentReference();
                if (!description.equals(compRef.getDescription() == null ? "" : compRef.getDescription()) || type != compRef.getType() || !jndi.equals(compRef.getJndiName() == null ? "" : compRef.getJndiName())) {
                    answer = JOptionPane.showConfirmDialog(this.mainFrame, "The Server Component Reference <" + name + "> has changed.\n Would you like to modify it?", "Warning", 0, 2);
                    if (answer == 0) {
                        this.modifyActionPerformed(ref.getComponentReference(), type, jndi, description);
                    } else {
                        this.clearAll();
                    }
                }
            } else {
                answer = JOptionPane.showConfirmDialog(this.mainFrame, "There is new Server Component Reference <" + name + "> described.\n Would you like to add it?", "Warning", 0, 2);
                if (answer == 0) {
                    this.addActionPerformed();
                } else {
                    this.clearAll();
                }
            }
        }
    }

    private void checkDisabled() {
        String refName;
        this.inCheckDisabled = true;
        if (!this.referencesList.isSelectionEmpty()) {
            this.referencesList.clearSelection();
        }
        if ((refName = this.nameTextField.getText().trim()).equals("")) {
            this.clearAll();
            return;
        }
        ListValues value = this.findCompRef(refName);
        this.init(this.constant);
        this.clearButton.setEnabled(true);
        if (value == null) {
            this.addButton.setEnabled(true);
            this.modifyButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            this.descrPanel.setEnabled(true);
        } else {
            this.referencesList.setSelectedValue(value, true);
            this.addButton.setEnabled(false);
            this.modifyButton.setEnabled(true);
        }
        this.inCheckDisabled = false;
    }

    public void changedUpdate(DocumentEvent e) {
        if (!this.setNameText) {
            this.checkDisabled();
        }
    }

    public void insertUpdate(DocumentEvent e) {
        if (!this.setNameText) {
            this.checkDisabled();
        }
    }

    public void removeUpdate(DocumentEvent e) {
        if (!this.setNameText) {
            this.checkDisabled();
        }
    }

    public void setDescriptor(ComponentReference[] cReference) {
        this.clear();
        this.flag = false;
        this.disableFields();
        this.clearAll();
        this.reference = cReference;
        int size = -1;
        if (this.reference != null && (size = this.reference.length) != 0) {
            int i = 0;
            while (i < size) {
                this.model.addElement(new ListValues(this.reference[i], 19));
                ++i;
            }
        }
    }

    public void commitChange() {
        this.reference = new ComponentReference[this.model.getSize()];
        Enumeration enumeration = this.model.elements();
        if (enumeration != null) {
            int size = 0;
            while (enumeration.hasMoreElements()) {
                this.reference[size] = ((ListValues)enumeration.nextElement()).getComponentReference();
                ++size;
            }
        } else {
            this.reference = null;
        }
    }

    public int isCorrect() {
        return 0;
    }

    public void init(int madeFromConstant) {
        this.constant = madeFromConstant;
        this.nameTextField.setEnabled(true);
        this.typeCombo.setEnabled(true);
        this.jndiCombo.setEnabled(true);
        this.removeButton.setEnabled(true);
    }

    public void clear() {
        this.clearAll();
        this.model.removeAllElements();
    }

    public void updateLook_Feel() {
        SwingUtilities.updateComponentTreeUI(this);
        this.descrPanel.updateLook_Feel();
    }

    public void setLoader(ClassLoader loader) {
        this.class_loader = loader;
    }

    public ComponentReference[] getComponentReference() {
        return this.reference != null && this.reference.length == 0 ? null : this.reference;
    }

    public void setComponentReference(ComponentReference[] reference) {
        this.reference = reference;
    }

    public void setApplicationInformationProvider(ApplicationInformationProvider appProvider) {
        this.appProvider = appProvider;
    }

    public void proccessErrors(ErrorReportObject errObj) {
    }

    public ErrorReportObject getErrorObject() {
        return new ErrorReportObject();
    }

    public ApplicationInformationProvider getApplicationInformationProvider() {
        return this.appProvider;
    }

    protected void clearAll() {
        if (!this.inCheckDisabled || this.modifyAction) {
            this.setNameText = true;
            this.nameTextField.setText("");
            this.setNameText = false;
        }
        this.typeCombo.setSelectedIndex(0);
        ((JTextField)this.jndiCombo.getEditor().getEditorComponent()).setText("");
        this.descrPanel.setText("");
        this.nameTextField.setEnabled(true);
        this.typeCombo.setEnabled(false);
        this.jndiCombo.setEnabled(false);
        this.descrPanel.setEnabled(false);
        this.clearButton.setEnabled(false);
        this.modifyButton.setEnabled(false);
        this.addButton.setEnabled(false);
        this.removeButton.setEnabled(false);
    }
}

