/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui;

import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.services.deploy.DeployRuntimeControlInterface;
import com.sap.engine.services.deploy.container.FileUpdateInfo;
import com.sap.engine.services.deploy.gui.DeployRuntimeView;
import com.sap.engine.services.file.FileTransfer;
import com.sap.engine.services.file.RemoteFile;
import java.io.File;
import java.io.IOException;
import java.util.Properties;

public class FileUpdatingTask
implements Runnable,
TaskItem {
    private DeployRuntimeControlInterface deploy;
    private FileUpdateInfo[] files;
    private String appName;
    private String name = "Single File Update";
    private String message = "";
    private int status;
    private double progress;

    public FileUpdatingTask(DeployRuntimeControlInterface drci, FileUpdateInfo[] files, String applicationName) {
        this.appName = applicationName;
        this.files = files;
        this.deploy = drci;
        this.status = 1;
    }

    public void run() {
        try {
            long beginTime = System.currentTimeMillis();
            FileTransfer transferer = this.deploy.getFileTransferer();
            RemoteFile remoteF = null;
            String file = null;
            String destinationDir = "./temp/deploy/work/singleUpdate/" + this.appName + "/";
            int i = 0;
            while (i < this.files.length) {
                file = destinationDir + new File(this.files[i].getFileName()).getName();
                remoteF = transferer.createRemoteFile(this.files[i].getFileName(), file);
                remoteF.upload();
                this.files[i].setRemoteFileName(file);
                ++i;
            }
            this.deploy.singleFileUpdate(this.files, this.appName, new Properties());
            long endTime = System.currentTimeMillis();
            this.message = this.message + "Update successfully file(s) of " + this.appName + " in " + (endTime - beginTime) + " ms!\n";
            this.finished();
        }
        catch (IOException ioe) {
            DeployRuntimeView.logThrowableT(500, "Unexpected exception.", ioe);
            this.status = 2;
            this.message = this.message + "Update of file(s) of " + this.appName + " failed, because :\n" + ioe.toString();
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAdditionalInfo() {
        DeployRuntimeView.logT(100, this.message);
        return this.message;
    }

    public void addAdditionalInfo(String message, int status) {
        if (this.message != null && this.message.indexOf(message) == -1) {
            this.message = this.message + message + "\n";
        }
        this.status = status;
    }

    public int getProgress() {
        if (this.progress >= 100.0) {
            this.status = 0;
        } else {
            this.calculate();
        }
        return (int)this.progress;
    }

    private void calculate() {
        double step = (100.0 - this.progress) / 100.0;
        this.progress += step;
    }

    public int getStatus() {
        return this.status;
    }

    public void finished() {
        this.progress = 100.0;
    }
}

