/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui;

import com.sap.engine.interfaces.visual_administration.TaskItem;
import com.sap.engine.services.deploy.DeployRuntimeControlInterface;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.gui.DeployRuntimeView;
import java.io.File;
import java.io.IOException;
import java.rmi.RemoteException;

public class DeployingTask
implements Runnable,
TaskItem {
    private DeployRuntimeControlInterface deploy;
    private String message = "";
    private String path;
    private String[] servers;
    private String[] support;
    private String appName = null;
    protected double progress;
    protected int status;
    protected String name;
    protected boolean isOneInstPerPK = true;
    protected boolean isUpdate = false;
    protected boolean postStart = false;
    private long beginTime = 0L;
    private long endTime = 0L;

    public DeployingTask() {
        this(1, 0, "");
    }

    public DeployingTask(int status, int progress, String name) {
        this.name = name;
        this.status = status;
        this.progress = progress;
    }

    public DeployingTask(DeployRuntimeControlInterface deploy, String earPath, String[] serverNames, String[] support) {
        this(1, 0, "Deploy  ");
        this.deploy = deploy;
        this.path = earPath;
        this.servers = serverNames;
        this.support = support;
    }

    public DeployingTask(DeployRuntimeControlInterface deploy, String earPath, String[] serverNames, String[] support, boolean _isOneInstPerPK, boolean _isUpdate) {
        this(1, 0, "Deploy  ");
        this.deploy = deploy;
        this.path = earPath;
        this.servers = serverNames;
        this.support = support;
        this.isOneInstPerPK = _isOneInstPerPK;
        this.isUpdate = _isUpdate;
    }

    public DeployingTask(DeployRuntimeControlInterface deploy, String earPath, String[] serverNames, String[] support, boolean _isOneInstPerPK, boolean _isUpdate, boolean _postStart, String _appName) throws IllegalArgumentException {
        this(deploy, earPath, serverNames, support, _isOneInstPerPK, _isUpdate);
        this.postStart = _postStart;
        this.appName = _appName;
        if (this.postStart && this.appName == null) {
            throw new IllegalArgumentException("Illegal arguments: postStart and appName!");
        }
    }

    /*
     * Unable to fully structure code
     */
    public void run() {
        block13: {
            earName = new File(this.path).getName();
            res = null;
            this.beginTime = System.currentTimeMillis();
            try {
                block12: {
                    transferer = null;
                    remoteF = null;
                    serverEarName = "./temp/deploy/work/deploying/" + earName;
                    transferer = this.deploy.getFileTransferer();
                    remoteF = transferer.createRemoteFile(this.path, serverEarName);
                    try {
                        remoteF.upload();
                    }
                    catch (IOException ioe) {
                        DeployRuntimeView.logThrowableT(500, "Unexpected exception.", ioe);
                        this.status = 2;
                        this.message = this.isUpdate != false ? this.message + "Update of the ear has errors :\n" + ioe.toString() + "\n" : ioe.toString() + "\n";
                        return;
                    }
                    try {
                        res = this.deploy.deploy(serverEarName, this.servers, this.support, (byte)1, this.isOneInstPerPK, this.isUpdate);
                        break block12;
                    }
                    catch (WarningException we) {
                        warns = we.getWarnings();
                        res = we.getResult();
                        if (warns == null) break block12;
                        this.message = this.isUpdate != false ? this.message + "Update of the ear has warnings :\n" : this.message + "Deploy of the ear has warnings :\n";
                        i = 0;
                        ** while (i < warns.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        this.message = this.message + "   " + warns[i] + "\n";
                        ++i;
                        continue;
                    }
lbl31:
                    // 1 sources

                    DeployRuntimeView.logT(400, "Operation {0} finished with {1} {2}", new Object[]{this.postStart != false ? "Deploy & Start" : "Deploy", "warnings", "\n" + this.message});
                }
                if (res != null) {
                    i = 0;
                    while (i < res.length) {
                        this.message = this.message + res[i] + "\n";
                        ++i;
                    }
                }
                counter = 0;
                if (!this.postStart) break block13;
                this.deploy.startApplication(this.appName);
                while (!this.deploy.getApplicationStatus(this.appName).equalsIgnoreCase("STARTED")) {
                    try {
                        Thread.currentThread();
                        Thread.sleep(2000L);
                    }
                    catch (InterruptedException ie) {
                        DeployRuntimeView.logThrowableT(500, "Unexpected exception.", ie);
                    }
                    if (++counter < 20) continue;
                    this.message = this.message + "Application was deployed but hasn't been started yet.\n";
                    break;
                }
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, "Unexpected exception.", re);
                this.status = 2;
                this.message = this.isUpdate != false ? this.message + "Update of the ear has errors :\n" + re.toString() + "\n" : this.message + "Deploy of the ear has errors :\n" + re.toString() + "\n";
                return;
            }
        }
        this.endTime = System.currentTimeMillis();
        this.message = this.isUpdate != false ? this.message + "Update of the ear finished successfully in " + (this.endTime - this.beginTime) + " ms!\n" : this.message + "Deploy of the ear finished successfully in " + (this.endTime - this.beginTime) + " ms!\n";
        this.finished();
    }

    public String getAdditionalInfo() {
        DeployRuntimeView.logT(100, this.message);
        return this.message;
    }

    public void addAdditionalInfo(String message, int status) {
        if (this.message != null && this.message.indexOf(message) == -1) {
            this.message = this.message + message + "\n";
        }
        this.status = status;
    }

    public int getStatus() {
        return this.status;
    }

    public void setTitle(String title) {
        this.name = title;
    }

    public void finished() {
        this.progress = 100.0;
    }

    public int getProgress() {
        if (this.progress >= 100.0) {
            this.status = 0;
        } else {
            this.calculate();
        }
        return (int)this.progress;
    }

    protected void calculate() {
        double step = (100.0 - this.progress) / 100.0;
        this.progress += step;
    }

    public String getTitle() {
        return this.name;
    }

    public String getName() {
        return this.name;
    }
}

