/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.visual_administration.EditorViewManager;
import com.sap.engine.interfaces.visual_administration.VisualRuntimeControl;
import com.sap.engine.services.deploy.DeployCallbackImpl;
import com.sap.engine.services.deploy.DeployRuntimeControlInterface;
import com.sap.engine.services.deploy.gui.ApplicationsPanel;
import com.sap.engine.services.deploy.gui.DeployListenerImpl;
import com.sap.tc.logging.Location;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.rmi.Remote;
import java.rmi.RemoteException;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;

public class DeployRuntimeView
extends JPanel
implements VisualRuntimeControl,
Runnable {
    private Frame frame = null;
    private ApplicationsPanel appPanel = null;
    private JTabbedPane pane = null;
    private DeployRuntimeControlInterface dri = null;
    private DeployCallbackImpl callback = null;
    private static final String DEPLOY_LOCATION = "com.sap.engine.services.deploy.gui";
    private static final Location LOCATION = Location.getLocation((String)"com.sap.engine.services.deploy.gui");
    public static EditorViewManager manager = null;
    public static final String CANNOT_GET = "Cannot get {0}.";
    public static final String OPERATION_FINISHED = "Operation {0} finished with {1} {2}";
    public static final String UNEXPECTED_EXCEPTION = "Unexpected exception.";

    public DeployRuntimeView() {
        this.init();
    }

    private void init() {
        this.pane = new JTabbedPane();
        this.pane.setTabPlacement(3);
        this.appPanel = new ApplicationsPanel();
        this.pane.add("Applications", this.appPanel);
        this.setLayout(new BorderLayout());
        this.add((Component)this.pane, "Center");
        SystemProperties.setProperty("javax.xml.parsers.DocumentBuilderFactory", "com.sap.engine.lib.jaxp.DocumentBuilderFactoryImpl");
        SystemProperties.setProperty("javax.xml.transform.TransformerFactory", "com.sap.engine.lib.jaxp.TransformerFactoryImpl");
    }

    public JComponent getRuntimeControlComponent() {
        return this;
    }

    public JMenu getRuntimeMenu() {
        return null;
    }

    public JButton[] getRuntimeButtons() {
        return null;
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
        this.appPanel.setFrame(frame);
    }

    public void freeResources() {
        this.appPanel.freeResources();
        if (this.callback != null) {
            try {
                this.dri.unregisterDeployCallback(this.callback, null);
            }
            catch (RemoteException re) {
                DeployRuntimeView.logThrowableT(500, UNEXPECTED_EXCEPTION, re);
                JOptionPane.showMessageDialog(this.frame, "Error:" + re.toString(), "Error", 0);
            }
        }
    }

    public void setTaskManager(EditorViewManager _manager) {
        manager = _manager;
    }

    public void show(ManagementInterface ri) {
        this.dri = (DeployRuntimeControlInterface)ri;
        this.callback = new DeployCallbackImpl();
        this.callback.addDeployListener(new DeployListenerImpl(this.dri, this.appPanel));
        Thread register = new Thread(this);
        register.start();
        this.appPanel.show((Remote)((Object)ri));
    }

    public void setEnvironment(String editorToolName, Object environment) {
        if (!editorToolName.equals("SAPJ2EEEngineVisualAdministrator")) {
            throw new RuntimeException("These properties of the editor are supported only in SAP J2EE Engine Administrator!");
        }
    }

    public void run() {
        try {
            this.dri.registerDeployCallback(this.callback, null);
        }
        catch (RemoteException re) {
            DeployRuntimeView.logThrowableT(500, UNEXPECTED_EXCEPTION, re);
            JOptionPane.showMessageDialog(this.frame, "Error:" + re.toString(), "Error", 0);
        }
    }

    public static void logT(int i, String s) {
        if (LOCATION != null) {
            if (manager != null) {
                EditorViewManager.category.logT(i, LOCATION, s);
            } else {
                LOCATION.logT(i, s);
            }
        }
    }

    public static void logT(int i, String s, Object[] objects) {
        if (LOCATION != null) {
            if (manager != null) {
                EditorViewManager.category.logT(i, LOCATION, s, objects);
            } else {
                LOCATION.logT(i, s, objects);
            }
        }
    }

    public static void logThrowableT(int i, String s, Throwable t) {
        if (LOCATION != null) {
            if (manager != null) {
                EditorViewManager.category.logThrowableT(i, LOCATION, s, t);
            } else {
                LOCATION.traceThrowableT(i, s, t);
            }
        }
    }

    public static void logThrowableT(int i, String s, Object[] objects, Throwable t) {
        if (LOCATION != null) {
            if (manager != null) {
                EditorViewManager.category.logThrowableT(i, LOCATION, s, objects, t);
            } else {
                LOCATION.traceThrowableT(i, s, objects, t);
            }
        }
    }
}

