/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.gui;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.gui.CFileChooser;
import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.deploy.converter.EARConverter;
import com.sap.engine.services.deploy.exceptions.BaseEarException;
import com.sap.engine.services.deploy.gui.DeployDialog;
import com.sap.engine.services.deploy.gui.DeployRuntimeView;
import com.sap.engine.services.deploy.gui.runtime.EarDialog;
import com.sap.engine.services.security.remote.RemoteSecurity;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import javax.swing.JOptionPane;

public class DeployDialogLogical
extends DeployDialog {
    Frame frame = null;
    CFileChooser chooser;
    private static EarDialog dialog;
    boolean isOk = false;
    RemoteSecurity node = null;
    Vector servVector = null;
    Vector suppVector = null;
    private String earName = null;
    File tmpDir = new File("." + File.separator + "temp" + File.separator + "deploying");
    String tempEar = null;
    boolean checkAppExistence = true;
    StringWriter strWr = new StringWriter();

    public DeployDialogLogical(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        this.frame = frame;
        this.tempDirTextField.setText(this.tmpDir.getPath());
    }

    public void actionPerformed(ActionEvent e) {
        if (e.getActionCommand() == "OK") {
            this.okButtonAction();
        } else if (e.getActionCommand() == "CANCEL") {
            this.cancelButtonAction();
        } else if (e.getActionCommand() == "...") {
            this.cButtonAction();
        } else if (e.getActionCommand() == "TEMP_DIR") {
            this.cTempDirButtonAction();
        }
    }

    public boolean isCorrect() {
        if (this.fileTextField.getText().equals("") || this.fileTextField.getText() == null) {
            JOptionPane.showMessageDialog(this.frame, "File name must not by empty!", "Error", 2);
            return false;
        }
        return true;
    }

    public String getFileName() {
        return this.earName;
    }

    public String getOnlyName() {
        String name = this.fileTextField.getText();
        int index = name.lastIndexOf(File.separator);
        if (index > 0) {
            name = name.substring(index);
        }
        return name;
    }

    public void initSuppList(String[] names) {
        if (this.suppVector == null) {
            this.suppVector = new Vector();
        } else {
            this.suppVector.removeAllElements();
        }
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.suppVector.add(names[i]);
                ++i;
            }
        }
        this.suppList.setListData(this.suppVector);
    }

    public void initServList(String[] names) {
        if (this.servVector == null) {
            this.servVector = new Vector();
        } else {
            this.servVector.removeAllElements();
        }
        if (names != null) {
            int i = 0;
            while (i < names.length) {
                this.servVector.add(names[i]);
                ++i;
            }
        }
        this.servList.setListData(this.servVector);
    }

    public String[] getListSuppData() {
        if (this.suppVector == null || this.suppVector.size() == 0) {
            return null;
        }
        Object[] res = new String[this.suppVector.size()];
        this.suppVector.copyInto(res);
        return res;
    }

    public String[] getListServData() {
        if (this.servVector == null || this.servVector.size() == 0) {
            return null;
        }
        Object[] res = new String[this.servVector.size()];
        this.servVector.copyInto(res);
        return res;
    }

    public void setRemoteSecurity(RemoteSecurity root) {
        this.node = root;
    }

    public void setCheckAppVisible(boolean state) {
        this.checkAppExistence = state;
    }

    public boolean isOK() {
        return this.isOk;
    }

    private void okButtonAction() {
        this.strWr = new StringWriter();
        if (this.isCorrect()) {
            this.earName = this.fileTextField.getText().trim();
            this.tempEar = null;
            String newEar = new File(this.earName).getName();
            if (this.tmpDir.exists()) {
                try {
                    String message = "The directory \"" + this.tmpDir.getCanonicalPath() + "\"\n" + "will be used for extracting the EAR file. The directory content will be deleted.\n" + "Please backup all useful information from it.";
                    JOptionPane.showMessageDialog(this.frame, message, "WARNING", 2);
                    FileUtils.deleteDirectory(this.tmpDir);
                }
                catch (IOException ioe) {
                    DeployRuntimeView.logThrowableT(500, "Unexpected exception.", ioe);
                    ioe.printStackTrace(new PrintWriter(this.strWr));
                    JOptionPane.showMessageDialog(this.frame, "An I/O error occurs, while getting the canonical path.", "Error", 0);
                }
            }
            if (!this.tmpDir.exists()) {
                this.tmpDir.mkdirs();
            }
            newEar = new File(this.tmpDir, newEar).getAbsolutePath();
            try {
                EARConverter conv = new EARConverter();
                conv.convert(this.earName, newEar);
                Vector warn = conv.getWarnings();
                if (warn != null && warn.size() > 0) {
                    JOptionPane.showMessageDialog(this.frame, "Ear " + this.earName + " was converted with warnings:\n " + warn.toString(), "Warning", 2);
                }
                if (new File(newEar).exists()) {
                    this.earName = newEar;
                    this.tempEar = newEar;
                }
            }
            catch (BaseEarException bex) {
                try {
                    FileUtils.copyFile(new File(this.earName), new File(newEar));
                }
                catch (IOException ex) {
                    DeployRuntimeView.logThrowableT(500, "Unexpected exception.", ex);
                    ex.printStackTrace(new PrintWriter(this.strWr));
                    JOptionPane.showMessageDialog(this.frame, "Can not copy " + this.earName + " to " + newEar + ".", "ERROR", 0);
                    return;
                }
                this.earName = newEar;
            }
            catch (Exception e) {
                DeployRuntimeView.logThrowableT(500, "Unexpected exception.", e);
                e.printStackTrace(new PrintWriter(this.strWr));
                JOptionPane.showMessageDialog(this.frame, "Can not convert ear file.\nCheck Visual Admin log for details.", "ERROR", 0);
                return;
            }
            ((Component)this).setVisible(false);
            if (dialog == null) {
                dialog = new EarDialog(this.frame);
            }
            dialog.setName(this.earName);
            dialog.setAddClassPath(this.getStringFromVector(this.pathPanel.getClassPath()));
            dialog.setCheckAppVisible(this.checkAppExistence);
            try {
                dialog.setEar();
            }
            catch (IOException ex) {
                DeployRuntimeView.logThrowableT(500, "Unexpected exception.", ex);
                ex.printStackTrace(new PrintWriter(this.strWr));
                JOptionPane.showMessageDialog(this.frame, "Incorrect Ear File " + ex.getMessage(), "Error ", -1);
                this.isOk = false;
                return;
            }
            ((Component)dialog).setSize(650, 500);
            dialog.setLocationRelativeTo(this.frame);
            dialog.setRemoteSecurity(this.node);
            dialog.show();
            this.isOk = dialog.isOK();
        }
    }

    private void cancelButtonAction() {
        this.isOk = false;
        ((Component)this).setVisible(false);
    }

    private void cButtonAction() {
        this.strWr = new StringWriter();
        this.chooser = new CFileChooser(this.frame);
        this.chooser.addFileFilter("EAR Files ", ".ear");
        String[] fileName = this.chooser.showFileDialog("Choose ear file", false);
        if (fileName != null && fileName.length != 0) {
            this.fileTextField.setText(fileName[0]);
        }
    }

    private void cTempDirButtonAction() {
        this.chooser = new CFileChooser(this.frame);
        String[] dirName = this.chooser.showDirDialog("Choose ear file", false, SystemProperties.getProperty("user.dir"));
        if (dirName != null && dirName.length != 0) {
            this.tempDirTextField.setText(dirName[0]);
            this.tmpDir = new File(dirName[0]);
        }
    }

    public boolean getContanerType() {
        if (dialog == null) {
            return true;
        }
        return dialog.getContainerType();
    }

    public void deleteTempFiles() {
        FileUtils.deleteDirectory(this.tmpDir);
        dialog.deleteTampFiles();
    }

    public String getAppName() {
        return dialog.getAppName();
    }

    public boolean isAppExistingChecked() {
        return dialog.isFerifying();
    }

    public void showDialog(String[] allServers, String[] allSupports) {
        this.fileTextField.setText("");
        this.pathPanel.setClasspath(new String[0]);
        this.initServList(allServers);
        this.initSuppList(allSupports);
        ((Component)this).setSize(550, 510);
        this.setLocationRelativeTo(this.frame);
        ((Component)this).setVisible(true);
    }

    protected void performEnterAction(KeyEvent e) {
        this.okButtonAction();
    }

    protected void performEscapeAction(KeyEvent e) {
        this.cancelButtonAction();
    }

    public void setFrame(Frame frame) {
        this.frame = frame;
    }

    private String getStringFromVector(Vector vec) {
        String str = "";
        int i = 0;
        while (i < vec.size()) {
            str = str + (String)vec.elementAt(i) + ";";
            ++i;
        }
        return str;
    }

    public String getErrors() {
        return this.strWr.toString();
    }
}

