/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.xml;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.ear.J2EEModule;
import com.sap.engine.services.deploy.ear.SimpleEarDescriptor;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ExtendedEARDescriptorWriter {
    Document doc;
    public static final String dtd = "<!DOCTYPE application [\n<!ELEMENT application (icon?, display-name, description?, module+, security-role*)>\n<!ATTLIST application id ID #IMPLIED>\n<!ELEMENT icon (small-icon?, large-icon?)>\n<!ATTLIST icon id ID #IMPLIED>\n<!ELEMENT small-icon (#PCDATA)>\n<!ATTLIST small-icon id ID #IMPLIED>\n<!ELEMENT large-icon (#PCDATA)>\n<!ATTLIST large-icon id ID #IMPLIED>\n<!ELEMENT display-name (#PCDATA)>\n<!ATTLIST display-name id ID #IMPLIED>\n<!ELEMENT description (#PCDATA)>\n<!ATTLIST description id ID #IMPLIED>\n<!ELEMENT module ((ejb | java | web | service | other), alt-dd?)>\n<!ATTLIST module id ID #IMPLIED>\n<!ELEMENT ejb (#PCDATA)>\n<!ATTLIST ejb id ID #IMPLIED>\n<!ELEMENT java (#PCDATA)>\n<!ATTLIST java id ID #IMPLIED>\n<!ELEMENT web (web-uri, context-root)>\n<!ATTLIST web id ID #IMPLIED>\n<!ELEMENT web-uri (#PCDATA)>\n<!ATTLIST web-uri id ID #IMPLIED>\n<!ELEMENT context-root (#PCDATA)>\n<!ATTLIST context-root id ID #IMPLIED>\n<!ELEMENT service (#PCDATA)>\n<!ATTLIST service id ID #IMPLIED>\n<!ELEMENT alt-dd (#PCDATA)>\n<!ATTLIST alt-dd id ID #IMPLIED>\n<!ELEMENT security-role (description?, role-name)>\n<!ATTLIST security-role id ID #IMPLIED>\n<!ELEMENT role-name (#PCDATA)>\n<!ATTLIST role-name id ID #IMPLIED>\n]>";

    public Element loadElement(SimpleEarDescriptor descr) {
        Element docElement = this.doc.createElement("application");
        if (descr.getSmallIcon() != null && descr.getLargeIcon() != null) {
            this.loadIcons(docElement, descr.getSmallIcon().getFileName(), descr.getLargeIcon().getFileName());
        }
        this.loadDisplayName(docElement, descr.getDisplayName());
        this.loadDescription(docElement, descr.getDescription());
        this.loadModules(docElement, descr.getModules());
        this.loadSecurityRoles(docElement, descr.getRoles());
        return docElement;
    }

    public Document loadDocument(SimpleEarDescriptor descr) {
        this.doc = StandardDOMParser.createDocument();
        this.doc.appendChild(this.loadElement(descr));
        return this.doc;
    }

    private void loadIcons(Element el, String small, String large) {
        if (small == null && large == null) {
            return;
        }
        Element iconElement = this.createElement(el, "icon");
        if (small != null) {
            Element smElement = this.createSimpleElement(iconElement, "small-icon", small);
        }
        if (large != null) {
            Element largeElement = this.createSimpleElement(iconElement, "large-icon", large);
        }
    }

    private void loadDisplayName(Element el, String name) {
        this.createSimpleElement(el, "display-name", name);
    }

    private void loadDescription(Element el, String descr) {
        if (descr != null) {
            this.createSimpleElement(el, "description", descr);
        }
    }

    private void loadModules(Element el, J2EEModule[] modules) {
        int i = 0;
        while (i < modules.length) {
            this.loadModule(el, modules[i]);
            ++i;
        }
    }

    private void loadModule(Element el, J2EEModule module) {
        int type = module.getType();
        Element modElement = this.createElement(el, "module");
        switch (type) {
            case 1: {
                this.createSimpleElement(modElement, "ejb", module.getUri());
                break;
            }
            case 3: {
                this.createSimpleElement(modElement, "java", module.getUri());
                break;
            }
            case 5: {
                this.createSimpleElement(modElement, "connector", module.getUri());
                break;
            }
            case 4: {
                Element webElement = this.createElement(modElement, "web");
                this.createSimpleElement(webElement, "web-uri", module.getUri());
                this.createSimpleElement(webElement, "context-root", module.getContextRoot());
                break;
            }
            case 0: {
                this.createSimpleElement(modElement, "other", module.getUri());
            }
            case 2: {
                this.createSimpleElement(modElement, "service", module.getUri());
            }
        }
        String alt_dd = module.getAlt_dd();
        if (alt_dd != null) {
            this.createSimpleElement(modElement, "alt-dd", alt_dd);
        }
    }

    private void loadSecurityRoles(Element el, SecurityRoles[] roles) {
        if (roles == null) {
            return;
        }
        int i = 0;
        while (i < roles.length) {
            this.loadSecurityRole(el, roles[i]);
            ++i;
        }
    }

    private void loadSecurityRole(Element el, SecurityRoles role) {
        Element scElement = this.createElement(el, "security-role");
        String descr = role.getRoleDescription();
        if (descr != null) {
            this.createSimpleElement(scElement, "description", descr);
        }
        this.createSimpleElement(scElement, "role-name", role.getRoleName());
    }

    private Element createElement(Element parent, String child) {
        Element newEl = this.doc.createElement(child);
        parent.appendChild(newEl);
        return newEl;
    }

    private Element createSimpleElement(Element parent, String tag, String value) {
        Element newEl = this.doc.createElement(tag);
        newEl.appendChild(this.doc.createTextNode(value));
        parent.appendChild(newEl);
        return newEl;
    }
}

