/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.jar;

import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import java.io.StringBufferInputStream;
import java.util.Enumeration;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
public abstract class AbstractUpdater {
    private static String[] SYSTEM_SUBST_VAR = new String[]{"com.sap.InstanceNumber", "com.sap.SID", "com.sap.engine.installdir", "com.sap.instancedir", "com.sap.systemdir"};
    private static String DATA_SOURCE_DEFAULT = "com.sap.datasource.default";
    private String currentXMLName = null;
    private String[] systemVarViolations = null;
    private String BEGIN_XML_COMMENT = "<!--";
    private String END_XML_COOMENT = "-->";
    private boolean isCommented = false;
    protected File tempDir = null;
    protected Properties substitutions = null;
    protected Enumeration enum = null;

    public void setTempDir(File _tempDir) {
        this.tempDir = _tempDir;
    }

    public void setSubstitutions(Properties substitutions) {
        this.substitutions = substitutions;
    }

    protected String proccesSubstitution(int begin_index, String nodeValue) throws Exception {
        int end_index;
        String begin = "${";
        String end = "}";
        String subst = null;
        String key = null;
        if ((begin_index = nodeValue.indexOf(begin, begin_index)) > -1 && (end_index = nodeValue.indexOf(end, begin_index)) > -1) {
            key = nodeValue.substring(begin_index + begin.length(), end_index);
            int i = 0;
            while (i < SYSTEM_SUBST_VAR.length) {
                if (SYSTEM_SUBST_VAR[i].equals(key)) {
                    this.addSystemVarViolation("ERROR: XML file " + this.currentXMLName + " uses forbiden system substitution variable " + key + " and it is not replaced. The application/library should use a system property instead of this.");
                    return this.proccesSubstitution(end_index, nodeValue);
                }
                ++i;
            }
            if (DATA_SOURCE_DEFAULT.equals(key)) {
                if (this.currentXMLName.toLowerCase().endsWith("data-source-aliases.xml")) {
                    return this.proccesSubstitution(end_index, nodeValue);
                }
                this.addSystemVarViolation("ERROR: File " + this.currentXMLName + " uses forbiden system substitution variable " + key + ".");
                return this.proccesSubstitution(end_index, nodeValue);
            }
            if (this.substitutions == null) {
                throw new BaseIllegalArgumentException("deploy_2025", new String[]{key});
            }
            subst = this.substitutions.getProperty(key);
            if (subst == null) {
                throw new BaseIllegalArgumentException("deploy_2025", new String[]{key});
            }
            nodeValue = nodeValue.substring(0, begin_index) + subst + nodeValue.substring(end_index + 1);
            return this.proccesSubstitution(begin_index + subst.length(), nodeValue);
        }
        return nodeValue;
    }

    protected byte[] makeSubstitution(BufferedInputStream bis) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(bis));
        String row = null;
        StringBuffer buffer = new StringBuffer();
        this.isCommented = false;
        while ((row = reader.readLine()) != null) {
            buffer.append(this.procesSubstitutionWithComment(row) + "\n");
        }
        StringBufferInputStream bufferIS = new StringBufferInputStream(buffer.toString());
        byte[] result = new byte[bufferIS.available()];
        bufferIS.read(result, 0, bufferIS.available());
        try {
            bis.close();
        }
        catch (Exception doNothing) {
            boolean failed = true;
        }
        return result;
    }

    protected String procesSubstitutionWithComment(String nodeValue) throws Exception {
        if (this.isCommented) {
            int endIndex = nodeValue.indexOf(this.END_XML_COOMENT);
            if (endIndex != -1) {
                this.isCommented = false;
                return nodeValue.substring(0, endIndex) + this.procesSubstitutionWithComment(nodeValue.substring(endIndex));
            }
            return nodeValue;
        }
        int beginIndex = nodeValue.indexOf(this.BEGIN_XML_COMMENT);
        if (beginIndex != -1) {
            this.isCommented = true;
            return this.proccesSubstitution(0, nodeValue.substring(0, beginIndex)) + this.procesSubstitutionWithComment(nodeValue.substring(beginIndex));
        }
        return this.proccesSubstitution(0, nodeValue);
    }

    protected ZipEntry findEntry(ZipFile zip, String entryName) {
        ZipEntry temp = null;
        this.enum = zip.entries();
        while (this.enum.hasMoreElements()) {
            temp = (ZipEntry)this.enum.nextElement();
            if (!temp.getName().equalsIgnoreCase(entryName)) continue;
            return temp;
        }
        return null;
    }

    public void setCurrentXMLName(String currentXMLName) {
        this.currentXMLName = currentXMLName;
    }

    public void setSystemVarViolations(String[] systemVarViolations) {
        this.systemVarViolations = systemVarViolations;
    }

    public String[] getSystemVarViolations() {
        return this.systemVarViolations;
    }

    private void addSystemVarViolation(String s) {
        if (this.systemVarViolations == null) {
            this.systemVarViolations = new String[]{s};
        } else {
            String[] temp = new String[this.systemVarViolations.length + 1];
            System.arraycopy(this.systemVarViolations, 0, temp, 0, this.systemVarViolations.length);
            temp[this.systemVarViolations.length] = s;
            this.systemVarViolations = temp;
        }
    }
}

