/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear.common;

import com.sap.engine.services.deploy.ear.common.EqualUtils;
import com.sap.engine.services.deploy.ear.exceptions.BaseIllegalArgumentException;
import java.io.Serializable;

public class EJBeanReference
implements Serializable {
    static final long serialVersionUID = 217056987728199520L;
    public static final int SESSION_TYPE = 0;
    public static final int ENTITY_TYPE = 1;
    private String referenceDescription;
    private String referenceName;
    private int referenceType;
    private String referenceJndiLink;
    private String referenceEjbLink;
    private String homeInterfaceName;
    private String remoteInterfaceName;

    public EJBeanReference() {
    }

    public EJBeanReference(String name, int type, String home, String remote) {
        this.referenceName = name;
        this.referenceType = type == 0 || type == 1 ? type : 0;
        this.homeInterfaceName = home;
        this.remoteInterfaceName = remote;
    }

    public String getReferenceName() {
        return this.referenceName;
    }

    public void setReferenceName(String name) {
        this.referenceName = name;
    }

    public int getType() {
        return this.referenceType;
    }

    public void setType(int type) {
        if (type != 0 && type != 1) {
            throw new BaseIllegalArgumentException("deploy_2002");
        }
        this.referenceType = type;
    }

    public String getHomeInterfaceName() {
        return this.homeInterfaceName;
    }

    public void setHomeInterfaceName(String home) {
        this.homeInterfaceName = home;
    }

    public String getRemoteInterfaceName() {
        return this.remoteInterfaceName;
    }

    public void setRemoteInterfaceName(String remote) {
        this.remoteInterfaceName = remote;
    }

    public String getReferenceDescription() {
        return this.referenceDescription;
    }

    public void setReferenceDescription(String descr) {
        this.referenceDescription = descr;
    }

    public String getReferenceJndiLink() {
        return this.referenceJndiLink;
    }

    public void setReferenceJndiLink(String jndi_link) {
        this.referenceJndiLink = jndi_link;
    }

    public String getReferenceEjbLink() {
        return this.referenceEjbLink;
    }

    public void setReferenceEjbLink(String ejb_link) {
        this.referenceEjbLink = ejb_link;
    }

    public Object clone() {
        EJBeanReference ejbRef = new EJBeanReference(this.referenceName, this.referenceType, this.homeInterfaceName, this.remoteInterfaceName);
        ejbRef.setReferenceDescription(this.referenceDescription == null ? null : new String(this.referenceDescription));
        ejbRef.setReferenceJndiLink(this.referenceJndiLink == null ? null : new String(this.referenceJndiLink));
        ejbRef.setReferenceEjbLink(this.referenceEjbLink == null ? null : new String(this.referenceEjbLink));
        return ejbRef;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EJBeanReference)) {
            return false;
        }
        EJBeanReference ejbRef = (EJBeanReference)obj;
        if (this.referenceType != ejbRef.getType()) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.referenceName, ejbRef.getReferenceName())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.homeInterfaceName, ejbRef.getHomeInterfaceName())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.remoteInterfaceName, ejbRef.getRemoteInterfaceName())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.referenceDescription, ejbRef.getReferenceDescription())) {
            return false;
        }
        if (!EqualUtils.equalObjects(this.referenceJndiLink, ejbRef.getReferenceJndiLink())) {
            return false;
        }
        return EqualUtils.equalObjects(this.referenceEjbLink, ejbRef.getReferenceEjbLink());
    }
}

