/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.ear;

import com.sap.engine.frame.core.load.ResourceLoader;
import com.sap.engine.frame.core.load.res.DirResource;
import com.sap.engine.frame.core.load.res.JarResource;
import com.sap.engine.lib.jar.JarExtractor;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import java.util.Vector;

public class EARClassLoader
extends ResourceLoader {
    private String classPath;
    private File outputDir;

    public EARClassLoader(String applicationName, String filePath, String parentDir, ClassLoader loader) throws IOException {
        this(applicationName, filePath, parentDir, Long.toString(System.currentTimeMillis()), loader);
    }

    public EARClassLoader(String applicationName, String filePath, String parentDir, String tempDirName, ClassLoader loader) throws IOException {
        super("Deployment:Runtime:" + applicationName, new DirResource(new File(parentDir + File.separator + tempDirName).getAbsolutePath(), true), loader, null);
        this.outputDir = new File(parentDir + File.separator + tempDirName);
        JarExtractor util = new JarExtractor();
        try {
            util.extractJar(filePath, this.outputDir.getAbsolutePath());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String[] classes = this.listRecursivelyArchives(this.outputDir);
        this.classPath = this.outputDir.getAbsolutePath();
        this.classPath = this.classPath + File.pathSeparator;
        int i = 0;
        while (i < classes.length) {
            this.classPath = this.classPath + classes[i] + File.pathSeparator;
            ++i;
        }
        StringTokenizer tokenizer = new StringTokenizer(this.classPath, File.pathSeparator);
        File[] files = new File[tokenizer.countTokens()];
        int i2 = 0;
        while (i2 < files.length) {
            files[i2] = new File(tokenizer.nextToken());
            if (files[i2].isDirectory() || !files[i2].exists() && !files[i2].getName().endsWith(".jar") && !files[i2].getName().endsWith(".zip")) {
                this.addResource(new DirResource(files[i2].getAbsolutePath(), true));
            } else {
                JarResource jarR = new JarResource(files[i2].getAbsolutePath(), true);
                jarR.useTimeoutClose();
                this.addResource(jarR);
            }
            ++i2;
        }
    }

    public String getClassPath() {
        return this.classPath;
    }

    public void setAdditionalPath(String additional) {
        this.classPath = this.classPath + additional;
        StringTokenizer tokenizer = new StringTokenizer(additional, File.pathSeparator);
        File[] files = new File[tokenizer.countTokens()];
        int i = 0;
        while (i < files.length) {
            files[i] = new File(tokenizer.nextToken());
            if (files[i].isDirectory() || !files[i].exists() && !files[i].getName().endsWith(".jar") && !files[i].getName().endsWith(".zip")) {
                this.addResource(new DirResource(files[i].getAbsolutePath(), true));
            } else {
                this.addResource(new JarResource(files[i].getAbsolutePath(), true));
            }
            ++i;
        }
    }

    public String getOutputDir() {
        return this.outputDir.getAbsolutePath();
    }

    public void clear() {
        this.deleteDir(this.outputDir);
    }

    private void deleteDir(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (!files[i].isDirectory()) {
                    files[i].delete();
                } else {
                    this.deleteDir(files[i]);
                }
                ++i;
            }
        }
        dir.delete();
    }

    private String[] listRecursivelyArchives(File outputDir) throws IOException {
        Vector files = new Vector();
        if (outputDir.isDirectory()) {
            this.list(outputDir, files);
        }
        Object[] res = new String[files.size()];
        files.copyInto(res);
        return res;
    }

    private void list(File file, Vector all) throws IOException {
        File[] files = file.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.list(files[i], all);
            } else if (files[i].getName().toLowerCase().endsWith(".jar") || files[i].getName().toLowerCase().endsWith(".zip") || files[i].getName().toLowerCase().endsWith(".war")) {
                all.add(files[i].getAbsolutePath());
            } else if (files[i].getName().toLowerCase().endsWith(".rar")) {
                JarExtractor util = new JarExtractor();
                File connectorDir = this.getNewFolder(files[i].getParentFile(), files[i].getName());
                util.extractJar(files[i].getAbsolutePath(), connectorDir.getAbsolutePath());
                String[] connectorJars = this.listRecursivelyArchives(connectorDir);
                if (connectorJars != null) {
                    int j = 0;
                    while (j < connectorJars.length) {
                        all.add(connectorJars[j]);
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    private File getNewFolder(File parent, String connectorName) {
        File newFolder = new File(parent, connectorName + String.valueOf(System.currentTimeMillis()));
        if (newFolder.exists()) {
            this.getNewFolder(parent, connectorName);
        }
        return newFolder;
    }
}

