/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.deploy.converter;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.container.WarningException;
import com.sap.engine.services.deploy.converter.EJBDescriptorDocument;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.SecurityRoles;
import com.sap.engine.services.deploy.exceptions.BaseEarException;
import com.sap.engine.services.deploy.exceptions.BaseIOException;
import com.sap.engine.services.deploy.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.deploy.exceptions.BaseWrongStructureException;
import com.sap.engine.services.ejb.deploy.descriptors.AccessControls;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DependentValueDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class EJBJarDocument {
    public static final String dtd = "<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type,session-timeout?, transaction-type, bean-count,\n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, bean-count, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT session-timeout (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT group-id (#PCDATA)>\n<!ELEMENT user-id (#PCDATA)>\n<!ELEMENT user-name (#PCDATA)>\n<!ELEMENT group-name (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth, res-link, user-name, password)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT res-link (#PCDATA)>\n<!ELEMENT password (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name, group-id*, user-id*, user-name*, group-name*)>\n<!ELEMENT method-permission (description?, role-name+, method+, pid?)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT pid (#PCDATA)>\n<!ELEMENT bean-count (#PCDATA)>\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n]>";
    public static String simpleDTD = "<!DOCTYPE ejb-jar [\n<!ELEMENT ejb-jar (description?, display-name?, small-icon?, large-icon?, enterprise-beans, assembly-descriptor?, ejb-client-jar?)>\n<!ELEMENT description (#PCDATA)>\n<!ELEMENT display-name (#PCDATA)>\n<!ELEMENT small-icon (#PCDATA)>\n<!ELEMENT large-icon (#PCDATA)>\n<!ELEMENT enterprise-beans (session|entity)+ > \n<!ELEMENT session (description?, display-name?, small-icon?, large-icon?, \n ejb-name, home, remote, ejb-class, session-type, transaction-type, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT entity (description?, display-name?, small-icon?, large-icon?,\n ejb-name, home, remote, ejb-class, persistence-type, prim-key-class, reentrant, cmp-field*, primkey-field?, \n env-entry*, ejb-ref*, security-role-ref*, resource-ref*)> \n<!ELEMENT ejb-name (#PCDATA)>\n<!ELEMENT home (#PCDATA)>\n<!ELEMENT remote (#PCDATA)>\n<!ELEMENT ejb-class (#PCDATA)>\n<!ELEMENT session-type (#PCDATA)>\n<!ELEMENT transaction-type (#PCDATA)>\n<!ELEMENT env-entry (description?, env-entry-name, env-entry-type, env-entry-value?)>\n<!ELEMENT env-entry-name (#PCDATA)>\n<!ELEMENT env-entry-type (#PCDATA)>\n<!ELEMENT env-entry-value (#PCDATA)>\n<!ELEMENT ejb-ref (description?, ejb-ref-name, ejb-ref-type, home, remote, ejb-link?)>\n<!ELEMENT ejb-ref-name (#PCDATA)>\n<!ELEMENT ejb-ref-type (#PCDATA)>\n<!ELEMENT ejb-link (#PCDATA)>\n<!ELEMENT security-role-ref (description?, role-name, role-link?)>\n<!ELEMENT role-name (#PCDATA)>\n<!ELEMENT role-link (#PCDATA)>\n<!ELEMENT resource-ref (description?, res-ref-name, res-type, res-auth)>\n<!ELEMENT res-ref-name (#PCDATA)>\n<!ELEMENT res-type (#PCDATA)>\n<!ELEMENT res-auth (#PCDATA)>\n<!ELEMENT persistence-type (#PCDATA)>\n<!ELEMENT prim-key-class (#PCDATA)>\n<!ELEMENT reentrant (#PCDATA)>\n<!ELEMENT cmp-field (description?, field-name)>\n<!ELEMENT field-name (#PCDATA)>\n<!ELEMENT primkey-field (#PCDATA)>\n<!ELEMENT assembly-descriptor (security-role*, method-permission*, container-transaction*)>\n<!ELEMENT security-role (description?, role-name)>\n<!ELEMENT method-permission (description?, role-name+, method+)>\n<!ELEMENT method (description?, ejb-name, method-intf?, method-name, method-params?)>\n<!ELEMENT method-intf (#PCDATA)>\n<!ELEMENT method-name (#PCDATA)>\n<!ELEMENT method-params (method-param*)>\n<!ELEMENT method-param (#PCDATA) >\n<!ELEMENT container-transaction (description?, method+, trans-attribute)>\n<!ELEMENT trans-attribute (#PCDATA)>\n<!ELEMENT ejb-client-jar (#PCDATA)>\n]>";
    private static final String[] EJBOBJECT_METHODS = new String[]{"getEJBHome", "getHandle", "getPrimaryKey", "isIdentical"};
    private static final String[] EJBLOCALOBJECT_METHODS = new String[]{"getEJBLocalHome", "getPrimaryKey", "isIdentical"};
    private static final String[] EJBHOME_METHODS = new String[]{"getEJBMetaData", "getHomeHandle"};
    protected Document mainDocument;
    protected Element mainElement;
    protected Element assemblyElement;
    protected EJBDescriptorDocument ejbDoc;
    protected ClassLoader loader;
    private boolean styleFlag = false;
    private Vector warnings = new Vector();

    public EJBJarDescriptor parseXml(BufferedInputStream xmlStream, String xmlName) throws BaseWrongStructureException, BaseEarException, BaseIOException, DeploymentException {
        Document document = null;
        this.styleFlag = true;
        try {
            StandardDOMParser domParser = new StandardDOMParser();
            domParser.setSystemId(xmlName);
            document = domParser.parse((InputStream)xmlStream);
            xmlStream.close();
        }
        catch (IOException ioe) {
            throw new BaseIOException("deploy_4404", new String[]{"ejb"}, (Throwable)ioe);
        }
        catch (SAXException sax) {
            throw new DeploymentException("deploy_4404", new String[]{"ejb"}, sax);
        }
        return this.loadEJBJarDescriptor(document);
    }

    public void setLoader(ClassLoader _loader) {
        this.loader = _loader;
    }

    public EJBJarDescriptor loadEJBJarDescriptor(Document doc) throws BaseWrongStructureException, BaseEarException {
        Element docEl = doc.getDocumentElement();
        return this.loadEJBJarDescriptor(docEl);
    }

    public EJBJarDescriptor loadEJBJarDescriptor(Element docEl) throws BaseWrongStructureException, BaseEarException {
        DeploymentDescriptor[] descriptors = null;
        if (!docEl.getNodeName().equals("ejb-jar")) {
            throw new BaseWrongStructureException("deploy_4101", new String[]{"ejb-jar", docEl.getNodeName()});
        }
        EJBJarDescriptor jar = new EJBJarDescriptor();
        NodeList list = docEl.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            if (list.item(i).getNodeType() == 1) {
                Element el = (Element)list.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    String description = this.getTextValue(el);
                    jar.setDescription(description);
                } else if (tag.equals("display-name")) {
                    String displayName = this.getTextValue(el);
                    jar.setDisplayName(displayName);
                } else if (tag.equals("small-icon")) {
                    String small = this.getTextValue(el);
                    String smallIcon = this.processString(small, false);
                    jar.setSmallIcon(new SerializableFile(smallIcon));
                } else if (tag.equals("large-icon")) {
                    String large = this.getTextValue(el);
                    String largeIcon = this.processString(large, false);
                    jar.setLargeIcon(new SerializableFile(largeIcon));
                } else if (tag.equals("enterprise-beans")) {
                    descriptors = this.initDescriptors(el);
                    if (descriptors != null) {
                        jar.setDescriptors(descriptors);
                    }
                } else if (tag.equals("assembly-descriptor")) {
                    Element descEl;
                    if (descriptors == null && (descEl = this.getDescriptorsEl(docEl)) != null) {
                        descriptors = this.initDescriptors(descEl);
                    }
                    if (descriptors != null) {
                        if (this.loader == null) {
                            this.loader = this.getClass().getClassLoader();
                        }
                        this.processAssemblyDescriptor(el, jar);
                    }
                }
            }
            ++i;
        }
        this.parseFields(jar, this.loader);
        this.parseFinders(jar, this.loader);
        return jar;
    }

    /*
     * Unable to fully structure code
     */
    protected void parseFields(EJBJarDescriptor ejbjarDes, ClassLoader loader) {
        entityDescriptors = ejbjarDes.getAbstractSchema().getDescriptors();
        i = 0;
        while (i < entityDescriptors.length) {
            block47: {
                block50: {
                    descriptor = entityDescriptors[i];
                    className = descriptor.getClassName();
                    clazz = null;
                    try {
                        clazz = loader.loadClass(className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{className}, cnfe).getLocalizedMessage());
                        break block47;
                    }
                    catch (NoClassDefFoundError err) {
                        this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{className}, err).getLocalizedMessage());
                        break block47;
                    }
                    cmpFields = descriptor.getCmpFields();
                    if (cmpFields != null) {
                        cmp11 = descriptor.getCmpVersion() == 1;
                        j = 0;
                        while (j < cmpFields.length) {
                            block49: {
                                block48: {
                                    fieldName = cmpFields[j].getFieldName();
                                    fieldType = null;
                                    if (cmp11) {
                                        try {
                                            cmpFields[j].setFieldClass(clazz.getField(fieldName).getType());
                                            fieldType = cmpFields[j].getFieldClass().getName();
                                            break block48;
                                        }
                                        catch (NoSuchFieldException nsfe) {
                                            this.warnings.add(new WarningException("deploy_4003", (Object[])new String[]{fieldName, className}, nsfe).getLocalizedMessage());
                                            break block49;
                                        }
                                    }
                                    getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                                    try {
                                        fieldType = clazz.getMethod(getMethodName, new Class[0]).getReturnType().getName();
                                    }
                                    catch (NoSuchMethodException nsfe) {
                                        this.warnings.add(new WarningException("deploy_4004", (Object[])new String[]{getMethodName, className}, nsfe).getLocalizedMessage());
                                        break block49;
                                    }
                                }
                                if (this.primitive(fieldType) || fieldType.startsWith("java.")) {
                                    if (fieldType.equals("[B")) {
                                        fieldType = "byte []";
                                    }
                                    cmpFields[j].setFieldType(fieldType);
                                } else {
                                    classFieldsMap = true;
                                    depValueClass = null;
                                    try {
                                        depValueClass = loader.loadClass(fieldType);
                                    }
                                    catch (ClassNotFoundException cnfe) {
                                        this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{fieldType}, cnfe).getLocalizedMessage());
                                        break block49;
                                    }
                                    catch (NoClassDefFoundError err) {
                                        this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{fieldType}, err).getLocalizedMessage());
                                        break block49;
                                    }
                                    fields = depValueClass.getDeclaredFields();
                                    classFieldNames = new String[fields.length];
                                    classFieldTypes = new String[fields.length];
                                    if (fields.length == 0) {
                                        classFieldsMap = false;
                                    } else {
                                        p = 0;
                                        while (p < fields.length) {
                                            if (!Modifier.isPublic(fields[p].getModifiers())) {
                                                classFieldsMap = false;
                                                break;
                                            }
                                            classFieldNames[p] = fields[p].getName();
                                            classFieldTypes[p] = fields[p].getType().getName();
                                            classFieldsMap = true;
                                            ++p;
                                        }
                                    }
                                    if (classFieldsMap) {
                                        try {
                                            constr = depValueClass.getConstructor(null);
                                        }
                                        catch (NoSuchMethodException e) {
                                            classFieldsMap = false;
                                            this.warnings.add(new WarningException("deploy_4005", (Object[])new String[]{fieldType}, e).getLocalizedMessage());
                                        }
                                    }
                                    if (classFieldsMap) {
                                        depValueDscr = new DependentValueDescriptor();
                                        depValueDscr.setDescription(cmpFields[j].getDescription());
                                        depValueDscr.setFieldName(fieldName);
                                        depValueDscr.setFieldType(fieldType);
                                        depValueDscr.setValueFieldNames(classFieldNames);
                                        depValueDscr.setValueFieldTypes(classFieldTypes);
                                        cmpFields[j] = depValueDscr;
                                    } else {
                                        cmpFields[j].setFieldType(fieldType);
                                    }
                                }
                            }
                            ++j;
                        }
                    }
                    if (descriptor.getPKFieldName() != null) break block50;
                    if (!descriptor.getPrimaryKeyClass().equals("java.lang.Object")) {
                        pkClass = null;
                        try {
                            pkClass = loader.loadClass(descriptor.getPrimaryKeyClass());
                        }
                        catch (ClassNotFoundException cnfe) {
                            this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{descriptor.getPrimaryKeyClass()}, cnfe).getLocalizedMessage());
                            break block47;
                        }
                        catch (NoClassDefFoundError err) {
                            this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{descriptor.getPrimaryKeyClass()}, err).getLocalizedMessage());
                            break block47;
                        }
                        pkClassFileds = pkClass.getFields();
                        xmlCmpFields = descriptor.getCmpFields();
                        vPKCmpFields = new Vector<PersistentField>();
                        pkClassFieldName = null;
                        l = 0;
                        found = false;
                        p = 0;
                        while (p < pkClassFileds.length) {
                            if (Modifier.isPublic(pkClassFileds[p].getModifiers())) {
                                pkClassFieldName = pkClassFileds[p].getName();
                                l = 0;
                                found = false;
                                while (!found && l < xmlCmpFields.length) {
                                    if (xmlCmpFields[l] != null && pkClassFieldName.equals(xmlCmpFields[l].getFieldName())) {
                                        xmlCmpFields[l].setCompoundPK();
                                        vPKCmpFields.addElement(xmlCmpFields[l]);
                                        xmlCmpFields[l] = null;
                                        found = true;
                                        continue;
                                    }
                                    ++l;
                                }
                                if (!found) {
                                    this.warnings.add(new WarningException("deploy_4302", new String[]{"ejb-jar.xml"}).getLocalizedMessage());
                                }
                            }
                            ++p;
                        }
                        descriptor.setPKCmpFields(vPKCmpFields.toArray(new PersistentField[vPKCmpFields.size()]));
                        newCmpfields = new PersistentField[xmlCmpFields.length - vPKCmpFields.size()];
                        pos = 0;
                        k = 0;
                        while (k < xmlCmpFields.length) {
                            if (xmlCmpFields[k] != null) {
                                newCmpfields[pos++] = xmlCmpFields[k];
                            }
                            ++k;
                        }
                        descriptor.setCmpFields(newCmpfields);
                    } else {
                        cmpFld = new PersistentField[]{new PersistentField()};
                        cmpFld[0].setDescription("Deployer genrates default PK if it is unknow; spec 10.8.3");
                        cmpFld[0].setFieldName("ejb_pk");
                        cmpFld[0].setFieldType("java.lang.Long");
                        descriptor.setPKCmpFields(cmpFld);
                    }
                    ** GOTO lbl-1000
                }
                xmlCmpFields = descriptor.getCmpFields();
                pkFieldName = descriptor.getPKFieldName();
                l = 0;
                while (l < xmlCmpFields.length) {
                    if (xmlCmpFields[l].getFieldName().equals(pkFieldName)) {
                        descriptor.setPKCmpFields(new PersistentField[]{xmlCmpFields[l]});
                        newCmpfields = new PersistentField[xmlCmpFields.length - 1];
                        System.arraycopy(xmlCmpFields, 0, newCmpfields, 0, l);
                        System.arraycopy(xmlCmpFields, l + 1, newCmpfields, l, newCmpfields.length - l);
                        descriptor.setCmpFields(newCmpfields);
                        break;
                    }
                    ++l;
                }
                if (descriptor.getPKCmpFields() == null) {
                    this.warnings.add(new WarningException("deploy_4302", new String[]{"ejb-jar.xml"}).getLocalizedMessage());
                } else lbl-1000:
                // 3 sources

                {
                    cmrFields = descriptor.getCmrFields();
                    if (cmrFields != null) {
                        j = 0;
                        while (j < cmrFields.length) {
                            if (cmrFields[j].getFieldType() == null) {
                                fieldName = cmrFields[j].getFieldName();
                                getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                                try {
                                    cmrFields[j].setFieldType(clazz.getMethod(getMethodName, new Class[0]).getReturnType().getName());
                                }
                                catch (NoSuchMethodException nsfe) {
                                    this.warnings.add(new WarningException("deploy_4004", (Object[])new String[]{getMethodName, className}, nsfe).getLocalizedMessage());
                                }
                            }
                            ++j;
                        }
                    }
                }
            }
            ++i;
        }
    }

    protected void parseFinders(EJBJarDescriptor ejbjarDes, ClassLoader loader) {
        CMPEntityDescriptor[] descriptors = ejbjarDes.getAbstractSchema().getDescriptors();
        if (descriptors == null) {
            return;
        }
        int i = 0;
        while (i < descriptors.length) {
            block30: {
                Class<?> locHomeClass;
                Class<?> remHomeClass;
                Class<?> beanClass;
                String localHomeClassName;
                String remoteHomeClassName;
                String beanClassName;
                CMPEntityDescriptor descriptor;
                block29: {
                    descriptor = descriptors[i];
                    beanClassName = descriptor.getClassName();
                    remoteHomeClassName = descriptor.getRemoteHomeInterface();
                    localHomeClassName = descriptor.getLocalHomeInterface();
                    beanClass = null;
                    remHomeClass = null;
                    locHomeClass = null;
                    try {
                        beanClass = loader.loadClass(beanClassName);
                        if (remoteHomeClassName != null) {
                            remHomeClass = loader.loadClass(remoteHomeClassName);
                        }
                        if (localHomeClassName == null) break block29;
                        locHomeClass = loader.loadClass(localHomeClassName);
                    }
                    catch (ClassNotFoundException cnfe) {
                        this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{beanClassName + " | " + remoteHomeClassName + " | " + localHomeClassName}, cnfe).getLocalizedMessage());
                        break block30;
                    }
                    catch (NoClassDefFoundError err) {
                        this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{beanClassName + " | " + remoteHomeClassName + " | " + localHomeClassName}, err).getLocalizedMessage());
                        break block30;
                    }
                }
                FinderDescriptor[] methods = descriptor.getFinderDescriptors();
                if (methods != null) {
                    int j = 0;
                    while (j < methods.length) {
                        block31: {
                            int n;
                            String[] exceptions;
                            Class<?>[] exceptionsClass;
                            FinderDescriptor method = methods[j];
                            String methodName = method.getMethodName();
                            String[] params = method.getParamsTypes();
                            Class[] paramsClass = null;
                            if (params != null) {
                                paramsClass = new Class[params.length];
                                int k = 0;
                                while (k < params.length) {
                                    try {
                                        paramsClass[k] = this.getClassFromString(params[k], loader);
                                    }
                                    catch (ClassNotFoundException cnfe) {
                                        this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{params[k]}, cnfe).getLocalizedMessage());
                                    }
                                    catch (NoClassDefFoundError err) {
                                        this.warnings.add(new WarningException("deploy_4002", (Object[])new String[]{params[k]}, err).getLocalizedMessage());
                                    }
                                    ++k;
                                }
                            } else {
                                paramsClass = new Class[]{};
                            }
                            if (methodName.startsWith("ejbSelect")) {
                                Method reflMethod = null;
                                try {
                                    reflMethod = beanClass.getMethod(methodName, paramsClass);
                                }
                                catch (NoSuchMethodException nsme) {
                                    this.warnings.add(new WarningException("deploy_4004", (Object[])new String[]{methodName, beanClassName}, nsme).getLocalizedMessage());
                                    break block31;
                                }
                                method.setSelect();
                                method.setReturnType(reflMethod.getReturnType().getName());
                                exceptionsClass = reflMethod.getExceptionTypes();
                                exceptions = new String[exceptionsClass.length];
                                n = 0;
                                while (n < exceptionsClass.length) {
                                    exceptions[n] = exceptionsClass[n].getName();
                                    ++n;
                                }
                                method.setExceptions(exceptions);
                            } else if (methodName.startsWith("find")) {
                                Method reflIntfMethod = null;
                                try {
                                    reflIntfMethod = remHomeClass.getMethod(methodName, paramsClass);
                                }
                                catch (NoSuchMethodException nsme1) {
                                    this.warnings.add(new WarningException("deploy_4004", (Object[])new String[]{methodName, remoteHomeClassName}, nsme1).getLocalizedMessage());
                                }
                                catch (NullPointerException npe) {
                                    this.warnings.add(new WarningException("deploy_4002", new String[]{remoteHomeClassName}).getLocalizedMessage());
                                }
                                if (reflIntfMethod == null) {
                                    try {
                                        reflIntfMethod = locHomeClass.getMethod(methodName, paramsClass);
                                    }
                                    catch (NoSuchMethodException nsme) {
                                        this.warnings.add(new WarningException("deploy_4004", (Object[])new String[]{methodName, localHomeClassName}, nsme).getLocalizedMessage());
                                        break block31;
                                    }
                                    catch (NullPointerException npe) {
                                        this.warnings.add(new WarningException("deploy_4002", new String[]{localHomeClassName}).getLocalizedMessage());
                                        break block31;
                                    }
                                }
                                method.setFinder();
                                method.setReturnType(reflIntfMethod.getReturnType().getName());
                                exceptionsClass = reflIntfMethod.getExceptionTypes();
                                exceptions = new String[exceptionsClass.length];
                                n = 0;
                                while (n < exceptionsClass.length) {
                                    exceptions[n] = exceptionsClass[n].getName();
                                    ++n;
                                }
                                method.setExceptions(exceptions);
                            } else {
                                this.warnings.add(new WarningException("deploy_4302", new String[]{"ejb-jar.xml"}).getLocalizedMessage());
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
    }

    protected Class getClassFromString(String className, ClassLoader loader) throws ClassNotFoundException, NoClassDefFoundError {
        if (className.equals("int")) {
            return Integer.TYPE;
        }
        if (className.equals("byte")) {
            return Byte.TYPE;
        }
        if (className.equals("char")) {
            return Character.TYPE;
        }
        if (className.equals("short")) {
            return Short.TYPE;
        }
        if (className.equals("long")) {
            return Long.TYPE;
        }
        if (className.equals("double")) {
            return Double.TYPE;
        }
        if (className.equals("float")) {
            return Float.TYPE;
        }
        if (className.equals("boolean")) {
            return Boolean.TYPE;
        }
        return loader.loadClass(className);
    }

    protected String processString(String str, boolean saving) {
        char separator = File.separatorChar;
        String str2 = new String();
        int i = 0;
        while (i < str.length()) {
            char ch = str.charAt(i);
            if (saving) {
                if (ch == separator) {
                    ch = '\\';
                }
            } else if (ch == '\\') {
                ch = separator;
            }
            str2 = new String(str2 + ch);
            ++i;
        }
        return str2;
    }

    protected String getTextValue(Element element) {
        if (element == null) {
            return new String();
        }
        Node node = element.getFirstChild();
        if (node != null && (node.getNodeType() == 3 || node.getNodeType() == 4)) {
            String value = node.getNodeValue();
            return value.trim();
        }
        return new String("");
    }

    protected Element getDescriptorsEl(Element docEl) {
        NodeList list = docEl.getElementsByTagName("enterprise-beans");
        if (list.getLength() > 0) {
            return (Element)list.item(0);
        }
        return null;
    }

    protected DeploymentDescriptor[] initDescriptors(Element elmnt) throws BaseWrongStructureException {
        this.ejbDoc = new EJBDescriptorDocument();
        this.ejbDoc.setLoader(this.loader);
        NodeList descList = elmnt.getChildNodes();
        Vector<DeploymentDescriptor> descVec = new Vector<DeploymentDescriptor>();
        int j = 0;
        while (j < descList.getLength()) {
            if (descList.item(j).getNodeType() == 1) {
                Element el = (Element)descList.item(j);
                DeploymentDescriptor desc = this.ejbDoc.loadDescriptor(el);
                descVec.addElement(desc);
            }
            ++j;
        }
        this.warnings.addAll(this.ejbDoc.getWarnings());
        if (descVec.size() > 0) {
            Object[] descriptors = new DeploymentDescriptor[descVec.size()];
            descVec.copyInto(descriptors);
            return descriptors;
        }
        return null;
    }

    public MethodEntry[] getMethodXml(Element methodEl, EJBJarDescriptor jarDescriptor, ClassLoader loader) throws BaseIllegalArgumentException, BaseEarException {
        NodeList methodList = methodEl.getChildNodes();
        String description = null;
        String ejbName = null;
        String methodIntf = null;
        String methodName = null;
        Vector<String> methodParams = new Vector<String>();
        boolean hasMethodParams = false;
        int xmlType = 2;
        int i = 0;
        while (i < methodList.getLength()) {
            if (methodList.item(i).getNodeType() == 1) {
                Element el = (Element)methodList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("description")) {
                    description = this.getTextValue(el);
                } else if (tag.equals("ejb-name")) {
                    ejbName = this.getTextValue(el);
                } else if (tag.equals("method-intf")) {
                    methodIntf = this.getTextValue(el);
                    if (xmlType == 2) {
                        if (!(methodIntf.equals("Remote") || methodIntf.equals("Home") || methodIntf.equals("Local") || methodIntf.equals("LocalHome"))) {
                            throw new BaseIllegalArgumentException("deploy_4201", new String[]{"method-intf", "Home, Remote, LocalHome, Local", methodIntf});
                        }
                    } else if (!methodIntf.equals("Remote") && !methodIntf.equals("Home")) {
                        throw new BaseIllegalArgumentException("deploy_4201", new String[]{"method-intf", "Home, Remote", methodIntf});
                    }
                } else if (tag.equals("method-name")) {
                    methodName = this.getTextValue(el).trim();
                } else if (tag.equals("method-params")) {
                    hasMethodParams = true;
                    NodeList paramList = el.getChildNodes();
                    int j = 0;
                    while (j < paramList.getLength()) {
                        Element pel;
                        if (paramList.item(j).getNodeType() == 1 && (pel = (Element)paramList.item(j)).getNodeName().equals("method-param")) {
                            methodParams.add(this.getTextValue(pel));
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        DeploymentDescriptor[] descriptors = jarDescriptor.getDDescriptors();
        DeploymentDescriptor foundDescr = null;
        int i2 = 0;
        while (i2 < descriptors.length) {
            if (descriptors[i2].getEjbName().equals(ejbName)) {
                foundDescr = descriptors[i2];
                break;
            }
            ++i2;
        }
        if (foundDescr == null) {
            throw new BaseEarException("deploy_4302", new String[]{"ejb-jar.xml"});
        }
        MethodEntry[] methodEnts = null;
        if (methodName.equals("*")) {
            if (this.styleFlag) {
                MethodEntry ent = new MethodEntry();
                ent.setEjbName(ejbName);
                ent.setMethodInterface(methodIntf);
                ent.setMethodSpecified(false);
                ent.setMethodDescription(description);
                return new MethodEntry[]{ent};
            }
            try {
                return this.getAllMethodsInBean(methodName, methodIntf, foundDescr, loader, description);
            }
            catch (ClassNotFoundException cnfe) {
                throw new BaseEarException("deploy_4303", new String[]{jarDescriptor.getJarName()}, cnfe);
            }
            catch (NoClassDefFoundError err) {
                throw new BaseEarException("deploy_4303", new String[]{jarDescriptor.getJarName()}, err);
            }
        }
        if (!hasMethodParams) {
            try {
                methodEnts = this.getAllMethodsInBean(methodName, methodIntf, foundDescr, loader, description);
                int i3 = 0;
                while (i3 < methodEnts.length) {
                    methodEnts[i3].setPriority(2);
                    ++i3;
                }
                return methodEnts;
            }
            catch (ClassNotFoundException cnfe) {
                throw new BaseEarException("deploy_4303", new String[]{jarDescriptor.getJarName()}, cnfe);
            }
            catch (NoClassDefFoundError err) {
                throw new BaseEarException("deploy_4303", new String[]{jarDescriptor.getJarName()}, err);
            }
        }
        Vector<MethodEntry> filteredMethods = new Vector<MethodEntry>();
        String[] params = methodParams.toArray(new String[0]);
        try {
            methodEnts = this.getAllMethodsInBean(methodName, methodIntf, foundDescr, loader, description);
        }
        catch (ClassNotFoundException cnfe) {
            throw new BaseEarException("deploy_4303", new String[]{jarDescriptor.getJarName()}, cnfe);
        }
        catch (NoClassDefFoundError err) {
            throw new BaseEarException("deploy_4303", new String[]{jarDescriptor.getJarName()}, err);
        }
        int i4 = 0;
        while (i4 < methodEnts.length) {
            String[] mParams = methodEnts[i4].getParameters();
            if (params.length == mParams.length) {
                boolean equals = true;
                int j = 0;
                while (j < params.length) {
                    if (!params[j].equals(this.convertClassName(mParams[j]))) {
                        equals = false;
                    }
                    ++j;
                }
                if (equals) {
                    methodEnts[i4].setPriority(3);
                    filteredMethods.add(methodEnts[i4]);
                }
            }
            ++i4;
        }
        if (filteredMethods.size() == 0) {
            String param = "";
            int i5 = 0;
            while (i5 < params.length) {
                param = param + " , " + params[i5];
                ++i5;
            }
            throw new BaseEarException("deploy_4303", new String[]{jarDescriptor.getJarName()});
        }
        return filteredMethods.toArray(new MethodEntry[0]);
    }

    private MethodEntry[] getAllMethodsInBean(String methodName, String methodIntf, DeploymentDescriptor ddescr, ClassLoader loader, String descrip) throws ClassNotFoundException, NoClassDefFoundError, BaseEarException {
        int i;
        Method[] methods;
        if (ddescr instanceof MessageDrivenDescriptor) {
            if (methodName.equals("*") || methodName.equals("onMessage")) {
                Class<?> beanClass = loader.loadClass(ddescr.getClassName());
                Class<?> messageClass = loader.loadClass("javax.jms.Message");
                try {
                    Method onMess = beanClass.getMethod("onMessage", messageClass);
                    return new MethodEntry[]{new MethodEntry(ddescr.getEjbName(), null, onMess, descrip)};
                }
                catch (NoSuchMethodException nsme) {
                    throw new BaseEarException("deploy_4303", new String[]{ddescr.getEJBJarDescriptor().getJarName()}, nsme);
                }
            }
            throw new BaseEarException("deploy_4303", new String[]{ddescr.getEJBJarDescriptor().getJarName()});
        }
        Class<?> remoteIntf = null;
        Class<?> homeIntf = null;
        Class<?> localIntf = null;
        Class<?> localHomeIntf = null;
        if (ddescr.getRemoteInterface() != null) {
            remoteIntf = loader.loadClass(ddescr.getRemoteInterface());
        }
        if (ddescr.getRemoteHomeInterface() != null) {
            homeIntf = loader.loadClass(ddescr.getRemoteHomeInterface());
        }
        if (ddescr.getLocalInterface() != null) {
            localIntf = loader.loadClass(ddescr.getLocalInterface());
        }
        if (ddescr.getLocalHomeInterface() != null) {
            localHomeIntf = loader.loadClass(ddescr.getLocalHomeInterface());
        }
        if (methodIntf != null) {
            Class<?> currClass = null;
            Object suppClass = null;
            if (methodIntf.equals("Remote")) {
                if (remoteIntf == null) {
                    throw new BaseEarException("deploy_4302", new String[]{"ejb-jar.xml"});
                }
                currClass = remoteIntf;
            } else if (methodIntf.equals("Home")) {
                if (homeIntf == null) {
                    throw new BaseEarException("deploy_4302", new String[]{"ejb-jar.xml"});
                }
                currClass = homeIntf;
            } else if (methodIntf.equals("Local")) {
                if (localIntf == null) {
                    throw new BaseEarException("deploy_4302", new String[]{"ejb-jar.xml"});
                }
                currClass = localIntf;
            } else if (methodIntf.equals("LocalHome")) {
                if (localHomeIntf == null) {
                    throw new BaseEarException("deploy_4302", new String[]{"ejb-jar.xml"});
                }
                currClass = localHomeIntf;
            }
            Vector<MethodEntry> methodEntries = new Vector<MethodEntry>();
            Method[] methods2 = currClass.getMethods();
            if (methodName.equals("*")) {
                int i2 = 0;
                while (i2 < methods2.length) {
                    methodEntries.add(new MethodEntry(ddescr.getEjbName(), methodIntf, methods2[i2], descrip));
                    ++i2;
                }
            } else {
                boolean found = false;
                int i3 = 0;
                while (i3 < methods2.length) {
                    if (methods2[i3].getName().equals(methodName)) {
                        found = true;
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), methodIntf, methods2[i3], descrip));
                    }
                    ++i3;
                }
                if (!found) {
                    throw new BaseEarException("deploy_4303", new String[]{ddescr.getEJBJarDescriptor().getJarName()});
                }
            }
            return methodEntries.toArray(new MethodEntry[0]);
        }
        Vector<MethodEntry> methodEntries = new Vector<MethodEntry>();
        boolean found = false;
        boolean sessionBean = ddescr instanceof SessionDescriptor;
        if (remoteIntf != null) {
            methods = remoteIntf.getMethods();
            if (methodName.equals("*")) {
                i = 0;
                while (i < methods.length) {
                    if (!this.containsIn(EJBOBJECT_METHODS, methods[i].getName(), sessionBean)) {
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Remote", methods[i], descrip));
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < methods.length) {
                    if (methods[i].getName().equals(methodName)) {
                        found = true;
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Remote", methods[i], descrip));
                    }
                    ++i;
                }
            }
        }
        if (localIntf != null) {
            methods = localIntf.getMethods();
            if (methodName.equals("*")) {
                i = 0;
                while (i < methods.length) {
                    if (!this.containsIn(EJBLOCALOBJECT_METHODS, methods[i].getName(), sessionBean)) {
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Local", methods[i], descrip));
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < methods.length) {
                    if (methods[i].getName().equals(methodName)) {
                        found = true;
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Local", methods[i], descrip));
                    }
                    ++i;
                }
            }
        }
        if (!sessionBean) {
            if (homeIntf != null) {
                methods = homeIntf.getMethods();
                if (methodName.equals("*")) {
                    i = 0;
                    while (i < methods.length) {
                        if (!this.containsIn(EJBHOME_METHODS, methods[i].getName(), false)) {
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Home", methods[i], descrip));
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < methods.length) {
                        if (methods[i].getName().equals(methodName)) {
                            found = true;
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Home", methods[i], descrip));
                        }
                        ++i;
                    }
                }
            }
            if (localHomeIntf != null) {
                methods = localHomeIntf.getMethods();
                if (methodName.equals("*")) {
                    i = 0;
                    while (i < methods.length) {
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "LocalHome", methods[i], descrip));
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < methods.length) {
                        if (methods[i].getName().equals(methodName)) {
                            found = true;
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "LocalHome", methods[i], descrip));
                        }
                        ++i;
                    }
                }
            }
        }
        if (!found && !methodName.equals("*")) {
            throw new BaseEarException("deploy_4303", new String[]{ddescr.getEJBJarDescriptor().getJarName()});
        }
        return methodEntries.toArray(new MethodEntry[0]);
    }

    protected void processAssemblyDescriptor(Element assemblyEl, EJBJarDescriptor result) throws BaseEarException {
        NodeList assemblyList = assemblyEl.getChildNodes();
        Vector<SecurityRoles> securityRoles = new Vector<SecurityRoles>();
        Vector<AccessControls> accessControls = new Vector<AccessControls>();
        Vector<ControlDescriptor> controlDescriptors = new Vector<ControlDescriptor>();
        Vector<MethodEntry> excludeListMethods = new Vector<MethodEntry>();
        int i = 0;
        while (i < assemblyList.getLength()) {
            if (assemblyList.item(i).getNodeType() == 1) {
                int y;
                String accDescr;
                Element el = (Element)assemblyList.item(i);
                String tag = el.getNodeName();
                if (tag.equals("security-role")) {
                    SecurityRoles secRole = new SecurityRoles();
                    NodeList roleList = el.getChildNodes();
                    int j = 0;
                    while (j < roleList.getLength()) {
                        if (roleList.item(j).getNodeType() == 1) {
                            Element roleEl = (Element)roleList.item(j);
                            if (roleEl.getNodeName().equals("description")) {
                                secRole.setRoleDescription(this.getTextValue(roleEl));
                            } else if (roleEl.getNodeName().equals("role-name")) {
                                secRole.setRoleName(this.getTextValue(roleEl));
                            }
                        }
                        ++j;
                    }
                    securityRoles.add(secRole);
                } else if (tag.equals("method-permission")) {
                    accDescr = null;
                    NodeList descrList = el.getElementsByTagName("description");
                    int y2 = 0;
                    while (y2 < descrList.getLength()) {
                        if (descrList.item(y2).getNodeType() == 1) {
                            accDescr = this.getTextValue((Element)descrList.item(y2));
                            break;
                        }
                        ++y2;
                    }
                    int pid = Integer.MIN_VALUE;
                    NodeList pidList = el.getElementsByTagName("pid");
                    y = 0;
                    while (y < pidList.getLength()) {
                        if (pidList.item(y).getNodeType() == 1) {
                            try {
                                pid = new Integer(this.getTextValue((Element)pidList.item(y)));
                                break;
                            }
                            catch (NumberFormatException e) {
                                this.warnings.add(new WarningException("deploy_4001", new String[]{"pid", this.getTextValue((Element)pidList.item(y))}).getLocalizedMessage());
                            }
                        }
                        ++y;
                    }
                    String[] secRoles = null;
                    Vector<String> tempRoles = new Vector<String>();
                    NodeList rolesList = el.getElementsByTagName("role-name");
                    int j = 0;
                    while (j < rolesList.getLength()) {
                        if (rolesList.item(j).getNodeType() == 1) {
                            tempRoles.add(this.getTextValue((Element)rolesList.item(j)));
                        }
                        ++j;
                    }
                    secRoles = tempRoles.toArray(new String[0]);
                    boolean unchecked = false;
                    NodeList uncheckedList = el.getElementsByTagName("unchecked");
                    int u = 0;
                    while (u < uncheckedList.getLength()) {
                        if (uncheckedList.item(u).getNodeType() == 1) {
                            unchecked = true;
                        }
                        ++u;
                    }
                    NodeList methodsList = el.getElementsByTagName("method");
                    int j2 = 0;
                    while (j2 < methodsList.getLength()) {
                        if (methodsList.item(j2).getNodeType() == 1) {
                            MethodEntry[] methodEntryes = this.getMethodXml((Element)methodsList.item(j2), result, this.loader);
                            int me = 0;
                            while (me < methodEntryes.length) {
                                boolean accessControlFound = false;
                                int ac = 0;
                                while (ac < accessControls.size()) {
                                    if (((AccessControls)accessControls.elementAt(ac)).isCompatible(methodEntryes[me])) {
                                        ((AccessControls)accessControls.elementAt(ac)).addSecurityRoles(secRoles);
                                        accessControlFound = true;
                                        break;
                                    }
                                    ++ac;
                                }
                                if (!accessControlFound) {
                                    AccessControls accCtrl = null;
                                    accCtrl = unchecked ? new AccessControls(accDescr, methodEntryes[me]) : new AccessControls(accDescr, secRoles, methodEntryes[me]);
                                    if (pid != Integer.MIN_VALUE) {
                                        accCtrl.setPid(pid);
                                    }
                                    accessControls.add(accCtrl);
                                }
                                ++me;
                            }
                        }
                        ++j2;
                    }
                } else if (tag.equals("container-transaction")) {
                    accDescr = null;
                    NodeList descrList = el.getElementsByTagName("description");
                    int y3 = 0;
                    while (y3 < descrList.getLength()) {
                        if (descrList.item(y3).getNodeType() == 1) {
                            accDescr = this.getTextValue((Element)descrList.item(y3));
                            break;
                        }
                        ++y3;
                    }
                    String transAttr = null;
                    NodeList transList = el.getElementsByTagName("trans-attribute");
                    y = 0;
                    while (y < transList.getLength()) {
                        if (transList.item(y).getNodeType() == 1) {
                            transAttr = this.getTextValue((Element)transList.item(y));
                            break;
                        }
                        ++y;
                    }
                    String isoLevel = null;
                    NodeList isoList = el.getElementsByTagName("isolation-level");
                    int y4 = 0;
                    while (y4 < isoList.getLength()) {
                        if (isoList.item(y4).getNodeType() == 1) {
                            isoLevel = this.convertIsolationLevel(this.getTextValue((Element)isoList.item(y4)));
                            break;
                        }
                        ++y4;
                    }
                    NodeList methodsList = el.getElementsByTagName("method");
                    int j = 0;
                    while (j < methodsList.getLength()) {
                        if (methodsList.item(j).getNodeType() == 1) {
                            MethodEntry[] methodEntryes = this.getMethodXml((Element)methodsList.item(j), result, this.loader);
                            int me = 0;
                            while (me < methodEntryes.length) {
                                ControlDescriptor ctrlDescr;
                                MethodEntry prevMethodEntry = null;
                                boolean attributeIsSet = false;
                                int k = 0;
                                while (k < controlDescriptors.size()) {
                                    prevMethodEntry = ((ControlDescriptor)controlDescriptors.elementAt(k)).getMethodEntry();
                                    if (prevMethodEntry.equals(methodEntryes[me])) {
                                        attributeIsSet = true;
                                        break;
                                    }
                                    ++k;
                                }
                                if (attributeIsSet) {
                                    if (prevMethodEntry.hasLowPriority(methodEntryes[me])) {
                                        controlDescriptors.removeElementAt(k);
                                        ctrlDescr = new ControlDescriptor(accDescr, methodEntryes[me], transAttr);
                                        if (isoLevel != null) {
                                            ctrlDescr.setIsolationLevel(isoLevel);
                                        }
                                        controlDescriptors.add(ctrlDescr);
                                    } else if (prevMethodEntry.hasEqualsPriority(methodEntryes[me])) {
                                        // empty if block
                                    }
                                } else {
                                    ctrlDescr = new ControlDescriptor(accDescr, methodEntryes[me], transAttr);
                                    if (isoLevel != null && !isoLevel.equals("None")) {
                                        ctrlDescr.setIsolationLevel(isoLevel);
                                    }
                                    controlDescriptors.add(ctrlDescr);
                                }
                                ++me;
                            }
                        }
                        ++j;
                    }
                } else if (tag.equals("exclude-list")) {
                    NodeList descrList = el.getElementsByTagName("description");
                    int y5 = 0;
                    while (y5 < descrList.getLength()) {
                        if (descrList.item(y5).getNodeType() == 1) {
                            result.setExcludeListDescription(this.getTextValue((Element)descrList.item(y5)));
                            break;
                        }
                        ++y5;
                    }
                    NodeList methodsList = el.getElementsByTagName("method");
                    int j = 0;
                    while (j < methodsList.getLength()) {
                        if (methodsList.item(j).getNodeType() == 1) {
                            MethodEntry[] methodEntryes = this.getMethodXml((Element)methodsList.item(j), result, this.loader);
                            int me = 0;
                            while (me < methodEntryes.length) {
                                excludeListMethods.add(methodEntryes[me]);
                                ++me;
                            }
                        }
                        ++j;
                    }
                }
            }
            ++i;
        }
        result.distributeSecurityRoles(securityRoles.toArray(new SecurityRoles[securityRoles.size()]));
        result.distributeCorrectControlDescriptors(controlDescriptors.toArray(new ControlDescriptor[controlDescriptors.size()]));
        result.distributeAccessControls(accessControls.toArray(new AccessControls[accessControls.size()]));
        result.distributeExcludeList(excludeListMethods.toArray(new MethodEntry[excludeListMethods.size()]));
    }

    private String convertIsolationLevel(String isoLevel) {
        if (isoLevel.equals("Commited") || isoLevel.equals("Committed")) {
            return "Uncommitted";
        }
        if (isoLevel.equals("Serializable")) {
            return "Repeatable";
        }
        return isoLevel;
    }

    private String convertClassName(String className) {
        if (className.charAt(0) != '[') {
            return className;
        }
        int first = className.indexOf(91);
        int last = className.lastIndexOf(91);
        char ch = className.charAt(last + 1);
        String st = "";
        int i = 0;
        while (i <= last - first) {
            st = st + "[]";
            ++i;
        }
        switch (ch) {
            case 'B': {
                return "byte" + st;
            }
            case 'C': {
                return "char" + st;
            }
            case 'D': {
                return "double" + st;
            }
            case 'F': {
                return "float" + st;
            }
            case 'I': {
                return "int" + st;
            }
            case 'J': {
                return "long" + st;
            }
            case 'S': {
                return "short" + st;
            }
            case 'Z': {
                return "boolean" + st;
            }
            case 'L': {
                return className.substring(last + 2, className.length() - 1) + st;
            }
        }
        return "";
    }

    private boolean primitive(String type) {
        return type == null || type.equals("int") || type.equals("byte") || type.equals("char") || type.equals("short") || type.equals("long") || type.equals("double") || type.equals("float") || type.equals("boolean") || type.equals("[B");
    }

    private boolean containsIn(String[] excludeMethods, String method, boolean sessionBean) {
        if (sessionBean && method.equals("remove")) {
            return true;
        }
        int i = 0;
        while (i < excludeMethods.length) {
            if (method.equals(excludeMethods[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public Vector getWarnings() {
        return this.warnings;
    }
}

